﻿//======================================================
//==     (c)2008 aspxcms inc by NeTCMS v1.0              ==
//==          Forum:bbs.aspxcms.com                   ==
//==         Website:www.aspxcms.com                  ==
//======================================================
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetCMS.Content;
using NetCMS.Content.Common;
using NetCMS.Model;

public partial class manage_survey_Item_Add : NetCMS.Web.UI.ManagePage
{
    Survey sur = new Survey();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack) //判断页面是否重载
        {
            //判断用户是否登录
            copyright.InnerHtml = CopyRight;//获取版权信息
            if (SiteID == "0")
            {
                param_id.InnerHtml = "<a href=\"setParam.aspx\" class=\"list_link\">系统参数设置</a>&nbsp;┊&nbsp;";
            }

            #region 选择类别,主题(新增选项时)
            DataTable dt = sur.sel_voteInfo(0);
            //显示类别主题
            if (dt != null)
            {
                foreach (DataRow r in dt.Rows)
                {
                    ListItem lit = new ListItem();
                    lit.Text = "类别:" + r["ClassName"].ToString() + "--" + "主题:" + r["Title"].ToString();
                    lit.Value = r["TID"].ToString();//选项所属主题TID
                    this.DdlTopic.Items.Add(lit);//新增加
                }
                dt.Clear();
            }
            this.HidIid.Value = "0";
            #endregion
            if (Request.QueryString["iid"] != null && Request.QueryString["iid"] != string.Empty)
            {
                int iid = int.Parse(Request.QueryString["iid"]);
                this.HidIid.Value = iid.ToString();
                this.LtrCap.Text = "修改";
                BindDate(iid);
            }
        }
    }

    /// <summary>
    /// 修改初始页面信息
    /// </summary>
    ///code by chenzhaohui

    void BindDate(int IID)
    {
        DataTable dt = sur.sel_voteById(IID, 2);
        if (dt.Rows.Count > 0)
        {
            this.DdlTopic.SelectedValue = dt.Rows[0]["TID"].ToString();
            this.TxtName.Text = dt.Rows[0]["ItemName"].ToString();
            if (dt.Rows[0]["ItemMode"] != DBNull.Value) this.DdlMode.SelectedValue = dt.Rows[0]["ItemMode"].ToString();
            if (dt.Rows[0]["PicSrc"] != DBNull.Value) this.TxtPicSrc.Text = dt.Rows[0]["PicSrc"].ToString();
            if (dt.Rows[0]["DisColor"] != DBNull.Value) this.TxtDisColor.Text = dt.Rows[0]["DisColor"].ToString();
            if (dt.Rows[0]["VoteCount"] != DBNull.Value) this.TxtVoteCount.Text = dt.Rows[0]["VoteCount"].ToString();
            if (dt.Rows[0]["ItemDetail"] != DBNull.Value) this.TxtDetail.Value = dt.Rows[0]["ItemDetail"].ToString();
        }
        else
        {
            PageError("未知错误,异常错误", "VoteItem.aspx");
        }
    }

    protected void BtnSave_ServerClick(object sender, EventArgs e)
    {
        if (Page.IsValid)//判断页面是否通过验证
        {
            VoteItemInfo info = new VoteItemInfo();
            info.IID = int.Parse(this.HidIid.Value);
            info.TID = int.Parse(this.DdlTopic.SelectedValue);
            info.ItemName = this.TxtName.Text;
            info.ItemMode = byte.Parse(this.DdlMode.SelectedValue);
            info.PicSrc = this.TxtPicSrc.Text.Trim();
            info.DisColor = this.TxtDisColor.Text.Trim();
            if (this.TxtVoteCount.Text.Trim() == string.Empty)
                info.VoteCount = 0;
            else
                info.VoteCount = int.Parse(this.TxtVoteCount.Text);
            info.ItemDetail = this.TxtDetail.Value.Trim();
            info.SiteID = NetCMS.Global.Current.SiteID;
            //载入数据-刷新页面
            int n = sur.EditItem(info);
            if (n != 0)
            {
                rootPublic rp = new rootPublic();
                string s = "新增";
                if (info.IID > 0)
                    s = "修改";
                rp.SaveUserAdminLogs(1, 1, UserNum, "问卷调查系统" + s + "选项", s + "成功");
                PageRight(s + "成功", "VoteItem.aspx");
            }
            else
            {
                PageError("意外错误：未知错误", "VoteItem.aspx");
            }

        }
    }
}
