﻿//======================================================
//==     (c)2008 aspxcms inc by NeTCMS v1.0              ==
//==          Forum:bbs.aspxcms.com                   ==
//==         Website:www.aspxcms.com                  ==
//======================================================
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetCMS.Content;
using NetCMS.Content.Common;
using NetCMS.Model;

public partial class manage_survey_VoteTopic : NetCMS.Web.UI.ManagePage
{
    Survey sur = new Survey();
    rootPublic rd = new rootPublic();
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 初始代码
        this.PageNavigator1.OnPageChange += new PageChangeHandler(PageNavigator1_PageChange);
        Response.CacheControl = "no-cache"; //清除缓存
        if (!IsPostBack)  //判断页面是否重载
        {
            //判断用户是否登录
            copyright.InnerHtml = CopyRight;   //获取版权信息
            if (SiteID == "0")
            {
                param_id.InnerHtml = "<a href=\"setParam.aspx\" class=\"list_link\">系统参数设置</a>&nbsp;┊&nbsp;";
            }

            //选择类别(新增主题时)

            if (Request.QueryString["type"] == "delone")
            {
                setTitleDel();
            }
            VoteTitleManage(1); //初始分页数据
        }
        #endregion
    }

    /// <summary>
    /// 分页
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="PageIndex"></param>

    protected void PageNavigator1_PageChange(object sender, int PageIndex)
    {
        VoteTitleManage(PageIndex);//管理页面分页查询
    }


    /// <summary>
    /// 删除单个
    /// </summary>
    /// code by chenzhaohui

    void setTitleDel()
    {
        int TID = int.Parse(Request.QueryString["ID"]);
        if (TID <= 0)
        {
            PageError("错误的参数传递!", "");
        }
        else
        {

            bool v1 = sur.Del_voteSql(TID, 5);
            bool v2 = sur.Del_voteSql(TID, 2);
            bool v3 = sur.Del_voteSql(TID, 3);
            bool v4 = sur.Del_voteSql(TID, 4);

            if (v1 && v2 && v3 && v4)
            {
                rd.SaveUserAdminLogs(1, 1, UserNum, "删除投票主题", "删除成功");
                PageRight("删除成功。", "VoteTopic.aspx");
            }
            else
            {
                PageError("意外错误：未知错误", "");
            }
        }
    }

    /// <summary>
    /// 管理列表
    /// </summary>
    /// <param name="PageIndex"></param>
    /// code by chenzhaohui

    protected void VoteTitleManage(int PageIndex)//显示投票类别管理页面
    {
        #region 查询条件语句判断
        string KeyWord = this.KeyWord.Text.Trim();//取得关键字的内容
        string type = this.DdlKwdType.SelectedValue;//取得选择的类型
        int i = 0, j = 0;
        int num = 20;//从参数设置里取得每页显示记录的条数
        DataTable dt = null;

        if (KeyWord != "" && KeyWord != null)//如果关键字处内容不为空,则按下面选择语句进行条件判断并传值
        {
            switch (type)
            {
                case "choose":
                    dt = NetCMS.Content.Pagination.GetPage("manage_survey_VoteTopic_1_aspx", PageIndex, num, out i, out j, null);//不跟条件进行查询，显示全部内容                   
                    break;
                case "title":
                    SQLConditionInfo st = new SQLConditionInfo("@Title", "%" + KeyWord + "%");
                    dt = NetCMS.Content.Pagination.GetPage("manage_survey_VoteTopic_2_aspx", PageIndex, num, out i, out j, st);//按照主题名查询相关内容                   
                    break;
                case "class":
                    DataTable dt1 = new DataTable();
                    dt1 = sur.sel_voteByStr(KeyWord, 2);
                    if (dt1 != null)
                    {
                        if (dt1.Rows.Count > 0)
                        {
                            for (int l = 0; l < dt1.Rows.Count; l++)
                            {
                                int Vid = int.Parse(dt1.Rows[l]["VID"].ToString());
                                SQLConditionInfo st1 = new SQLConditionInfo("@VID", "%" + Vid + "%");
                                dt = NetCMS.Content.Pagination.GetPage("manage_survey_VoteTopic_3_aspx", PageIndex, num, out i, out j, st1);//按照类名查询                              
                            }
                        }
                        else
                        {
                            dt = NetCMS.Content.Pagination.GetPage("manage_survey_VoteTopic_1_aspx", PageIndex, num, out i, out j, null);
                        }
                    }
                    else
                    {
                        dt = NetCMS.Content.Pagination.GetPage("manage_survey_VoteTopic_1_aspx", PageIndex, num, out i, out j, null);
                    }
                    break;
                case "starttime":
                    SQLConditionInfo st3 = new SQLConditionInfo("@StartDate", "%" + KeyWord + "%");
                    dt = NetCMS.Content.Pagination.GetPage("manage_survey_VoteTopic_4_aspx", PageIndex, num, out i, out j, st3);//按照开始时间查询
                    break;
                case "endtime":
                    SQLConditionInfo st4 = new SQLConditionInfo("@EndDate", "%" + KeyWord + "%");
                    dt = NetCMS.Content.Pagination.GetPage("manage_survey_VoteTopic_5_aspx", PageIndex, num, out i, out j, st4);//按照结束时间查询
                    break;
                case "itemmodel":
                    SQLConditionInfo st5 = new SQLConditionInfo("@ItemMode", "%" + KeyWord + "%");
                    dt = NetCMS.Content.Pagination.GetPage("manage_survey_VoteTopic_6_aspx", PageIndex, num, out i, out j, st5); //按照排列方式查询
                    break;
                default:
                    dt = NetCMS.Content.Pagination.GetPage("manage_survey_VoteTopic_1_aspx", PageIndex, num, out i, out j, null);
                    break;
            }
        }
        else
        {
            dt = NetCMS.Content.Pagination.GetPage("manage_survey_VoteTopic_1_aspx", PageIndex, num, out i, out j, null);
        }
        #endregion

        this.PageNavigator1.PageCount = j;
        this.PageNavigator1.PageIndex = PageIndex;
        this.PageNavigator1.RecordCount = i;
        DataList1.DataSource = dt;
        DataList1.DataBind();
    }
    /// <summary>
    /// 查询
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    /// code by chenzhaohui

    protected void BtnSearch_Click(object sender, EventArgs e)
    {
        VoteTitleManage(1);
    }

    /// <summary>
    /// 批量删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    /// code by chenzhaohui

    protected void DelP_Click(object sender, EventArgs e)
    {
        string vote_checkbox = Request.Form["vote_checkbox"];
        if (vote_checkbox == null || vote_checkbox == String.Empty)
        {
            PageError("请先选择批量操作的内容!", "");
        }
        else
        {
            String[] CheckboxArray = vote_checkbox.Split(',');
            vote_checkbox = null;
            for (int i = 0; i < CheckboxArray.Length; i++)
            {
                if (sur.del_voteSql(CheckboxArray[i], 1) != 0 && sur.del_voteSql(CheckboxArray[i], 1) != 0 && sur.del_voteSql(CheckboxArray[i], 2) != 0 && sur.del_voteSql(CheckboxArray[i], 3) != 0)
                {
                    rd.SaveUserAdminLogs(1, 1, UserNum, "批量删除投票主题", "删除成功");
                }
            }
            PageRight("删除数据成功,请返回继续操作!", "VoteTopic.aspx");
        }
    }


    /// <summary>
    /// 删除全部
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    /// code by chenzhaohui

    protected void DelAll_Click(object sender, EventArgs e)
    {
        if (sur.del_InfoVote(1) == 0)
        {
            PageError("意外错误：未知错误，可能是没找到记录。", "");
        }
        else
        {
            rd.SaveUserAdminLogs(1, 1, UserNum, "删除全部投票主题成功", "删除全部成功");
            PageRight("删除全部成功。", "VoteTopic.aspx");
        }
    }

    static protected string GetVoteType(object input)
    {
        if (input == null || input == DBNull.Value)
            return string.Empty;
        try
        {
            int n = Convert.ToInt32(input);
            if (n == 0)
                return "单选";
            else if (n == 1)
                return "多选";
            else
                return string.Empty;
        }
        catch
        {
            return string.Empty;
        }
    }
    static protected string GetDisMode(object input)
    {
        if (input == null || input == DBNull.Value)
            return string.Empty;
        try
        {
            int n = Convert.ToInt32(input);
            if (n == 0)
                return "柱形图";
            else if (n == 1)
                return "柱形图";
            else
                return string.Empty;
        }
        catch
        {
            return string.Empty;
        }
    }
    static protected string GetDateStr(object input)
    {
        if (input == null || input == DBNull.Value)
            return string.Empty;
        try
        {
            DateTime dt = Convert.ToDateTime(input);
            return dt.ToShortDateString();
        }
        catch
        {
            return string.Empty;
        }
    }
}
