﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;
using sql;

public partial class Admin_CaseManger : System.Web.UI.Page
{
    SqlDB sqldb = new SqlDB();
    Operation operate = new Operation();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            //if (Session["Admin"] == null)
            //{
            //    Response.Redirect("index.aspx");
            //}
            P2.Visible = false;
            P1.Visible = false;
            GridViewBind();
        }
    }
    /// <summary>
    /// 绑定GridView显示列表
    /// </summary>
    private void GridViewBind()
    {
        string strSql = "select * from [case]";
        operate.GridViewBind(GridView1, strSql);
    }
    /// <summary>
    /// 准备执行插入命令
    /// </summary>
    protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Insert")
        {
            P2.Visible = true;
            P1.Visible = false;
        }
    }
    /// <summary>
    /// 执行翻页命令
    /// </summary>
    protected void GridView1_OnPageIndexChanged(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        GridViewBind();
    }
    /// <summary>
    /// 执行删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        string id = GridView1.DataKeys[e.RowIndex].Value.ToString();
        string smallImg = sqldb.ExecuteScalar("select smallImage from [case] where caseId=" + id);
        string bigImg = sqldb.ExecuteScalar("select bigImage from [case] where caseId=" + id);
        string strSql = "delete from [case] where caseId=" + id;
        try
        {
            if (sqldb.ExecuteNonQueryCheck(strSql) > 0)
            {
                File.Delete(Server.MapPath("../images/case/images/" + smallImg));
                File.Delete(Server.MapPath("../images/case/images/" + bigImg));                
                GridViewBind();
                sql.Operation.Show_Msg("恭喜您，经典案例删除成功！");
            }
            else
            {
                sql.Operation.Show_Msg("经典案例删除失败，请重新删除！");
            }
        }
        catch (Exception ex)
        {
        }
        finally
        {
        }
    }
    /// <summary>
    /// 准备执行编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
    {
        P1.Visible = true;
        P2.Visible = false;
        string id = GridView1.DataKeys[e.NewEditIndex].Value.ToString();
        ViewState["id"] = id;
        string strSql = "select * from [case] where caseId=" + id;
        DataSet ds = sqldb.GetDS(strSql);
        txtCaseNameEdit.Text= ds.Tables[0].Rows[0]["caseName"].ToString();
        txtCaseDetailsEdit.Text = ds.Tables[0].Rows[0]["caseDescribe"].ToString();
        txtCaseAddressEdit.Text= ds.Tables[0].Rows[0]["caseUrl"].ToString();
        txtCaseMadeEdit.Text= ds.Tables[0].Rows[0]["caseMade"].ToString();
        txtCaseBelong.Text = ds.Tables[0].Rows[0]["caseBelong"].ToString();
        ds.Clear();

    }
    /// <summary>
    /// 取消添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancelAdd_Click(object sender, EventArgs e)
    {
        P2.Visible = false;
    }
    /// <summary>
    /// 取消编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCanelEdit_Click(object sender, EventArgs e)
    {
        P1.Visible = false;
    }
    /// <summary>
    /// 执行添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        string smallImage = sql.Operation.UpLoad(fuSmallImg, "../images/case/images/", "");
        string BigImage = sql.Operation.UpLoad(fuBigImg, "../images/case/images/", "");
        string allValues = "'" + sqldb.CheckString(txtcaseName.Text) + "','" + sqldb.CheckString(txtcaseDetails.Text) + "','" + sqldb.CheckString(txtCaseAddress.Text) + "','" + sqldb.CheckString(smallImage) + "','" + sqldb.CheckString(BigImage) + "','" + sqldb.CheckString(txtCaseMade.Text) + "','" + sqldb.CheckString(txtCaseBelong.Text) + "'";
        string strsql = "insert into [case](caseName,caseDescribe,caseUrl,smallImage,bigImage,caseMade,caseBelong) values(" + allValues + ")";
        if (sqldb.ExecuteNonQueryCheck(strsql) > 0)
        {
            txtcaseName.Text = "";
            txtcaseDetails.Text = "";
            txtCaseAddress.Text = "http://www.webzcn.cn";
            txtCaseMade.Text = "";
            txtCaseBelong.Text = "";
            P2.Visible = false;
            GridViewBind();
            sql.Operation.Show_Msg("恭喜您，经典案例添加成功！");
        }
        else
        {
            sql.Operation.Show_Msg("经典案例添加失败，请重试！");
        }
    }
    /// <summary>
    /// 执行编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnEdit_Click(object sender, EventArgs e)
    {
        string smallImage = sql.Operation.UpLoad(fuSmallImgEdit, "../images/case/images/", "");
        string BigImage = sql.Operation.UpLoad(fuBigImgEdit, "../images/case/images/", "");
        string strsql = "update [case] set caseName='" + sqldb.CheckString(txtCaseNameEdit.Text) + "',caseDescribe='" + sqldb.CheckString(txtCaseDetailsEdit.Text) + "',caseUrl='" + sqldb.CheckString(txtCaseAddressEdit.Text) + "',smallImage='" + sqldb.CheckString(smallImage) + "',bigImage='" + sqldb.CheckString(BigImage) + "',caseMade='" + sqldb.CheckString(txtCaseMadeEdit.Text) + "',caseBelong='" + sqldb.CheckString(txtCaseBelong.Text) + "' where caseId=" + ViewState["id"].ToString();
        if (sqldb.ExecuteNonQueryCheck(strsql) > 0)
        {
            txtcaseName.Text = "";
            txtcaseDetails.Text = "";
            txtCaseAddress.Text = "http://www.webzcn.cn";
            txtCaseMade.Text = "";
            txtCaseBelong.Text = "";
            P1.Visible = false;
            GridViewBind();
            sql.Operation.Show_Msg("恭喜您，经典案例修改成功！");
        }
        else
        {
            sql.Operation.Show_Msg("经典案例修改失败，请重试！");
        }
    }   
}
