﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using sql;

public partial class Admin_MyJob : System.Web.UI.Page
{
    SqlDB sqldb = new SqlDB();
    Operation operate = new Operation();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["Admin"] == null)
            {
                Response.Redirect("index.aspx");
            }
            P2.Visible = false;
            P1.Visible = false;
            GridViewBind();
        }
    }
    /// <summary>
    /// 绑定GridView显示列表
    /// </summary>
    private void GridViewBind()
    {
        string strSql = "select * from JobInfo order by JobId Desc";
        operate.GridViewBind(GridView1, strSql);
    }
    /// <summary>
    /// 准备执行插入命令
    /// </summary>
    protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Insert")
        {
            P2.Visible = true;
            P1.Visible = false;
        }
    }
    /// <summary>
    /// 执行翻页命令
    /// </summary>
    protected void GridView1_OnPageIndexChanged(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        GridViewBind();
    }
    /// <summary>
    /// 执行删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        string id = GridView1.DataKeys[e.RowIndex].Value.ToString();
        string strSql = "delete from JobInfo where JobId=" + id;
        string strJobNeed = "delete from JobNeed where JobId=" + id;
        if (sqldb.ExecuteNonQueryCheck(strSql) > 0 && sqldb.ExecuteNonQueryCheck(strJobNeed) > 0)
        {           
            GridViewBind();
            sql.Operation.Show_Msg("恭喜您，招聘信息删除成功！");
        }
        else
        {
            sql.Operation.Show_Msg("招聘信息删除失败，请重新删除！");
        }
       
    }
    /// <summary>
    /// 准备执行编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
    {
        P1.Visible = true;
        P2.Visible = false;
        string id = GridView1.DataKeys[e.NewEditIndex].Value.ToString();
        ViewState["id"] = id;
        string strSql = "select * from JobInfo as a,JobNeed as b where a.JobId=b.JobId and a.JobId=" + id;
        DataSet ds = sqldb.GetDS(strSql);
        txtNameEdit.Text = ds.Tables[0].Rows[0]["JobName"].ToString();
        txtAddressEdit.Text= ds.Tables[0].Rows[0]["JobAddress"].ToString();
        txtPersonEdit.Text= ds.Tables[0].Rows[0]["JobNeedPerson"].ToString();
        txtMoneyEdit.Text = ds.Tables[0].Rows[0]["JobMoney"].ToString();
        TxtSexEdit.Text = ds.Tables[0].Rows[0]["JobPersonSex"].ToString();
        txtAgeEdit.Text = ds.Tables[0].Rows[0]["JobPersonAge"].ToString();
        txtDegreeEdit.Text= ds.Tables[0].Rows[0]["JobPersonDegree"].ToString();
        txtLanguageEdit.Text= ds.Tables[0].Rows[0]["JobPersonLanguage"].ToString();
        txtExperienceEdit.Text= ds.Tables[0].Rows[0]["JobPersonExperience"].ToString();
        txtSkillEdit.Text=ds.Tables[0].Rows[0]["JobPersonMajor"].ToString();
        txtLevelEdit.Text= ds.Tables[0].Rows[0]["JobLevel"].ToString();
        txtSelectEdit.Text= ds.Tables[0].Rows[0]["JobSelect"].ToString();
        txtBelongEdit.Text= ds.Tables[0].Rows[0]["JobBelong"].ToString();
       
        
        txtContentEdit.Text= ds.Tables[0].Rows[0]["JobNeedContent"].ToString();
        txtCompetentEdit.Text = ds.Tables[0].Rows[0]["JobNeedCompetence"].ToString();
        txtSchoolEdit.Text= ds.Tables[0].Rows[0]["JobNeedSchool"].ToString();
        txtExperienceAllEdit.Text= ds.Tables[0].Rows[0]["JobNeedExperience"].ToString();
        txtAllSkillEdit.Text= ds.Tables[0].Rows[0]["JobNeedSkill"].ToString();
        txtAttritudeEdit.Text= ds.Tables[0].Rows[0]["JobNeedAttritude"].ToString();
        ds.Clear();

    }
    /// <summary>
    /// 取消添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancelAdd_Click(object sender, EventArgs e)
    {
        P2.Visible = false;
    }
    /// <summary>
    /// 取消编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCanelEdit_Click(object sender, EventArgs e)
    {
        P1.Visible = false;
    }
    /// <summary>
    /// 执行添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {

        string name =sqldb.CheckString(txtName.Text);
        string address = sqldb.CheckString(txtAddress.Text);
        string person = sqldb.CheckString(txtPerson.Text);
        string Money = sqldb.CheckString(txtMoney.Text);
        string Sex = sqldb.CheckString(ddlSex.SelectedItem.Text);
        string age = sqldb.CheckString(ddlAge.SelectedItem.Text);
        string Degree = sqldb.CheckString(ddlDegree.SelectedItem.Text);
        string language = sqldb.CheckString(ddlLanguage.SelectedItem.Text);
        string Experience = sqldb.CheckString(ddlExperience.SelectedItem.Text);
        string Skill = sqldb.CheckString(txtSkill.Text);
        string Level = sqldb.CheckString(ddlLevel.SelectedItem.Text);
        string select = sqldb.CheckString(ddlSelect.SelectedItem.Text);
        string Belong = sqldb.CheckString(txtBelong.Text);
        string Time = DateTime.Now.ToString();
        string allValues = "'" + name + "','" + address + "','" + person + "','" + Money + "','" + Time + "','" + Sex + "','" + age + "','" + Degree + "','" + language + "','" + Experience + "','" + Skill + "','" + Level + "','" + select + "','" + Belong + "'";
        string strsql = "insert into JobInfo(JobName,JobAddress,JobNeedPerson,JobMoney,JobTime,JobPersonSex,JobPersonAge,JobPersonDegree,JobPersonLanguage,JobPersonExperience,JobPersonMajor,JobLevel,JobSelect,JobBelong) values(" + allValues + ")";
        
        if (sqldb.ExecuteNonQueryCheck(strsql) > 0)
        {
            strsql = "select JobId from JobInfo where JobTime='"+Time+"'";
            int NeedId =Convert.ToInt32(sqldb.ExecuteScalar(strsql));
            string NeedContent = sqldb.CheckString(txtContent.Text);
            string NeedCompentence = sqldb.CheckString(txtCompetent.Text);
            string NeedSchool = sqldb.CheckString(txtSchool.Text);
            string NeedExperience = sqldb.CheckString(txtExperience.Text);
            string NeedSkill = sqldb.CheckString(txtAllSkill.Text);
            string NeedAttritude = sqldb.CheckString(txtAttritude.Text);
            allValues =NeedId+",'" + NeedContent + "','" + NeedCompentence + "','" + NeedSchool + "','" + NeedExperience + "','" + NeedSkill + "','" + NeedAttritude + "'";
            strsql = "insert into JobNeed values("+allValues+")";
            if (sqldb.ExecuteNonQueryCheck(strsql) > 0)
            {
                txtName.Text = txtAddress.Text = txtPerson.Text = txtMoney.Text = txtSkill.Text = txtBelong.Text = "";
                txtAddress.Text = "郑州市";
                txtMoney.Text = "面议";
                txtSkill.Text = "计算机科学与技术";
                txtBelong.Text = "不要求";
                txtContent.Text = txtCompetent.Text = txtSchool.Text = txtExperience.Text = txtAllSkill.Text = txtAttritude.Text = "暂无";
                P2.Visible = false;
                GridViewBind();    
                sql.Operation.Show_Msg("恭喜您，招聘信息及要求添加成功！");                
            }
            else
            {
                strsql = "delete from JobNeed where JobTime='" + Time + "'";
                sql.Operation.Show_Msg("招聘信息添加失败，请重试！");
            }                   
        }
        else
        {
            sql.Operation.Show_Msg("招聘信息添加失败，请重试！");
        }
    }
    /// <summary>
    /// 执行编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnEdit_Click(object sender, EventArgs e)
    {
        string name = sqldb.CheckString(txtNameEdit.Text);
        string address = sqldb.CheckString(txtAddressEdit.Text);
        string person = sqldb.CheckString(txtPersonEdit.Text);
        string Money = sqldb.CheckString(txtMoneyEdit.Text);
        string Sex = sqldb.CheckString(TxtSexEdit.Text);
        string age = sqldb.CheckString(txtAgeEdit.Text);
        string Degree = sqldb.CheckString(txtDegreeEdit.Text);
        string language = sqldb.CheckString(txtLanguageEdit.Text);
        string Experience = sqldb.CheckString(txtExperienceEdit.Text);
        string Skill = sqldb.CheckString(txtSkillEdit.Text);
        string Level = sqldb.CheckString(txtLevelEdit.Text);
        string select = sqldb.CheckString(txtSelectEdit.Text);
        string Belong = sqldb.CheckString(txtBelongEdit.Text);
        string Time = DateTime.Now.ToString();
        string strSql = "update JobInfo set JobName='" + name + "',JobAddress='" + address + "',JobNeedPerson='" + person + "',JobMoney='" + Money + "',JobTime='" + Time + "',JobPersonSex='" + Sex + "',JobPersonAge='" + age + "',JobPersonDegree='" + Degree + "',JobPersonLanguage='" + language + "',JobPersonExperience='" + Experience + "',JobPersonMajor='" + Skill + "',JobLevel='" + Level + "',JobSelect='" + select + "',JobBelong='" + Belong + "' where JobId=" + ViewState["id"].ToString();

        string NeedContent = sqldb.CheckString(txtContentEdit.Text);
        string NeedCompentence = sqldb.CheckString(txtCompetentEdit.Text);
        string NeedSchool = sqldb.CheckString(txtSchoolEdit.Text);
        string NeedExperience = sqldb.CheckString(txtExperienceAllEdit.Text);
        string NeedSkill = sqldb.CheckString(txtAllSkillEdit.Text);
        string NeedAttritude = sqldb.CheckString(txtAttritudeEdit.Text);

        string strJobNeed = "update JobNeed set JobNeedContent='" + NeedContent + "',JobNeedCompetence='" + NeedCompentence + "',JobNeedSchool='" + NeedSchool + "',JobNeedExperience='" + NeedExperience + "',JobNeedSkill='" + NeedSkill + "',JobNeedAttritude='" + NeedAttritude + "' where JobId=" + ViewState["id"].ToString();
        if (sqldb.ExecuteNonQueryCheck(strSql) > 0 && sqldb.ExecuteNonQueryCheck(strJobNeed) > 0)
        {
            P1.Visible = false;
            GridViewBind();
            sql.Operation.Show_Msg("恭喜您，招聘信息及要求修改修改成功！");
        }
        else
        {
            sql.Operation.Show_Msg("招聘信息及要求修改失败，请重试！");
        }
    }
    protected void ddlSexEdit_SelectedIndexChanged(object sender, EventArgs e)
    {
        TxtSexEdit.Text = ddlSexEdit.SelectedItem.Text;
    }
    protected void ddlAgeEdit_TextChanged(object sender, EventArgs e)
    {
        txtAgeEdit.Text = ddlAgeEdit.SelectedItem.Text;
    }
    protected void ddlDegreeEdit_SelectedIndexChanged(object sender, EventArgs e)
    {
        txtDegreeEdit.Text = ddlDegreeEdit.SelectedItem.Text;
    }
    protected void ddlLanguageEdit_SelectedIndexChanged(object sender, EventArgs e)
    {
        txtLanguageEdit.Text = ddlLanguageEdit.SelectedItem.Text;
    }
    protected void ddlExperienceEdit_SelectedIndexChanged(object sender, EventArgs e)
    {
        txtExperienceEdit.Text = ddlExperienceEdit.SelectedItem.Text;
    }
    protected void ddlLevelEdit_SelectedIndexChanged(object sender, EventArgs e)
    {
        txtLevelEdit.Text = ddlLevelEdit.SelectedItem.Text;
    }
    protected void ddlSelectEdit_SelectedIndexChanged(object sender, EventArgs e)
    {
        txtSelectEdit.Text = ddlSelectEdit.SelectedItem.Text;
    }
}
