﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using sql;

public partial class Admin_SoftWareDocManger : System.Web.UI.Page
{
    SqlDB sqldb = new SqlDB();
    Operation operate = new Operation();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["Admin"] == null)
            {
                Response.Redirect("index.aspx");
            }
            P2.Visible = false;
            P1.Visible = false;
            GridViewBind();
            DropDownListBind();
            DropDownListBindEdit();
        }
    }
    /// <summary>
    /// 绑定GridView显示列表
    /// </summary>
    private void GridViewBind()
    {
        string strSql = "select a.softwareDocId,a.softwareDocName,a.softwareDocFrom,a.softwareDocDate,b.softwareId,b.softwareName,c.softwaretypeId,c.softwaretypeName from softwareDoc as a,software as b,softwareType as c where a.softwareId=b.softwareId and a.softwareTypeId=c.softwaretypeId";
        operate.GridViewBind(GridView1, strSql);
    }
    //绑定添加时的软件类型
    private void DropDownListBind()
    {
        string strSql = "select softwaretypeId,softwareTypeName from softwareType";
        operate.DropDownListBind(ddlAddsoftwareType, strSql, "softwareTypeName", "softwaretypeId");
        DropDownListBindServer(ddlAddsoftware, ddlAddsoftwareType.SelectedItem.Value.ToString());
    }
    //绑定修改时的软件类型
    private void DropDownListBindEdit()
    {
        string strSql = "select softwaretypeId,softwareTypeName from softwareType";
        operate.DropDownListBind(ddlEditsoftwareType, strSql, "softwareTypeName", "softwaretypeId");
        DropDownListBindServer(ddlEditsoftware, ddlEditsoftwareType.SelectedItem.Value.ToString());
    }
    /// <summary>
    /// 根据软件类型列表中被选中的值填充软件下拉列表
    /// </summary>
    /// <param name="serverTypeId">当前软件类型编号</param>
    private void DropDownListBindServer(DropDownList ddl, string serverTypeId)
    {
        string strSql = "select softwareId,softwareName from software where softwaretypeId=" + serverTypeId;
        operate.DropDownListBind(ddl, strSql, "softwareName", "softwareId");
    }
    /// <summary>
    /// 准备执行插入命令
    /// </summary>
    protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Insert")
        {
            P2.Visible = true;
            P1.Visible = false;
        }
    }
    /// <summary>
    /// 执行翻页命令
    /// </summary>
    protected void GridView1_OnPageIndexChanged(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        GridViewBind();
    }
    /// <summary>
    /// 执行删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        string id = GridView1.DataKeys[e.RowIndex].Value.ToString();
        string strSql = "delete from softwareDoc where softwareDocId=" + id;
        if (sqldb.ExecuteNonQueryCheck(strSql) > 0)
        {
            GridViewBind();
            sql.Operation.Show_Msg("恭喜您，软件文档删除成功！");
        }
        else
        {
            sql.Operation.Show_Msg("软件文档删除失败，请重新删除！");
        }

    }
    /// <summary>
    /// 准备执行编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
    {
        P1.Visible = true;
        P2.Visible = false;
        string id = GridView1.DataKeys[e.NewEditIndex].Value.ToString();
        ViewState["id"] = id;
        string strSql = "select * from softwareDoc where softwareDocId=" + id;
        DataSet ds = sqldb.GetDS(strSql);
        txtDocNameEdit.Text = ds.Tables[0].Rows[0]["softwareDocName"].ToString();
        txtDocFromEdit.Text = ds.Tables[0].Rows[0]["softwareDocFrom"].ToString();
        txtDocDetailsEdit.Text = ds.Tables[0].Rows[0]["softwareDocDetails"].ToString();
        ds.Clear();

    }
    /// <summary>
    /// 取消添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancelAdd_Click(object sender, EventArgs e)
    {
        P2.Visible = false;
    }
    /// <summary>
    /// 取消编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCanelEdit_Click(object sender, EventArgs e)
    {
        P1.Visible = false;
    }
    /// <summary>
    /// 执行添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {

        string softwareTypeId = ddlAddsoftwareType.SelectedItem.Value.ToString();
        string softwareId = ddlAddsoftware.SelectedItem.Value.ToString();
        string allValues = "'" + sqldb.CheckString(txtDocName.Text) + "','" + sqldb.CheckString(txtDocFrom.Text) + "','" + DateTime.Now + "','" + sqldb.CheckString(txtDocDetails.Text) + "'," + softwareId + "," + softwareTypeId;
        string strsql = "insert into softwareDoc(softwareDocName,softwareDocFrom,softwareDocDate,softwareDocDetails,softwareId,softwareTypeId) values(" + allValues + ")";
        if (sqldb.ExecuteNonQueryCheck(strsql) > 0)
        {
            txtDocName.Text = "";
            txtDocFrom.Text = "原创";
            txtDocDetails.Text = "";
            P2.Visible = false;
            GridViewBind();
            DropDownListBind();
            sql.Operation.Show_Msg("恭喜您，软件文档发表成功！");
        }
        else
        {
            sql.Operation.Show_Msg("软件文档发表失败，请重试！");
        }
    }
    /// <summary>
    /// 执行编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnEdit_Click(object sender, EventArgs e)
    {
        string softwareTypeId = ddlEditsoftwareType.SelectedItem.Value.ToString();
        string softwareId = ddlEditsoftware.SelectedItem.Value.ToString();
        string strsql = "update softwareDoc set softwareDocName='" + sqldb.CheckString(txtDocNameEdit.Text) + "',softwareDocFrom='" + sqldb.CheckString(txtDocFromEdit.Text) + "',softwareDocDate='" + DateTime.Now + "',softwareDocDetails='" + sqldb.CheckString(txtDocDetailsEdit.Text) + "',softwareId='" + softwareId + "',softwareTypeId='" + softwareTypeId + "' where softwareDocId=" + ViewState["id"].ToString();
        if (sqldb.ExecuteNonQueryCheck(strsql) > 0)
        {
            txtDocNameEdit.Text = "";
            txtDocFromEdit.Text = "原创";
            txtDocDetailsEdit.Text = "";
            P1.Visible = false;
            GridViewBind();
            DropDownListBindEdit();
            sql.Operation.Show_Msg("恭喜您，软件文档修改成功！");
        }
        else
        {
            sql.Operation.Show_Msg("软件文档修改失败，请重试！");
        }
    }
    protected void ddlAddsoftwareType_SelectedIndexChanged(object sender, EventArgs e)
    {
        DropDownListBindServer(ddlAddsoftware, ddlAddsoftwareType.SelectedItem.Value.ToString());
    }
    protected void ddlEditsoftwareType_SelectedIndexChanged(object sender, EventArgs e)
    {
        DropDownListBindServer(ddlEditsoftware, ddlEditsoftwareType.SelectedItem.Value.ToString());
    }
}
