﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;
using sql;

public partial class Admin_SoftWareManger : System.Web.UI.Page
{
    SqlDB sqldb = new SqlDB();
    Operation operate = new Operation();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["Admin"] == null)
            {
                Response.Redirect("index.aspx");
            }
            P2.Visible = false;
            P1.Visible = false;
            GridViewBind();
            DropDownListBind();
        }
    }
    /// <summary>
    /// 绑定GridView显示列表
    /// </summary>
    private void GridViewBind()
    {
        string strSql = "select a.softwareId,a.softwareName,b.softwaretypeId,b.softwareTypeName from software as a,softwaretype as b where a.softwareTypeId=b.softwaretypeId";
        operate.GridViewBind(GridView1, strSql);
    }
    private void DropDownListBind()
    {
        string strSql = "select softwareTypeId,softwareTypeName from softwareType";
        operate.DropDownListBind(DropDownList1, strSql, "softwareTypeName", "softwareTypeId");
        operate.DropDownListBind(DropDownList2, strSql, "softwareTypeName", "softwareTypeId");
    }
    /// <summary>
    /// 准备执行插入命令
    /// </summary>
    protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Insert")
        {
            P2.Visible = true;
            P1.Visible = false;
        }
    }
    /// <summary>
    /// 执行翻页命令
    /// </summary>
    protected void GridView1_OnPageIndexChanged(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        GridViewBind();
    }
    /// <summary>
    /// 执行删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        string id = GridView1.DataKeys[e.RowIndex].Value.ToString();
        string strSql = "delete from software where softwareId=" + id;
        try
        {
            if (sqldb.ExecuteNonQueryCheck(strSql) > 0)
            {
                sqldb.ExecuteNonQuery(strSql);
                //删除软件表中对应该类型的软件文档
                strSql = "delete from softwareDoc where softwareId=" + id;
                sqldb.ExecuteNonQuery(strSql);
                GridViewBind();
                sql.Operation.Show_Msg("恭喜您，软件删除成功！");
            }
            else
            {
                sql.Operation.Show_Msg("软件删除失败，请重新删除！");
            }
        }
        catch (Exception ex)
        {
        }
        finally
        {
        }
    }
    /// <summary>
    /// 准备执行编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
    {
        P1.Visible = true;
        P2.Visible = false;
        string id = GridView1.DataKeys[e.NewEditIndex].Value.ToString();
        ViewState["id"] = id;
        string strSql = "select * from software where softwareId=" + id;
        DataSet ds = sqldb.GetDS(strSql);
        txtTitleEdit.Text = ds.Tables[0].Rows[0]["softwareName"].ToString();
        ds.Clear();

    }
    /// <summary>
    /// 取消添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancelAdd_Click(object sender, EventArgs e)
    {
        P2.Visible = false;
    }
    /// <summary>
    /// 取消编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCanelEdit_Click(object sender, EventArgs e)
    {
        P1.Visible = false;
    }
    /// <summary>
    /// 执行添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        string softwareTypeId = DropDownList1.SelectedItem.Value.ToString();
        string allValues = "'" + sqldb.CheckString(txtTitle.Text) + "'," + softwareTypeId;
        string strsql = "insert into software(softwareName,softwareTypeId) values(" + allValues + ")";
        if (sqldb.ExecuteNonQueryCheck(strsql) > 0)
        {
            txtTitle.Text = "";
            P2.Visible = false;
            GridViewBind();
            DropDownListBind();
            sql.Operation.Show_Msg("恭喜您，软件添加成功！");
        }
        else
        {
            sql.Operation.Show_Msg("软件添加失败，请重试！");
        }
    }
    /// <summary>
    /// 执行编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnEdit_Click(object sender, EventArgs e)
    {
        string strsql = "update software set softwareName='" + sqldb.CheckString(txtTitleEdit.Text.Trim()) + "',softwaretypeId=" + DropDownList2.SelectedItem.Value.ToString() + " where softwareId=" + ViewState["id"].ToString();
        if (sqldb.ExecuteNonQueryCheck(strsql) > 0)
        {
            txtTitleEdit.Text = "";
            P1.Visible = false;
            GridViewBind();
            DropDownListBind();
            sql.Operation.Show_Msg("恭喜您，软件修改成功！");
        }
        else
        {
            sql.Operation.Show_Msg("软件修改失败，请重试！");
        }
    }
}
