﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using sql;
using System.IO;

public partial class Admin_SoftwareTypeManger : System.Web.UI.Page
{
    SqlDB sqldb = new SqlDB();
    Operation operate = new Operation();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["Admin"] == null)
            {
                Response.Redirect("index.aspx");
            }
            P2.Visible = false;
            P1.Visible = false;
            GridViewBind();
        }
    }
    /// <summary>
    /// 绑定GridView显示列表
    /// </summary>
    private void GridViewBind()
    {
        string strSql = "select * from SoftwareType";
        operate.GridViewBind(GridView1, strSql);
    }
    /// <summary>
    /// 准备执行插入命令
    /// </summary>
    protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Insert")
        {
            P2.Visible = true;
            P1.Visible = false;
        }
    }
    /// <summary>
    /// 执行翻页命令
    /// </summary>
    protected void GridView1_OnPageIndexChanged(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        GridViewBind();
    }
    /// <summary>
    /// 执行删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        string id = GridView1.DataKeys[e.RowIndex].Value.ToString();
        string logoImage = sqldb.ExecuteScalar("select SoftwareTypeLogoImage from SoftwareType where SoftwareTypeId=" + id);
        string TitleImage = sqldb.ExecuteScalar("select SoftwareTypeSportImage from SoftwareType where SoftwareTypeId=" + id);
        string strSql = "delete from SoftwareType where SoftwareTypeId=" + id;
        try
        {
            if (sqldb.ExecuteNonQueryCheck(strSql) > 0)
            {
                File.Delete(Server.MapPath("../images/Software/" + logoImage));
                File.Delete(Server.MapPath("../images/Software/" + TitleImage));
                //删除软件表中对应该类型的软件
                strSql = "delete from software where SoftwareTypeId=" + id;
                sqldb.ExecuteNonQuery(strSql);
                //删除软件表中对应该类型的软件文档
                strSql = "delete from softwareDoc where SoftwareTypeId=" + id;
                sqldb.ExecuteNonQuery(strSql);
                GridViewBind();
                sql.Operation.Show_Msg("恭喜您，软件类型删除成功！");
            }
            else
            {
                sql.Operation.Show_Msg("软件类型删除失败，请重新删除！");
            }
        }
        catch (Exception ex)
        {
        }
        finally
        {
        }
    }
    /// <summary>
    /// 准备执行编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
    {
        P1.Visible = true;
        P2.Visible = false;
        string id = GridView1.DataKeys[e.NewEditIndex].Value.ToString();
        ViewState["id"] = id;
        string strSql = "select * from SoftwareType where SoftwareTypeId=" + id;
        DataSet ds = sqldb.GetDS(strSql);
        txtTitleEdit.Text = ds.Tables[0].Rows[0]["SoftwareTypeName"].ToString();
        txtContentEdit.Text = ds.Tables[0].Rows[0]["SoftwareTypeTitle"].ToString();
        ds.Clear();

    }
    /// <summary>
    /// 取消添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancelAdd_Click(object sender, EventArgs e)
    {
        P2.Visible = false;
    }
    /// <summary>
    /// 取消编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCanelEdit_Click(object sender, EventArgs e)
    {
        P1.Visible = false;
    }
    /// <summary>
    /// 执行添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        string titleImage = sql.Operation.UpLoad(fulTitleImg, "../images/Software/", "");
        string LogoImage = sql.Operation.UpLoad(fulLogoImg, "../images/Software/", "");
        string allValues = "'" + sqldb.CheckString(txtTitle.Text) + "','" + sqldb.CheckString(txtContent.Text) + "','" + sqldb.CheckString(titleImage) + "','" + sqldb.CheckString(LogoImage) + "'";
        string strsql = "insert into SoftwareType(SoftwareTypeName,SoftwareTypeTitle,SoftwareTypeSportImage,SoftwareTypeLogoImage) values(" + allValues + ")";
        if (sqldb.ExecuteNonQueryCheck(strsql) > 0)
        {
            txtTitle.Text = "";
            txtContent.Text = "";
            P2.Visible = false;
            GridViewBind();
            sql.Operation.Show_Msg("恭喜您，软件类型添加成功！");
        }
        else
        {
            sql.Operation.Show_Msg("软件类型添加失败，请重试！");
        }
    }
    /// <summary>
    /// 执行编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnEdit_Click(object sender, EventArgs e)
    {
        string titleImage = sql.Operation.UpLoad(fulTitleimageEdit, "../images/Software/", "");
        string LogoImage = sql.Operation.UpLoad(fulLogoimageEdit, "../images/Software/", "");
        string strsql = "update SoftwareType set SoftwareTypeName='" + sqldb.CheckString(txtTitleEdit.Text.Trim()) + "',SoftwareTypetitle='" + sqldb.CheckString(txtContentEdit.Text) + "',SoftwareTypeSportImage='" + sqldb.CheckString(titleImage) + "',SoftwareTypeLogoImage='" + sqldb.CheckString(LogoImage) + "' where SoftwareTypeId=" + ViewState["id"].ToString();
        if (sqldb.ExecuteNonQueryCheck(strsql) > 0)
        {
            txtTitleEdit.Text = "";
            txtContentEdit.Text = "";
            P1.Visible = false;
            GridViewBind();
            sql.Operation.Show_Msg("恭喜您，软件类型修改成功！");
        }
        else
        {
            sql.Operation.Show_Msg("软件类型修改失败，请重试！");
        }
    }   
}
