﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using sql;

public partial class Admin_WebSiteDocManger : System.Web.UI.Page
{
    SqlDB sqldb = new SqlDB();
    Operation operate = new Operation();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["Admin"] == null)
            {
                Response.Redirect("index.aspx");
            }
            P2.Visible = false;
            P1.Visible = false;
            GridViewBind();
            DropDownListBind();
            DropDownListBindEdit();
        }
    }
    /// <summary>
    /// 绑定GridView显示列表
    /// </summary>
    private void GridViewBind()
    {
        string strSql = "select a.WebSiteDocId,a.WebSiteDocName,a.WebSiteDocFrom,a.WebSiteDocDate,b.WebSiteId,b.WebSiteName,c.WebSitetypeId,c.WebSitetypeName from WebSiteDoc as a,WebSite as b,WebSiteType as c where a.WebSiteId=b.WebSiteId and a.WebSiteTypeId=c.WebSitetypeId";
        operate.GridViewBind(GridView1, strSql);
    }
    //绑定添加时的网站类型
    private void DropDownListBind()
    {
        string strSql = "select WebSitetypeId,WebSiteTypeName from WebSiteType";
        operate.DropDownListBind(ddlAddWebSiteType, strSql, "WebSiteTypeName", "WebSitetypeId");
        DropDownListBindServer(ddlAddWebSite, ddlAddWebSiteType.SelectedItem.Value.ToString());
    }
    //绑定修改时的网站类型
    private void DropDownListBindEdit()
    {
        string strSql = "select WebSitetypeId,WebSiteTypeName from WebSiteType";
        operate.DropDownListBind(ddlEditWebSiteType, strSql, "WebSiteTypeName", "WebSitetypeId");
        DropDownListBindServer(ddlEditWebSite, ddlEditWebSiteType.SelectedItem.Value.ToString());
    }
    /// <summary>
    /// 根据网站类型列表中被选中的值填充网站下拉列表
    /// </summary>
    /// <param name="serverTypeId">当前网站类型编号</param>
    private void DropDownListBindServer(DropDownList ddl, string serverTypeId)
    {
        string strSql = "select WebSiteId,WebSiteName from WebSite where WebSitetypeId=" + serverTypeId;
        operate.DropDownListBind(ddl, strSql, "WebSiteName", "WebSiteId");
    }
    /// <summary>
    /// 准备执行插入命令
    /// </summary>
    protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Insert")
        {
            P2.Visible = true;
            P1.Visible = false;
        }
    }
    /// <summary>
    /// 执行翻页命令
    /// </summary>
    protected void GridView1_OnPageIndexChanged(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        GridViewBind();
    }
    /// <summary>
    /// 执行删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        string id = GridView1.DataKeys[e.RowIndex].Value.ToString();
        string strSql = "delete from WebSiteDoc where WebSiteDocId=" + id;
        if (sqldb.ExecuteNonQueryCheck(strSql) > 0)
        {
            GridViewBind();
            sql.Operation.Show_Msg("恭喜您，网站文档删除成功！");
        }
        else
        {
            sql.Operation.Show_Msg("网站文档删除失败，请重新删除！");
        }

    }
    /// <summary>
    /// 准备执行编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
    {
        P1.Visible = true;
        P2.Visible = false;
        string id = GridView1.DataKeys[e.NewEditIndex].Value.ToString();
        ViewState["id"] = id;
        string strSql = "select * from WebSiteDoc where WebSiteDocId=" + id;
        DataSet ds = sqldb.GetDS(strSql);
        txtDocNameEdit.Text = ds.Tables[0].Rows[0]["WebSiteDocName"].ToString();
        txtDocFromEdit.Text = ds.Tables[0].Rows[0]["WebSiteDocFrom"].ToString();
        txtDocDetailsEdit.Text = ds.Tables[0].Rows[0]["WebSiteDocDetails"].ToString();
        ds.Clear();

    }
    /// <summary>
    /// 取消添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancelAdd_Click(object sender, EventArgs e)
    {
        P2.Visible = false;
    }
    /// <summary>
    /// 取消编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCanelEdit_Click(object sender, EventArgs e)
    {
        P1.Visible = false;
    }
    /// <summary>
    /// 执行添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {

        string WebSiteTypeId = ddlAddWebSiteType.SelectedItem.Value.ToString();
        string WebSiteId = ddlAddWebSite.SelectedItem.Value.ToString();
        string allValues = "'" + sqldb.CheckString(txtDocName.Text) + "','" + sqldb.CheckString(txtDocFrom.Text) + "','" + DateTime.Now + "','" + sqldb.CheckString(txtDocDetails.Text) + "'," + WebSiteId + "," + WebSiteTypeId;
        string strsql = "insert into WebSiteDoc(WebSiteDocName,WebSiteDocFrom,WebSiteDocDate,WebSiteDocDetails,WebSiteId,WebSiteTypeId) values(" + allValues + ")";
        if (sqldb.ExecuteNonQueryCheck(strsql) > 0)
        {
            txtDocName.Text = "";
            txtDocFrom.Text = "原创";
            txtDocDetails.Text = "";
            P2.Visible = false;
            GridViewBind();
            DropDownListBind();
            sql.Operation.Show_Msg("恭喜您，网站文档发表成功！");
        }
        else
        {
            sql.Operation.Show_Msg("网站文档发表失败，请重试！");
        }
    }
    /// <summary>
    /// 执行编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnEdit_Click(object sender, EventArgs e)
    {
        string WebSiteTypeId = ddlEditWebSiteType.SelectedItem.Value.ToString();
        string WebSiteId = ddlEditWebSite.SelectedItem.Value.ToString();
        string strsql = "update WebSiteDoc set WebSiteDocName='" + sqldb.CheckString(txtDocNameEdit.Text) + "',WebSiteDocFrom='" + sqldb.CheckString(txtDocFromEdit.Text) + "',WebSiteDocDate='" + DateTime.Now + "',WebSiteDocDetails='" + sqldb.CheckString(txtDocDetailsEdit.Text) + "',WebSiteId='" + WebSiteId + "',WebSiteTypeId='" + WebSiteTypeId + "' where WebSiteDocId=" + ViewState["id"].ToString();
        if (sqldb.ExecuteNonQueryCheck(strsql) > 0)
        {
            txtDocNameEdit.Text = "";
            txtDocFromEdit.Text = "原创";
            txtDocDetailsEdit.Text = "";
            P1.Visible = false;
            GridViewBind();
            DropDownListBindEdit();
            sql.Operation.Show_Msg("恭喜您，网站文档修改成功！");
        }
        else
        {
            sql.Operation.Show_Msg("网站文档修改失败，请重试！");
        }
    }
    protected void ddlAddWebSiteType_SelectedIndexChanged(object sender, EventArgs e)
    {
        DropDownListBindServer(ddlAddWebSite, ddlAddWebSiteType.SelectedItem.Value.ToString());
    }
    protected void ddlEditWebSiteType_SelectedIndexChanged(object sender, EventArgs e)
    {
        DropDownListBindServer(ddlEditWebSite, ddlEditWebSiteType.SelectedItem.Value.ToString());
    }
}
