﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using sql;
using System.IO;

public partial class Admin_WebSiteManger : System.Web.UI.Page
{
    SqlDB sqldb = new SqlDB();
    Operation operate = new Operation();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["Admin"] == null)
            {
                Response.Redirect("index.aspx");
            }
            P2.Visible = false;
            P1.Visible = false;
            GridViewBind();
        }
    }
    /// <summary>
    /// 绑定GridView显示列表
    /// </summary>
    private void GridViewBind()
    {
        string strSql = "select * from WebSiteType";
        operate.GridViewBind(GridView1, strSql);
    }
    /// <summary>
    /// 准备执行插入命令
    /// </summary>
    protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Insert")
        {
            P2.Visible = true;
            P1.Visible = false;
        }
    }
    /// <summary>
    /// 执行翻页命令
    /// </summary>
    protected void GridView1_OnPageIndexChanged(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        GridViewBind();
    }
    /// <summary>
    /// 执行删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        string id = GridView1.DataKeys[e.RowIndex].Value.ToString();
        string logoImage = sqldb.ExecuteScalar("select WebSiteTypeLogoImage from WebSiteType where WebSiteTypeId=" + id);
        string TitleImage = sqldb.ExecuteScalar("select WebSiteTypeSportImage from WebSiteType where WebSiteTypeId=" + id);
        string strSql = "delete from WebSiteType where WebSiteTypeId=" + id;
        try
        {
            if (sqldb.ExecuteNonQueryCheck(strSql) > 0)
            {
                File.Delete(Server.MapPath("../images/WebSite/" + logoImage));
                File.Delete(Server.MapPath("../images/WebSite/" + TitleImage));
                //删除网站表中对应该类型的网站
                strSql = "delete from WebSite where WebSiteTypeId=" + id;
                sqldb.ExecuteNonQuery(strSql);
                //删除网站表中对应该类型的网站文档
                strSql = "delete from WebSiteDoc where WebSiteTypeId=" + id;
                sqldb.ExecuteNonQuery(strSql);
                GridViewBind();
                sql.Operation.Show_Msg("恭喜您，网站类型删除成功！");
            }
            else
            {
                sql.Operation.Show_Msg("网站类型删除失败，请重新删除！");
            }
        }
        catch (Exception ex)
        {
        }
        finally
        {
        }
    }
    /// <summary>
    /// 准备执行编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
    {
        P1.Visible = true;
        P2.Visible = false;
        string id = GridView1.DataKeys[e.NewEditIndex].Value.ToString();
        ViewState["id"] = id;
        string strSql = "select * from WebSiteType where WebSiteTypeId=" + id;
        DataSet ds = sqldb.GetDS(strSql);
        txtTitleEdit.Text = ds.Tables[0].Rows[0]["WebSiteTypeName"].ToString();
        txtContentEdit.Text = ds.Tables[0].Rows[0]["WebSiteTypeTitle"].ToString();
        ds.Clear();

    }
    /// <summary>
    /// 取消添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancelAdd_Click(object sender, EventArgs e)
    {
        P2.Visible = false;
    }
    /// <summary>
    /// 取消编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCanelEdit_Click(object sender, EventArgs e)
    {
        P1.Visible = false;
    }
    /// <summary>
    /// 执行添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        string titleImage = sql.Operation.UpLoad(fulTitleImg, "../images/WebSite/", "");
        string LogoImage = sql.Operation.UpLoad(fulLogoImg, "../images/WebSite/", "");
        string allValues = "'" + sqldb.CheckString(txtTitle.Text) + "','" + sqldb.CheckString(txtContent.Text) + "','" + sqldb.CheckString(titleImage) + "','" + sqldb.CheckString(LogoImage) + "'";
        string strsql = "insert into WebSiteType(WebSitetypeName,WebSiteTypeTitle,WebSitetypeSportImage,WebSiteTypeLogoImage) values(" + allValues + ")";
        if (sqldb.ExecuteNonQueryCheck(strsql) > 0)
        {
            txtTitle.Text = "";
            txtContent.Text = "";
            P2.Visible = false;
            GridViewBind();
            sql.Operation.Show_Msg("恭喜您，网站类型添加成功！");
        }
        else
        {
            sql.Operation.Show_Msg("网站类型添加失败，请重试！");
        }
    }
    /// <summary>
    /// 执行编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnEdit_Click(object sender, EventArgs e)
    {
        string titleImage = sql.Operation.UpLoad(fulTitleimageEdit, "../images/WebSite/", "");
        string LogoImage = sql.Operation.UpLoad(fulLogoimageEdit, "../images/WebSite/", "");
        string strsql = "update WebSiteType set WebSitetypeName='" + sqldb.CheckString(txtTitleEdit.Text.Trim()) + "',WebSitetypetitle='" + sqldb.CheckString(txtContentEdit.Text) + "',WebSitetypeSportImage='" + sqldb.CheckString(titleImage) + "',WebSiteTypeLogoImage='" + sqldb.CheckString(LogoImage) + "' where WebSiteTypeId=" + ViewState["id"].ToString();
        if (sqldb.ExecuteNonQueryCheck(strsql) > 0)
        {
            txtTitleEdit.Text = "";
            txtContentEdit.Text = "";
            P1.Visible = false;
            GridViewBind();
            sql.Operation.Show_Msg("恭喜您，网站类型修改成功！");
        }
        else
        {
            sql.Operation.Show_Msg("网站类型修改失败，请重试！");
        }
    } 
}
