﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using sql;

public partial class Admin_serviceDocManger : System.Web.UI.Page
{
    
    SqlDB sqldb = new SqlDB();
    Operation operate = new Operation();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["Admin"] == null)
            {
                Response.Redirect("index.aspx");
            }
            P2.Visible = false;
            P1.Visible = false;
            GridViewBind();
            DropDownListBind();
            DropDownListBindEdit();
        }
    }
    /// <summary>
    /// 绑定GridView显示列表
    /// </summary>
    private void GridViewBind()
    {
        string strSql = "select a.serviceDocId,a.serviceDocName,a.serviceDocFrom,a.serviceDocDate,b.serviceId,b.serviceName,c.servicetypeId,c.servicetypeName from serviceDoc as a,service as b,serviceType as c where a.serviceId=b.serviceId and a.serviceTypeId=c.servicetypeId";
        operate.GridViewBind(GridView1, strSql);
    }
    //绑定添加时的服务类型
    private void DropDownListBind()
    {
        string strSql = "select servicetypeId,serviceTypeName from serviceType";
        operate.DropDownListBind(ddlAddServiceType, strSql, "serviceTypeName", "servicetypeId");
        DropDownListBindServer(ddlAddService,ddlAddServiceType.SelectedItem.Value.ToString());
    }
    //绑定修改时的服务类型
    private void DropDownListBindEdit()
    {
        string strSql = "select servicetypeId,serviceTypeName from serviceType";
        operate.DropDownListBind(ddlEditServiceType, strSql, "serviceTypeName", "servicetypeId");
        DropDownListBindServer(ddlEditService,ddlEditServiceType.SelectedItem.Value.ToString());
    }
    /// <summary>
    /// 根据服务类型列表中被选中的值填充服务下拉列表
    /// </summary>
    /// <param name="serverTypeId">当前服务类型编号</param>
    private void DropDownListBindServer(DropDownList ddl,string serverTypeId)
    {
        string strSql = "select serviceId,serviceName from service where servicetypeId=" +serverTypeId;
        operate.DropDownListBind(ddl, strSql, "serviceName", "serviceId");
    }
    /// <summary>
    /// 准备执行插入命令
    /// </summary>
    protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Insert")
        {
            P2.Visible = true;
            P1.Visible = false;
        }
    }
    /// <summary>
    /// 执行翻页命令
    /// </summary>
    protected void GridView1_OnPageIndexChanged(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        GridViewBind();
    }
    /// <summary>
    /// 执行删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        string id = GridView1.DataKeys[e.RowIndex].Value.ToString();
        string strSql = "delete from serviceDoc where ServiceDocId=" + id;        
        if (sqldb.ExecuteNonQueryCheck(strSql) > 0)
        {                                    
            GridViewBind();
            sql.Operation.Show_Msg("恭喜您，服务文档删除成功！");
        }
        else
        {
            sql.Operation.Show_Msg("服务文档删除失败，请重新删除！");               
        }
       
    }
    /// <summary>
    /// 准备执行编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
    {
        P1.Visible = true;
        P2.Visible = false;
        string id = GridView1.DataKeys[e.NewEditIndex].Value.ToString();
        ViewState["id"] = id;
        string strSql = "select * from serviceDoc where serviceDocId=" + id;
        DataSet ds = sqldb.GetDS(strSql);
        txtDocNameEdit.Text = ds.Tables[0].Rows[0]["serviceDocName"].ToString();
        txtDocFromEdit.Text = ds.Tables[0].Rows[0]["serviceDocFrom"].ToString();
        txtDocDetailsEdit.Text = ds.Tables[0].Rows[0]["serviceDocDetails"].ToString();
        ds.Clear();

    }
    /// <summary>
    /// 取消添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancelAdd_Click(object sender, EventArgs e)
    {
        P2.Visible = false;
    }
    /// <summary>
    /// 取消编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCanelEdit_Click(object sender, EventArgs e)
    {
        P1.Visible = false;
    }  
    /// <summary>
    /// 执行添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {

        string serviceTypeId = ddlAddServiceType.SelectedItem.Value.ToString();
        string serviceId = ddlAddService.SelectedItem.Value.ToString();
        string allValues = "'" + sqldb.CheckString(txtDocName.Text) + "','" + sqldb.CheckString(txtDocFrom.Text) + "','" + DateTime.Now + "','" + sqldb.CheckString(txtDocDetails.Text) + "',"+serviceId+","+serviceTypeId;
        string strsql = "insert into serviceDoc(serviceDocName,serviceDocFrom,serviceDocDate,serviceDocDetails,serviceId,serviceTypeId) values(" + allValues + ")";
        if (sqldb.ExecuteNonQueryCheck(strsql) > 0)
        {
            txtDocName.Text = "";            
            txtDocFrom.Text = "原创";
            txtDocDetails.Text = "";
            P2.Visible = false;
            GridViewBind();
            DropDownListBind();
            sql.Operation.Show_Msg("恭喜您，服务文档发表成功！");
        }
        else
        {
            sql.Operation.Show_Msg("服务文档发表失败，请重试！");
        }
    }
    /// <summary>
    /// 执行编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnEdit_Click(object sender, EventArgs e)
    {
        string serviceTypeId = ddlEditServiceType.SelectedItem.Value.ToString();
        string serviceId = ddlEditService.SelectedItem.Value.ToString();
        string strsql = "update serviceDoc set serviceDocName='" + sqldb.CheckString(txtDocNameEdit.Text) + "',serviceDocFrom='" + sqldb.CheckString(txtDocFromEdit.Text) + "',serviceDocDate='" + DateTime.Now + "',serviceDocDetails='" + sqldb.CheckString(txtDocDetailsEdit.Text) + "',serviceId='" + serviceId + "',serviceTypeId='" + serviceTypeId + "' where serviceDocId=" + ViewState["id"].ToString();
        if (sqldb.ExecuteNonQueryCheck(strsql) > 0)
        {
            txtDocNameEdit.Text = "";
            txtDocFromEdit.Text = "原创";
            txtDocDetailsEdit.Text = "";
            P1.Visible = false;
            GridViewBind();
            DropDownListBindEdit();
            sql.Operation.Show_Msg("恭喜您，服务文档修改成功！");
        }
        else
        {
            sql.Operation.Show_Msg("服务文档修改失败，请重试！");
        }        
    }
    protected void ddlAddServiceType_SelectedIndexChanged(object sender, EventArgs e)
    {
        DropDownListBindServer(ddlAddService,ddlAddServiceType.SelectedItem.Value.ToString());
    }
    protected void ddlEditServiceType_SelectedIndexChanged(object sender, EventArgs e)
    {
        DropDownListBindServer(ddlEditService, ddlEditServiceType.SelectedItem.Value.ToString());
    }
}
