﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;
using sql;

public partial class Admin_serviceManger : System.Web.UI.Page
{
    SqlDB sqldb = new SqlDB();
    Operation operate = new Operation();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["Admin"] == null)
            {
                Response.Redirect("index.aspx");
            }
            P2.Visible = false;
            P1.Visible = false;
            GridViewBind();
            DropDownListBind();
        }
    }
    /// <summary>
    /// 绑定GridView显示列表
    /// </summary>
    private void GridViewBind()
    {
        string strSql = "select a.serviceId,a.serviceName,b.servicetypeId,b.serviceTypeName from service as a,servicetype as b where a.serviceTypeId=b.servicetypeId";
        operate.GridViewBind(GridView1, strSql);
    }
    private void DropDownListBind()
    {
        string strSql = "select serviceTypeId,serviceTypeName from serviceType";
        operate.DropDownListBind(DropDownList1, strSql, "serviceTypeName", "serviceTypeId");
        operate.DropDownListBind(DropDownList2, strSql, "serviceTypeName", "serviceTypeId");
    }
    /// <summary>
    /// 准备执行插入命令
    /// </summary>
    protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Insert")
        {
            P2.Visible = true;
            P1.Visible = false;
        }
    }
    /// <summary>
    /// 执行翻页命令
    /// </summary>
    protected void GridView1_OnPageIndexChanged(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        GridViewBind();
    }
    /// <summary>
    /// 执行删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        string id = GridView1.DataKeys[e.RowIndex].Value.ToString();        
        string strSql = "delete from service where serviceId=" + id;
        try
        {
            if (sqldb.ExecuteNonQueryCheck(strSql) > 0)
            {
                sqldb.ExecuteNonQuery(strSql);
                //删除服务表中对应该类型的服务文档
                strSql = "delete from serviceDoc where serviceId=" + id;
                sqldb.ExecuteNonQuery(strSql);
                GridViewBind();
                sql.Operation.Show_Msg("恭喜您，服务删除成功！");
            }
            else
            {
                sql.Operation.Show_Msg("服务删除失败，请重新删除！");
            }
        }
        catch (Exception ex)
        {
        }
        finally
        {
        }
    }
    /// <summary>
    /// 准备执行编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
    {
        P1.Visible = true;
        P2.Visible = false;
        string id = GridView1.DataKeys[e.NewEditIndex].Value.ToString();
        ViewState["id"] = id;
        string strSql = "select * from Service where serviceId=" + id;
        DataSet ds = sqldb.GetDS(strSql);
        txtTitleEdit.Text = ds.Tables[0].Rows[0]["ServiceName"].ToString();        
        ds.Clear();

    }
    /// <summary>
    /// 取消添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancelAdd_Click(object sender, EventArgs e)
    {
        P2.Visible = false;
    }
    /// <summary>
    /// 取消编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCanelEdit_Click(object sender, EventArgs e)
    {
        P1.Visible = false;
    }
    /// <summary>
    /// 执行添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        string ServiceTypeId = DropDownList1.SelectedItem.Value.ToString();
        string allValues = "'" + sqldb.CheckString(txtTitle.Text) + "',"+ServiceTypeId;
        string strsql = "insert into service(serviceName,serviceTypeId) values(" + allValues + ")";
        if (sqldb.ExecuteNonQueryCheck(strsql) > 0)
        {
            txtTitle.Text = "";           
            P2.Visible = false;
            GridViewBind();
            DropDownListBind();
            sql.Operation.Show_Msg("恭喜您，服务添加成功！");
        }
        else
        {
            sql.Operation.Show_Msg("服务添加失败，请重试！");
        }
    }
    /// <summary>
    /// 执行编辑
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnEdit_Click(object sender, EventArgs e)
    {
        string strsql = "update service set serviceName='" + sqldb.CheckString(txtTitleEdit.Text.Trim()) + "',servicetypeId="+ DropDownList2.SelectedItem.Value.ToString()+" where serviceId=" + ViewState["id"].ToString();
        if (sqldb.ExecuteNonQueryCheck(strsql) > 0)
        {
            txtTitleEdit.Text = "";           
            P1.Visible = false;
            GridViewBind();
            DropDownListBind();
            sql.Operation.Show_Msg("恭喜您，服务修改成功！");
        }
        else
        {
            sql.Operation.Show_Msg("服务修改失败，请重试！");
        }
    }   
}
