﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/// <summary>
/// Operation 的摘要说明
/// </summary>
namespace sql
{
    public class Operation
    {
        SqlDB sqldb;
        public Operation()
        {
            //初始化SqlDB对象
            sqldb = new SqlDB();
        }
        /// <summary>
        /// 绑定DataList控件
        /// </summary>
        /// <param name="dl">DataList控件名</param>
        /// <param name="QueryString">SQL查询语句</param>
        public void DataListBind(DataList dl, string QueryString)
        {
            DataSet ds = sqldb.GetDS(QueryString);
            dl.DataSource = ds.Tables[0].DefaultView;
            dl.DataBind();
            ds.Clear();
        }
        /// <summary>
        /// 绑定GridView控件
        /// </summary>
        /// <param name="gv">GridView控件名</param>
        /// <param name="QueryString">SQL查询语句</param>
        public void GridViewBind(GridView gv, string QueryString)
        {
            DataSet ds = sqldb.GetDS(QueryString);
            gv.DataSource = ds.Tables[0].DefaultView;
            gv.DataBind();
            ds.Clear();
        }
        /// <summary>
        /// 绑定DropDownList控件
        /// </summary>
        /// <param name="ddl">DropDownList控件名</param>
        /// <param name="QueryString">SQL查询语句</param>
        /// <param name="DataTextField">文本的字段</param>
        /// <param name="DataValueField">值的字段</param>
        public void DropDownListBind(DropDownList ddl, string QueryString, string DataTextField, string DataValueField)
        {
            DataSet ds = sqldb.GetDS(QueryString);
            ddl.DataSource = ds.Tables[0].DefaultView;
            ddl.DataTextField = DataTextField;
            ddl.DataValueField = DataValueField;
            ddl.DataBind();            
            ds.Clear();
        }
        /// <summary>
        /// 提示错误信息！操作回滚！
        /// </summary>
        /// <param name="msg"></param>
        /// <param name="code"></param>
        public static void Show_Msg(string msg)
        {

            HttpContext.Current.Response.Write("<script>alert(\"" + msg + "\");</script>");

        }
        /// <summary>
        /// 提示成功信息！转向！
        /// </summary>
        /// <param name="msg"></param>
        /// <param name="url"></param>
        public static void Show_Msg(string msg, string url)
        {
            HttpContext.Current.Response.Write("<script>alert(\"" + msg + "\");location.href='" + url + "';</script>");
        }

        /// <summary>
        /// 清除session的值
        /// </summary>
        public void DropSession()
        {

            HttpContext.Current.Session["Admin"] = null;
            //HttpContext.Current.Session["Diction"] = null;
        }
        public static string UpLoad(FileUpload ZSfu, string ZSPath, string Type)
        {
            string now = (DateTime.Now.Year).ToString() + (DateTime.Now.Month).ToString() + (DateTime.Now.Day).ToString() + (DateTime.Now.Hour).ToString() + (DateTime.Now.Second).ToString() + (DateTime.Now.Millisecond).ToString();
            string fullName = ZSfu.PostedFile.FileName;
            string type = fullName.Substring(fullName.LastIndexOf(".") + 1);
            string fileName = fullName.Substring(fullName.LastIndexOf("\\") + 1);
            string upName = now + fileName;
            if (type != "image")
            {
                try
                {
                    ZSfu.SaveAs(System.Web.HttpContext.Current.Server.MapPath(ZSPath) + "\\" + upName);
                    return upName;
                }
                catch
                {
                    return "fail";
                }
            }
            else
            {
                if (type == "gif" || type == "bmp" || type == "jpg")
                {
                    try
                    {
                        ZSfu.SaveAs(System.Web.HttpContext.Current.Server.MapPath(ZSPath) + "\\" + upName);
                        return upName;
                    }
                    catch
                    {
                        return "fail";
                    }
                }
                else
                {
                    return "fail";
                }
            }
        }
    }
}
