﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
//该源码首发自www.51aspx.com(５1ａｓｐｘ．ｃｏｍ)

/// <summary>
/// 数据库连接及相关操作
/// </summary>
namespace sql
{
    public class SqlDB
    {
        ////声明各变量
        private string StrConn;
        private SqlConnection con;
        private SqlCommand cmd;
        private SqlDataAdapter sda;
        private DataSet ds;
        /// <summary>
        /// 初始化各变量
        /// </summary>
        public SqlDB()
        {
            StrConn = GetConnectionString();
            con = new SqlConnection(StrConn);            
            cmd = new SqlCommand();
            sda = new SqlDataAdapter();
            ds = new DataSet();
        }
        /// <summary>
        /// 得到链接
        /// </summary>
        /// <returns>StrConn</returns>
        private string GetConnectionString()
        {
            return ConfigurationManager.ConnectionStrings["SqlwebzcnConnectionString"].ConnectionString;
        }
        private void CheckCon()
        {
            if (con.State == ConnectionState.Closed)
            {
                con.Open();
            }
        }
        /// <summary>
        /// 得到DataSet
        /// </summary>
        /// <param name="StrSql"></param>
        /// <returns>ds</returns>
        public DataSet GetDS(string StrSql)
        {
            con.Open();
            cmd.CommandText = StrSql;
            cmd.Connection = con;
            sda.SelectCommand = cmd;
            sda.Fill(ds);
            con.Close();
            return ds;
        }
        /// <summary>
        /// 执行Sql命令
        /// </summary>
        /// <param name="strQuery">sql语句</param>
        public void ExecuteNonQuery(string strQuery)
        {
            //con.Open();
            CheckCon();
            cmd.CommandText = strQuery;
            cmd.Connection = con;
            cmd.ExecuteNonQuery();
            con.Close();
        }
        /// <summary>
        /// 返回首行首列
        /// </summary>
        /// <param name="strQuery">sql语句</param>
        /// <returns>sum\首行首行的值</returns>
        public string ExecuteScalar(string strQuery)
        {
            con.Open();
            cmd.Connection = con;
            cmd.CommandText = strQuery;
            string id = Convert.ToString(cmd.ExecuteScalar());
            con.Close();
            return id;
        }
        /// <summary>
        /// 读取一行
        /// </summary>
        /// <param name="strQuery">Sql语句</param>
        /// <returns>sdr</returns>
        public SqlDataReader ExecuteReader(string strQuery)
        {
            con.Open();
            cmd.CommandText = strQuery;
            cmd.Connection = con;
            SqlDataReader sdr=cmd.ExecuteReader();
            sdr.Read();           
            return sdr;
        }
        /// <summary>
        /// 执行Sql语句，统计影响记录条数
        /// </summary>
        /// <param name="strQuery"></param>
        /// <returns></returns>
        public int ExecuteNonQueryCheck(string strQuery)
        {
            con.Open();
            cmd.CommandText = strQuery;
            cmd.Connection = con;
            int count=cmd.ExecuteNonQuery();
            con.Close();
            return count;
        }
        /// <summary>
        /// 处理字符串
        /// </summary>
        /// <param name="textboxvalue">处理前的字符串</param>
        /// <returns>处理后的字符串</returns>
        public string CheckString(string textboxvalue)
        {
           return System.Web.HttpContext.Current.Server.HtmlEncode(textboxvalue.Replace("'", "''").Trim());
        }         
    }
}
