﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using sql;

public partial class MyJob : System.Web.UI.Page
{
    Operation operate = new Operation();
    SqlDB sqldb = new SqlDB();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            lblPageOnly.Text = "1";
            DataListBind();
        }
    }
    private void DataListBind()
    {
        int curPage = Convert.ToInt32(lblPageOnly.Text);
        string strSql = "select * from JobInfo as a,JobNeed as b where a.JobId=b.JobId order by JobTime desc";
        DataSet ds = sqldb.GetDS(strSql);
        PagedDataSource ps = new PagedDataSource();
        ps.DataSource = ds.Tables[0].DefaultView;
        ps.AllowPaging = true;
        ps.PageSize = 5;
        ps.CurrentPageIndex = curPage - 1;
        lblPageCount.Text = ps.PageCount.ToString();
        lblCount.Text = ps.DataSourceCount.ToString();

        lbtnFirst.Enabled = true;
        lbtnUp.Enabled = true;
        lbtnNext.Enabled = true;
        lbtnLast.Enabled = true;

        if (curPage == 1)
        {
            lbtnFirst.Enabled = false;
            lbtnUp.Enabled = false;
        }
        if (curPage == ps.PageCount)
        {
            lbtnNext.Enabled = false;
            lbtnLast.Enabled = false;
        }

        DataList1.DataSource = ps;
        DataList1.DataBind();
        //处理选择性查看页
        ddlPage.Items.Clear();
        for (int i = 1; i <= ps.PageCount; i++)
        {
            ddlPage.Items.Add(i.ToString());//在下拉列表中添加对应项
        }
    }
    protected void lbtnFirst_Click(object sender, EventArgs e)
    {
        lblPageOnly.Text = "1";
        DataListBind();
    }
    protected void lbtnUp_Click(object sender, EventArgs e)
    {
        lblPageOnly.Text = Convert.ToString(Convert.ToInt32(lblPageOnly.Text) - 1);
        DataListBind();
    }
    protected void lbtnNext_Click(object sender, EventArgs e)
    {
        lblPageOnly.Text = Convert.ToString(Convert.ToInt32(lblPageOnly.Text)+ 1);
        DataListBind();
    }
    protected void lbtnLower_Click(object sender, EventArgs e)
    {
        lblPageOnly.Text = lblPageCount.Text;
        DataListBind();
    }
    protected void ddlPage_SelectedIndexChanged(object sender, EventArgs e)
    {
        lblPageOnly.Text =ddlPage.SelectedItem.Text;
        DataListBind();
    }
}
