using System;
using System.Collections.Generic;
using System.Text;
using DevinFrame.WebGame.Entity;
using DevinFrame.WebGame.Operation;
using System.Web;
using DevinFrame.Common;

namespace DevinFrame.WebGame.Expand
{
    public  class ValidDate
    {
        public static D_AdminEntity DevinAdmin = new D_AdminEntity();
        public static bool CheckAdmin()
        {
            if (HttpContext.Current.Session["DevinAdmin"] == null)
            {
                HttpCookie newcookie = HttpContext.Current.Request.Cookies["DevinAdmin"];
                if (newcookie == null)
                    return false;
                D_AdminEntity o = new D_Admin().GetD_AdminEntity(HttpUtility.UrlDecode(newcookie["UserName"]));
                if (o == null)
                    return false;
                if (o.TempPwd.Trim() != newcookie["TempPwd"])
                    return false;
                //дʱ
                String temppwd = DevinFrame.Encrypt.CryptCore.Md5(Utility.RndNum(8));
                o.TempPwd = temppwd;
                new D_Admin().UpdateTempPwd(o);
                //дCOOKIE
                newcookie.Values["UserName"] = HttpUtility.UrlEncode(o.UserName);
                newcookie.Values["TempPwd"] = HttpUtility.UrlEncode(temppwd);
                newcookie.Expires = DateTime.Now.AddDays(1);
                newcookie.Path = "/";
                HttpContext.Current.Response.AppendCookie(newcookie);
                //дSESSION ֵ
                DevinAdmin = o;
                HttpContext.Current.Session["DevinAdmin"] = o;
                return true;
            }
            else
            {
                DevinAdmin = (D_AdminEntity)HttpContext.Current.Session["DevinAdmin"];
                return true;
            }
        }
    }
}
