using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections;
using DevinFrame.WebGame.Entity;
using DevinFrame.Date;
using DevinFrame.WebGame.Methods;

namespace DevinFrame.WebGame.SqlServer
{
    public class D_Admin : MD_Admin
    {
        protected int _recordcount;
        protected int _pagecount;
        public D_Admin() { }
        public int RecordCount()
        {
            return _recordcount;
        }
        public int PageCount()
        {
            return _pagecount;
        }
        public Int32 Insert(D_AdminEntity d_AdminEntity)
        {
            SqlParameter[] Para = new SqlParameter[4];
            Para[0] = new SqlParameter("@UserName", d_AdminEntity.UserName);
            Para[1] = new SqlParameter("@UserPwd", d_AdminEntity.UserPwd);
            Para[2] = new SqlParameter("@UserPower", d_AdminEntity.UserPower);
            Para[3] = new SqlParameter("@LastIp", d_AdminEntity.LastIp);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Admin_Create", Para);
        }

        public int Update(D_AdminEntity d_AdminEntity)
        {
            SqlParameter[] Para = new SqlParameter[5];
            Para[0] = new SqlParameter("@Id", d_AdminEntity.Id);
            Para[1] = new SqlParameter("@UserName", d_AdminEntity.UserName);
            Para[2] = new SqlParameter("@UserPwd", d_AdminEntity.UserPwd);
            Para[3] = new SqlParameter("@UserPower", d_AdminEntity.UserPower);
            Para[4] = new SqlParameter("@LastIp", d_AdminEntity.LastIp);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Admin_Update", Para);
        }

        public int Del(Int32 Id)
        {
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Admin_Del", Para);
        }
        public int UpdatePower(Int32 Id)
        {
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Admin_Power", Para);
        }
        public int UpdateTempPwd(D_AdminEntity D_AdminEntity)
        {
            SqlParameter[] Para = new SqlParameter[2];
            Para[0] = new SqlParameter("@Id", D_AdminEntity.Id);
            Para[1] = new SqlParameter("@TempPwd", D_AdminEntity.TempPwd);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Admin_Temp", Para);
        }
        public int Del(string Id)
        {
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Admin_Dels", Para);
        }
        public D_AdminEntity GetD_AdminEntity(String UserName)
        {
            D_AdminEntity d_adminEntity = null;
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@UserName", UserName);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Admin_GetInfoByName", Para);
            if (Set.Tables[0].Rows.Count > 0)
            {
                DataRow drv = Set.Tables[0].Rows[0];
                d_adminEntity = new D_AdminEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["UserName"].ToString(),
                    drv["UserPwd"].ToString(),
                    drv["TempPwd"].ToString(),
                    Boolean.Parse(drv["UserPower"].ToString()),
                    DateTime.Parse(drv["CreateTime"].ToString()),
                    DateTime.Parse(drv["LoginTime"].ToString()),
                    Int32.Parse(drv["LoginNum"].ToString()),
                    drv["LastIp"].ToString());
            }
            return d_adminEntity;
        }
        public D_AdminEntity GetD_AdminEntity(Int32 Id)
        {
            D_AdminEntity d_adminEntity = null;
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Admin_GetInfoById", Para);
            if (Set.Tables[0].Rows.Count > 0)
            {
                DataRow drv = Set.Tables[0].Rows[0];
                d_adminEntity = new D_AdminEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["UserName"].ToString(),
                    drv["UserPwd"].ToString(),
                    drv["TempPwd"].ToString(),
                    Boolean.Parse(drv["UserPower"].ToString()),
                    DateTime.Parse(drv["CreateTime"].ToString()),
                    DateTime.Parse(drv["LoginTime"].ToString()),
                    Int32.Parse(drv["LoginNum"].ToString()),
                    drv["LastIp"].ToString());
            }
            return d_adminEntity;
        }

        public IList GetD_AdminList(DevinFrame.Pagination.Condition _condition)
        {
            IList list = new ArrayList();

            if (_condition.TableName == "")
                _condition.TableName = "D_Admin";
            SqlParameter[] Para = new SqlParameter[5];
            Para[0] = new SqlParameter("@TableName", _condition.TableName);
            Para[1] = new SqlParameter("@TopNum", _condition.TopNum);
            Para[2] = new SqlParameter("@FieldList", _condition.FieldList);
            Para[3] = new SqlParameter("@Conditions", _condition.Conditions);
            Para[4] = new SqlParameter("@OrderBy", _condition.OrderBy);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Condition", Para);
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_AdminEntity d_adminEntity = new D_AdminEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["UserName"].ToString(),
                    drv["UserPwd"].ToString(),
                    drv["TempPwd"].ToString(),
                    Boolean.Parse(drv["UserPower"].ToString()),
                    DateTime.Parse(drv["CreateTime"].ToString()),
                    DateTime.Parse(drv["LoginTime"].ToString()),
                    Int32.Parse(drv["LoginNum"].ToString()),
                    drv["LastIp"].ToString());
                list.Add(d_adminEntity);
            }
            return list;
        }

        public IList GetD_AdminList(DevinFrame.Pagination.Pagination _pagination)
        {
            IList list = new ArrayList();

            if (_pagination.TableName == "")
                _pagination.TableName = "D_Admin";
            SqlParameter[] Para = new SqlParameter[10];
            Para[0] = new SqlParameter("@TableName", _pagination.TableName);
            Para[1] = new SqlParameter("@PKey", _pagination.PKey);
            Para[2] = new SqlParameter("@FieldList", _pagination.FieldList);
            Para[3] = new SqlParameter("@Condition", _pagination.Condition);
            Para[4] = new SqlParameter("@OrderBy", _pagination.OrderBy);
            Para[5] = new SqlParameter("@Sql", _pagination.Sql);
            Para[6] = new SqlParameter("@SqlGetRC", _pagination.SqlGetRC);
            Para[7] = new SqlParameter("@CurrPage", _pagination.CurrPage);
            Para[8] = new SqlParameter("@PageSize", _pagination.PageSize);
            Para[9] = new SqlParameter("@RecordCount", _pagination.RecordCount);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Pagination", Para);
            _recordcount = int.Parse(Set.Tables[1].Rows[0]["RecordCount"].ToString());
            _pagecount = int.Parse(Set.Tables[1].Rows[0]["PageCount"].ToString());
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_AdminEntity d_adminEntity = new D_AdminEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["UserName"].ToString(),
                    drv["UserPwd"].ToString(),
                    drv["TempPwd"].ToString(),
                    Boolean.Parse(drv["UserPower"].ToString()),
                    DateTime.Parse(drv["CreateTime"].ToString()),
                    DateTime.Parse(drv["LoginTime"].ToString()),
                    Int32.Parse(drv["LoginNum"].ToString()),
                    drv["LastIp"].ToString());
                list.Add(d_adminEntity);
            }
            return list;
        }
    }
}