using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections;
using DevinFrame.WebGame.Entity;
using DevinFrame.Date;
using DevinFrame.WebGame.Methods;

namespace DevinFrame.WebGame.SqlServer
{
    public class D_Category : MD_Category
    {
        protected int _recordcount;
        protected int _pagecount;
        public D_Category() { }
        public int RecordCount()
        {
            return _recordcount;
        }
        public int PageCount()
        {
            return _pagecount;
        }
        public Int32 Insert(D_CategoryEntity D_CategoryEntity)
        {
            SqlParameter[] Para = new SqlParameter[5];
            Para[0] = new SqlParameter("@ClassName", D_CategoryEntity.ClassName);
            Para[1] = new SqlParameter("@ICO", D_CategoryEntity.ICO);
            Para[2] = new SqlParameter("@State", D_CategoryEntity.State);
            Para[3] = new SqlParameter("@TableName", D_CategoryEntity.TableName);
            Para[4] = new SqlParameter("@FileName", D_CategoryEntity.FileName);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Category_Create", Para);
        }

        public int Update(D_CategoryEntity D_CategoryEntity)
        {
            SqlParameter[] Para = new SqlParameter[6];
            Para[0] = new SqlParameter("@Id", D_CategoryEntity.Id);
            Para[1] = new SqlParameter("@ClassName", D_CategoryEntity.ClassName);
            Para[2] = new SqlParameter("@ICO", D_CategoryEntity.ICO);
            Para[3] = new SqlParameter("@State", D_CategoryEntity.State);
            Para[4] = new SqlParameter("@TableName", D_CategoryEntity.TableName);
            Para[5] = new SqlParameter("@FileName", D_CategoryEntity.FileName);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Category_Update", Para);
        }

        public int Del(Int32 Id, String TableName)
        {
            SqlParameter[] Para = new SqlParameter[2];
            Para[0] = new SqlParameter("@Id", Id);
            Para[1] = new SqlParameter("@TableName", TableName);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Category_Del", Para);
        }

        public int Del(String Id, String TableName)
        {
            SqlParameter[] Para = new SqlParameter[2];
            Para[0] = new SqlParameter("@Id", Id);
            Para[1] = new SqlParameter("@TableName", TableName);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Category_Dels", Para);
        }

        public D_CategoryEntity GetD_CategoryEntity(Int32 Id, String TableName)
        {
            D_CategoryEntity D_CategoryEntity = null;
            SqlParameter[] Para = new SqlParameter[2];
            Para[0] = new SqlParameter("@Id", Id);
            Para[1] = new SqlParameter("@TableName", TableName);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Category_GetInfoById", Para);
            if (Set.Tables[0].Rows.Count > 0)
            {
                DataRow drv = Set.Tables[0].Rows[0];
                D_CategoryEntity = new D_CategoryEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["ClassName"].ToString(),
                    Boolean.Parse(drv["State"].ToString()),
                    DateTime.Parse(drv["CreateTime"].ToString()),
                    drv["ICO"].ToString(),
                    drv["FileName"].ToString());
            }
            return D_CategoryEntity;
        }

        public IList GetD_CategoryList(DevinFrame.Pagination.Condition _condition)
        {
            IList list = new ArrayList();

            SqlParameter[] Para = new SqlParameter[5];
            Para[0] = new SqlParameter("@TableName", _condition.TableName);
            Para[1] = new SqlParameter("@TopNum", _condition.TopNum);
            Para[2] = new SqlParameter("@FieldList", _condition.FieldList);
            Para[3] = new SqlParameter("@Conditions", _condition.Conditions);
            Para[4] = new SqlParameter("@OrderBy", _condition.OrderBy);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Condition", Para);
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_CategoryEntity D_CategoryEntity = new D_CategoryEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["ClassName"].ToString(),
                    Boolean.Parse(drv["State"].ToString()),
                    DateTime.Parse(drv["CreateTime"].ToString()),
                    drv["ICO"].ToString(),
                    drv["FileName"].ToString());
                list.Add(D_CategoryEntity);
            }
            return list;
        }

        public IList GetD_CategoryList(DevinFrame.Pagination.Pagination _pagination)
        {
            IList list = new ArrayList();

            if (_pagination.TableName == "")
                _pagination.TableName = "D_Category";
            SqlParameter[] Para = new SqlParameter[10];
            Para[0] = new SqlParameter("@TableName", _pagination.TableName);
            Para[1] = new SqlParameter("@PKey", _pagination.PKey);
            Para[2] = new SqlParameter("@FieldList", _pagination.FieldList);
            Para[3] = new SqlParameter("@Condition", _pagination.Condition);
            Para[4] = new SqlParameter("@OrderBy", _pagination.OrderBy);
            Para[5] = new SqlParameter("@Sql", _pagination.Sql);
            Para[6] = new SqlParameter("@SqlGetRC", _pagination.SqlGetRC);
            Para[7] = new SqlParameter("@CurrPage", _pagination.CurrPage);
            Para[8] = new SqlParameter("@PageSize", _pagination.PageSize);
            Para[9] = new SqlParameter("@RecordCount", _pagination.RecordCount);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Pagination", Para);
            _recordcount = int.Parse(Set.Tables[1].Rows[0]["RecordCount"].ToString());
            _pagecount = int.Parse(Set.Tables[1].Rows[0]["PageCount"].ToString());
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_CategoryEntity D_CategoryEntity = new D_CategoryEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["ClassName"].ToString(),
                    Boolean.Parse(drv["State"].ToString()),
                    DateTime.Parse(drv["CreateTime"].ToString()),
                    drv["ICO"].ToString(),
                    drv["FileName"].ToString());
                list.Add(D_CategoryEntity);
            }
            return list;
        }
    }
}