using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections;
using DevinFrame.WebGame.Entity;
using DevinFrame.Date;
using DevinFrame.WebGame.Methods;

namespace DevinFrame.WebGame.SqlServer
{
    public class D_Configure : MD_Configure
    {
        protected int _recordcount;
        protected int _pagecount;
        public D_Configure() { }
        public int RecordCount()
        {
            return _recordcount;
        }
        public int PageCount()
        {
            return _pagecount;
        }
        public int Update(D_ConfigureEntity d_ConfigureEntity)
        {
            SqlParameter[] Para = new SqlParameter[23];
            Para[0] = new SqlParameter("@Id", d_ConfigureEntity.Id);
            Para[1] = new SqlParameter("@WebSiteName", d_ConfigureEntity.WebSiteName);
            Para[2] = new SqlParameter("@WebUrl", d_ConfigureEntity.WebUrl);
            Para[3] = new SqlParameter("@Contact", d_ConfigureEntity.Contact);
            Para[4] = new SqlParameter("@TelPhone", d_ConfigureEntity.TelPhone);
            Para[5] = new SqlParameter("@Fax", d_ConfigureEntity.Fax);
            Para[6] = new SqlParameter("@WebIcp", d_ConfigureEntity.WebIcp);
            Para[7] = new SqlParameter("@Email", d_ConfigureEntity.Email);
            Para[8] = new SqlParameter("@WebTitle", d_ConfigureEntity.WebTitle);
            Para[9] = new SqlParameter("@KeyWords", d_ConfigureEntity.KeyWords);
            Para[10] = new SqlParameter("@Generator", d_ConfigureEntity.Generator);
            Para[11] = new SqlParameter("@DEscription", d_ConfigureEntity.DEscription);
            Para[12] = new SqlParameter("@Author", d_ConfigureEntity.Author);
            Para[13] = new SqlParameter("@Compay", d_ConfigureEntity.Compay);
            Para[14] = new SqlParameter("@OfficeAdd", d_ConfigureEntity.OfficeAdd);
            Para[15] = new SqlParameter("@PostCode", d_ConfigureEntity.PostCode);
            Para[16] = new SqlParameter("@Mobile", d_ConfigureEntity.Mobile);
            Para[17] = new SqlParameter("@CreateHtml", d_ConfigureEntity.CreateHtml);
            Para[18] = new SqlParameter("@StartLanguage", d_ConfigureEntity.StartLanguage);
            Para[19] = new SqlParameter("@DefaultSkin", d_ConfigureEntity.DefaultSkin);
            Para[20] = new SqlParameter("@Visitors", d_ConfigureEntity.Visitors);
            Para[21] = new SqlParameter("@Associators", d_ConfigureEntity.Associators);
            Para[22] = new SqlParameter("@HotKeyWord", d_ConfigureEntity.HotKeyWord);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Configure_Update", Para);
        }


        public D_ConfigureEntity GetD_ConfigureEntity(Int32 Id)
        {
            D_ConfigureEntity d_configureEntity = null;
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Configure_GetInfoById", Para);
            if (Set.Tables[0].Rows.Count > 0)
            {
                DataRow drv = Set.Tables[0].Rows[0];
                d_configureEntity = new D_ConfigureEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["WebSiteName"].ToString(),
                    drv["WebUrl"].ToString(),
                    drv["Contact"].ToString(),
                    drv["TelPhone"].ToString(),
                    drv["Fax"].ToString(),
                    drv["WebIcp"].ToString(),
                    drv["Email"].ToString(),
                    drv["WebTitle"].ToString(),
                    drv["KeyWords"].ToString(),
                    drv["Generator"].ToString(),
                    drv["DEscription"].ToString(),
                    drv["Author"].ToString(),
                    drv["Compay"].ToString(),
                    drv["OfficeAdd"].ToString(),
                    drv["PostCode"].ToString(),
                    drv["Mobile"].ToString(),
                    Boolean.Parse(drv["CreateHtml"].ToString()),
                    drv["StartLanguage"].ToString(),
                    Int32.Parse(drv["DefaultSkin"].ToString()),
                    Int32.Parse(drv["Visitors"].ToString()),
                    Int32.Parse(drv["Associators"].ToString()),
                    drv["HotKeyWord"].ToString());
            }
            return d_configureEntity;

        }
    }
}