using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections;
using DevinFrame.WebGame.Entity;
using DevinFrame.Date;
using DevinFrame.WebGame.Methods;

namespace DevinFrame.WebGame.SqlServer
{
    public class D_Formula : MD_Formula
    {
        protected int _recordcount;
        protected int _pagecount;
        public D_Formula() { }
        public int RecordCount()
        {
            return _recordcount;
        }
        public int PageCount()
        {
            return _pagecount;
        }
        public Int32 Insert(D_FormulaEntity d_FormulaEntity)
        {
            SqlParameter[] Para = new SqlParameter[24];
            Para[0] = new SqlParameter("@Formulary", d_FormulaEntity.Formulary);
            Para[1] = new SqlParameter("@FormularyPic", d_FormulaEntity.FormularyPic);
            Para[2] = new SqlParameter("@GoodsOne", d_FormulaEntity.GoodsOne);
            Para[3] = new SqlParameter("@GoodsTwo", d_FormulaEntity.GoodsTwo);
            Para[4] = new SqlParameter("@GoodsThree", d_FormulaEntity.GoodsThree);
            Para[5] = new SqlParameter("@GoodsFour", d_FormulaEntity.GoodsFour);
            Para[6] = new SqlParameter("@GoodsFive", d_FormulaEntity.GoodsFive);
            Para[7] = new SqlParameter("@GoodsSix", d_FormulaEntity.GoodsSix);
            Para[8] = new SqlParameter("@GoodsSeven", d_FormulaEntity.GoodsSeven);
            Para[9] = new SqlParameter("@GoodsEight", d_FormulaEntity.GoodsEight);
            Para[10] = new SqlParameter("@GoodsNine", d_FormulaEntity.GoodsNine);
            Para[11] = new SqlParameter("@GoodsTen", d_FormulaEntity.GoodsTen);
            Para[12] = new SqlParameter("@PicUrlOne", d_FormulaEntity.PicUrlOne);
            Para[13] = new SqlParameter("@PicUrlTwo", d_FormulaEntity.PicUrlTwo);
            Para[14] = new SqlParameter("@PicUrlThree", d_FormulaEntity.PicUrlThree);
            Para[15] = new SqlParameter("@PicUrlFour", d_FormulaEntity.PicUrlFour);
            Para[16] = new SqlParameter("@PicUrlFive", d_FormulaEntity.PicUrlFive);
            Para[17] = new SqlParameter("@PicUrlSix", d_FormulaEntity.PicUrlSix);
            Para[18] = new SqlParameter("@PicUrlEight", d_FormulaEntity.PicUrlEight);
            Para[19] = new SqlParameter("@PicUrlSeven", d_FormulaEntity.PicUrlSeven);
            Para[20] = new SqlParameter("@PicUrlNine", d_FormulaEntity.PicUrlNine);
            Para[21] = new SqlParameter("@PicUrlTen", d_FormulaEntity.PicUrlTen);
            Para[22] = new SqlParameter("@ClassId", d_FormulaEntity.ClassId);
            Para[23] = new SqlParameter("@ClassName", d_FormulaEntity.ClassName);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Formula_Create", Para);
        }

        public int Update(D_FormulaEntity d_FormulaEntity)
        {
            SqlParameter[] Para = new SqlParameter[25];
            Para[0] = new SqlParameter("@Id", d_FormulaEntity.Id);
            Para[1] = new SqlParameter("@Formulary", d_FormulaEntity.Formulary);
            Para[2] = new SqlParameter("@FormularyPic", d_FormulaEntity.FormularyPic);
            Para[3] = new SqlParameter("@GoodsOne", d_FormulaEntity.GoodsOne);
            Para[4] = new SqlParameter("@GoodsTwo", d_FormulaEntity.GoodsTwo);
            Para[5] = new SqlParameter("@GoodsThree", d_FormulaEntity.GoodsThree);
            Para[6] = new SqlParameter("@GoodsFour", d_FormulaEntity.GoodsFour);
            Para[7] = new SqlParameter("@GoodsFive", d_FormulaEntity.GoodsFive);
            Para[8] = new SqlParameter("@GoodsSix", d_FormulaEntity.GoodsSix);
            Para[9] = new SqlParameter("@GoodsSeven", d_FormulaEntity.GoodsSeven);
            Para[10] = new SqlParameter("@GoodsEight", d_FormulaEntity.GoodsEight);
            Para[11] = new SqlParameter("@GoodsNine", d_FormulaEntity.GoodsNine);
            Para[12] = new SqlParameter("@GoodsTen", d_FormulaEntity.GoodsTen);
            Para[13] = new SqlParameter("@PicUrlOne", d_FormulaEntity.PicUrlOne);
            Para[14] = new SqlParameter("@PicUrlTwo", d_FormulaEntity.PicUrlTwo);
            Para[15] = new SqlParameter("@PicUrlThree", d_FormulaEntity.PicUrlThree);
            Para[16] = new SqlParameter("@PicUrlFour", d_FormulaEntity.PicUrlFour);
            Para[17] = new SqlParameter("@PicUrlFive", d_FormulaEntity.PicUrlFive);
            Para[18] = new SqlParameter("@PicUrlSix", d_FormulaEntity.PicUrlSix);
            Para[19] = new SqlParameter("@PicUrlEight", d_FormulaEntity.PicUrlEight);
            Para[20] = new SqlParameter("@PicUrlSeven", d_FormulaEntity.PicUrlSeven);
            Para[21] = new SqlParameter("@PicUrlNine", d_FormulaEntity.PicUrlNine);
            Para[22] = new SqlParameter("@PicUrlTen", d_FormulaEntity.PicUrlTen);
            Para[23] = new SqlParameter("@ClassId", d_FormulaEntity.ClassId);
            Para[24] = new SqlParameter("@ClassName", d_FormulaEntity.ClassName);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Formula_Update", Para);
        }

        public int Del(Int32 Id)
        {
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Formula_Del", Para);
        }

        public int Del(string Id)
        {
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Formula_Dels", Para);
        }

        public D_FormulaEntity GetD_FormulaEntity(Int32 Id)
        {
            D_FormulaEntity d_formulaEntity = null;
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Formula_GetInfoById", Para);
            if (Set.Tables[0].Rows.Count > 0)
            {
                DataRow drv = Set.Tables[0].Rows[0];
                d_formulaEntity = new D_FormulaEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["Formulary"].ToString(),
                    drv["FormularyPic"].ToString(),
                    drv["GoodsOne"].ToString(),
                    drv["GoodsTwo"].ToString(),
                    drv["GoodsThree"].ToString(),
                    drv["GoodsFour"].ToString(),
                    drv["GoodsFive"].ToString(),
                    drv["GoodsSix"].ToString(),
                    drv["GoodsSeven"].ToString(),
                    drv["GoodsEight"].ToString(),
                    drv["GoodsNine"].ToString(),
                    drv["GoodsTen"].ToString(),
                    drv["PicUrlOne"].ToString(),
                    drv["PicUrlTwo"].ToString(),
                    drv["PicUrlThree"].ToString(),
                    drv["PicUrlFour"].ToString(),
                    drv["PicUrlFive"].ToString(),
                    drv["PicUrlSix"].ToString(),
                    drv["PicUrlEight"].ToString(),
                    drv["PicUrlSeven"].ToString(),
                    drv["PicUrlNine"].ToString(),
                    drv["PicUrlTen"].ToString(),
                    Int32.Parse(drv["ClassId"].ToString()),
                    drv["ClassName"].ToString());
            }
            return d_formulaEntity;
        }

        public IList GetD_FormulaList(DevinFrame.Pagination.Condition _condition)
        {
            IList list = new ArrayList();

            if (_condition.TableName == "")
                _condition.TableName = "D_Formula";
            SqlParameter[] Para = new SqlParameter[5];
            Para[0] = new SqlParameter("@TableName", _condition.TableName);
            Para[1] = new SqlParameter("@TopNum", _condition.TopNum);
            Para[2] = new SqlParameter("@FieldList", _condition.FieldList);
            Para[3] = new SqlParameter("@Conditions", _condition.Conditions);
            Para[4] = new SqlParameter("@OrderBy", _condition.OrderBy);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Condition", Para);
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_FormulaEntity d_formulaEntity = new D_FormulaEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["Formulary"].ToString(),
                    drv["FormularyPic"].ToString(),
                    drv["GoodsOne"].ToString(),
                    drv["GoodsTwo"].ToString(),
                    drv["GoodsThree"].ToString(),
                    drv["GoodsFour"].ToString(),
                    drv["GoodsFive"].ToString(),
                    drv["GoodsSix"].ToString(),
                    drv["GoodsSeven"].ToString(),
                    drv["GoodsEight"].ToString(),
                    drv["GoodsNine"].ToString(),
                    drv["GoodsTen"].ToString(),
                    drv["PicUrlOne"].ToString(),
                    drv["PicUrlTwo"].ToString(),
                    drv["PicUrlThree"].ToString(),
                    drv["PicUrlFour"].ToString(),
                    drv["PicUrlFive"].ToString(),
                    drv["PicUrlSix"].ToString(),
                    drv["PicUrlEight"].ToString(),
                    drv["PicUrlSeven"].ToString(),
                    drv["PicUrlNine"].ToString(),
                    drv["PicUrlTen"].ToString(),
                    Int32.Parse(drv["ClassId"].ToString()),
                    drv["ClassName"].ToString());
                list.Add(d_formulaEntity);
            }
            return list;
        }

        public IList GetD_FormulaList(DevinFrame.Pagination.Pagination _pagination)
        {
            IList list = new ArrayList();

            if (_pagination.TableName == "")
                _pagination.TableName = "D_Formula";
            SqlParameter[] Para = new SqlParameter[10];
            Para[0] = new SqlParameter("@TableName", _pagination.TableName);
            Para[1] = new SqlParameter("@PKey", _pagination.PKey);
            Para[2] = new SqlParameter("@FieldList", _pagination.FieldList);
            Para[3] = new SqlParameter("@Condition", _pagination.Condition);
            Para[4] = new SqlParameter("@OrderBy", _pagination.OrderBy);
            Para[5] = new SqlParameter("@Sql", _pagination.Sql);
            Para[6] = new SqlParameter("@SqlGetRC", _pagination.SqlGetRC);
            Para[7] = new SqlParameter("@CurrPage", _pagination.CurrPage);
            Para[8] = new SqlParameter("@PageSize", _pagination.PageSize);
            Para[9] = new SqlParameter("@RecordCount", _pagination.RecordCount);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Pagination", Para);
            _recordcount = int.Parse(Set.Tables[1].Rows[0]["RecordCount"].ToString());
            _pagecount = int.Parse(Set.Tables[1].Rows[0]["PageCount"].ToString());
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_FormulaEntity d_formulaEntity = new D_FormulaEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["Formulary"].ToString(),
                    drv["FormularyPic"].ToString(),
                    drv["GoodsOne"].ToString(),
                    drv["GoodsTwo"].ToString(),
                    drv["GoodsThree"].ToString(),
                    drv["GoodsFour"].ToString(),
                    drv["GoodsFive"].ToString(),
                    drv["GoodsSix"].ToString(),
                    drv["GoodsSeven"].ToString(),
                    drv["GoodsEight"].ToString(),
                    drv["GoodsNine"].ToString(),
                    drv["GoodsTen"].ToString(),
                    drv["PicUrlOne"].ToString(),
                    drv["PicUrlTwo"].ToString(),
                    drv["PicUrlThree"].ToString(),
                    drv["PicUrlFour"].ToString(),
                    drv["PicUrlFive"].ToString(),
                    drv["PicUrlSix"].ToString(),
                    drv["PicUrlEight"].ToString(),
                    drv["PicUrlSeven"].ToString(),
                    drv["PicUrlNine"].ToString(),
                    drv["PicUrlTen"].ToString(),
                    Int32.Parse(drv["ClassId"].ToString()),
                    drv["ClassName"].ToString());
                list.Add(d_formulaEntity);
            }
            return list;
        }
    }
}