using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections;
using DevinFrame.WebGame.Entity;
using DevinFrame.Date;
using DevinFrame.WebGame.Methods;

namespace DevinFrame.WebGame.SqlServer
{
    public class D_Links : MD_Links
    {
        protected int _recordcount;
        protected int _pagecount;
        public D_Links() { }
        public int RecordCount()
        {
            return _recordcount;
        }
        public int PageCount()
        {
            return _pagecount;
        }
        public Int32 Insert(D_LinksEntity d_LinksEntity)
        {
            SqlParameter[] Para = new SqlParameter[5];
            Para[0] = new SqlParameter("@LinkName", d_LinksEntity.LinkName);
            Para[1] = new SqlParameter("@LinkUrl", d_LinksEntity.LinkUrl);
            Para[2] = new SqlParameter("@LinkICO", d_LinksEntity.LinkICO);
            Para[3] = new SqlParameter("@LinkState", d_LinksEntity.LinkState);
            Para[4] = new SqlParameter("@State", d_LinksEntity.State);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Links_Create", Para);
        }

        public int Update(D_LinksEntity d_LinksEntity)
        {
            SqlParameter[] Para = new SqlParameter[6];
            Para[0] = new SqlParameter("@Id", d_LinksEntity.Id);
            Para[1] = new SqlParameter("@LinkName", d_LinksEntity.LinkName);
            Para[2] = new SqlParameter("@LinkUrl", d_LinksEntity.LinkUrl);
            Para[3] = new SqlParameter("@LinkICO", d_LinksEntity.LinkICO);
            Para[4] = new SqlParameter("@LinkState", d_LinksEntity.LinkState);
            Para[5] = new SqlParameter("@State", d_LinksEntity.State);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Links_Update", Para);
        }

        public int Del(Int32 Id)
        {
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Links_Del", Para);
        }

        public int Del(string Id)
        {
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Links_Dels", Para);
        }

        public D_LinksEntity GetD_LinksEntity(Int32 Id)
        {
            D_LinksEntity d_linksEntity = null;
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Links_GetInfoById", Para);
            if (Set.Tables[0].Rows.Count > 0)
            {
                DataRow drv = Set.Tables[0].Rows[0];
                d_linksEntity = new D_LinksEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["LinkName"].ToString(),
                    drv["LinkUrl"].ToString(),
                    drv["LinkICO"].ToString(),
                    Boolean.Parse(drv["LinkState"].ToString()),
                    Boolean.Parse(drv["State"].ToString()));
            }
            return d_linksEntity;
        }

        public IList GetD_LinksList(DevinFrame.Pagination.Condition _condition)
        {
            IList list = new ArrayList();

            if (_condition.TableName == "")
                _condition.TableName = "D_Links";
            SqlParameter[] Para = new SqlParameter[5];
            Para[0] = new SqlParameter("@TableName", _condition.TableName);
            Para[1] = new SqlParameter("@TopNum", _condition.TopNum);
            Para[2] = new SqlParameter("@FieldList", _condition.FieldList);
            Para[3] = new SqlParameter("@Conditions", _condition.Conditions);
            Para[4] = new SqlParameter("@OrderBy", _condition.OrderBy);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Condition", Para);
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_LinksEntity d_linksEntity = new D_LinksEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["LinkName"].ToString(),
                    drv["LinkUrl"].ToString(),
                    drv["LinkICO"].ToString(),
                    Boolean.Parse(drv["LinkState"].ToString()),
                    Boolean.Parse(drv["State"].ToString()));
                list.Add(d_linksEntity);
            }
            return list;
        }

        public IList GetD_LinksList(DevinFrame.Pagination.Pagination _pagination)
        {
            IList list = new ArrayList();

            if (_pagination.TableName == "")
                _pagination.TableName = "D_Links";
            SqlParameter[] Para = new SqlParameter[10];
            Para[0] = new SqlParameter("@TableName", _pagination.TableName);
            Para[1] = new SqlParameter("@PKey", _pagination.PKey);
            Para[2] = new SqlParameter("@FieldList", _pagination.FieldList);
            Para[3] = new SqlParameter("@Condition", _pagination.Condition);
            Para[4] = new SqlParameter("@OrderBy", _pagination.OrderBy);
            Para[5] = new SqlParameter("@Sql", _pagination.Sql);
            Para[6] = new SqlParameter("@SqlGetRC", _pagination.SqlGetRC);
            Para[7] = new SqlParameter("@CurrPage", _pagination.CurrPage);
            Para[8] = new SqlParameter("@PageSize", _pagination.PageSize);
            Para[9] = new SqlParameter("@RecordCount", _pagination.RecordCount);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Pagination", Para);
            _recordcount = int.Parse(Set.Tables[1].Rows[0]["RecordCount"].ToString());
            _pagecount = int.Parse(Set.Tables[1].Rows[0]["PageCount"].ToString());
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_LinksEntity d_linksEntity = new D_LinksEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["LinkName"].ToString(),
                    drv["LinkUrl"].ToString(),
                    drv["LinkICO"].ToString(),
                    Boolean.Parse(drv["LinkState"].ToString()),
                    Boolean.Parse(drv["State"].ToString()));
                list.Add(d_linksEntity);
            }
            return list;
        }
    }
}