using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections;
using DevinFrame.WebGame.Entity;
using DevinFrame.Date;
using DevinFrame.WebGame.Methods;

namespace DevinFrame.WebGame.SqlServer
{
    public class D_Message : MD_Message
    {
        protected int _recordcount;
        protected int _pagecount;
        public D_Message() { }
        public int RecordCount()
        {
            return _recordcount;
        }
        public int PageCount()
        {
            return _pagecount;
        }
        public Int32 Insert(D_MessageEntity d_MessageEntity)
        {
            SqlParameter[] Para = new SqlParameter[8];
            Para[0] = new SqlParameter("@ByName", d_MessageEntity.ByName);
            Para[1] = new SqlParameter("@MirName", d_MessageEntity.MirName);
            Para[2] = new SqlParameter("@TencentQQ", d_MessageEntity.TencentQQ);
            Para[3] = new SqlParameter("@MirUrl", d_MessageEntity.MirUrl);
            Para[4] = new SqlParameter("@Telphone", d_MessageEntity.Telphone);
            Para[5] = new SqlParameter("@Email", d_MessageEntity.Email);
            Para[6] = new SqlParameter("@Content", d_MessageEntity.Content);
            Para[7] = new SqlParameter("@HostIp", d_MessageEntity.HostIp);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Message_Create", Para);
        }

        public int Update(D_MessageEntity d_MessageEntity)
        {
            SqlParameter[] Para = new SqlParameter[2];
            Para[0] = new SqlParameter("@Id", d_MessageEntity.Id);
            Para[1] = new SqlParameter("@Revert", d_MessageEntity.Revert);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Message_Update", Para);
        }
        public int UpdateState(Int32 Id)
        {
            SqlParameter[] Para = new SqlParameter[2];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Message_Updates", Para);
        }
        public int State(Int32 Id)
        {
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Message_State", Para);
        }
        
        public int Del(Int32 Id)
        {
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Message_Del", Para);
        }

        public int Del(string Id)
        {
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Message_Dels", Para);
        }

        public D_MessageEntity GetD_MessageEntity(Int32 Id)
        {
            D_MessageEntity d_messageEntity = null;
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Message_GetInfoById", Para);
            if (Set.Tables[0].Rows.Count > 0)
            {
                DataRow drv = Set.Tables[0].Rows[0];
                d_messageEntity = new D_MessageEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["ByName"].ToString(),
                    drv["MirName"].ToString(),
                    drv["TencentQQ"].ToString(),
                    drv["MirUrl"].ToString(),
                    drv["Telphone"].ToString(),
                    drv["Email"].ToString(),
                    drv["Content"].ToString(),
                    DateTime.Parse(drv["CreateTime"].ToString()),
                    drv["Revert"].ToString(),
                    drv["HostIp"].ToString(),
                    Boolean.Parse(drv["State"].ToString()));
            }
            return d_messageEntity;
        }

        public IList GetD_MessageList(DevinFrame.Pagination.Condition _condition)
        {
            IList list = new ArrayList();

            if (_condition.TableName == "")
                _condition.TableName = "D_Message";
            SqlParameter[] Para = new SqlParameter[5];
            Para[0] = new SqlParameter("@TableName", _condition.TableName);
            Para[1] = new SqlParameter("@TopNum", _condition.TopNum);
            Para[2] = new SqlParameter("@FieldList", _condition.FieldList);
            Para[3] = new SqlParameter("@Conditions", _condition.Conditions);
            Para[4] = new SqlParameter("@OrderBy", _condition.OrderBy);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Condition", Para);
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_MessageEntity d_messageEntity = new D_MessageEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["ByName"].ToString(),
                    drv["MirName"].ToString(),
                    drv["TencentQQ"].ToString(),
                    drv["MirUrl"].ToString(),
                    drv["Telphone"].ToString(),
                    drv["Email"].ToString(),
                    drv["Content"].ToString(),
                    DateTime.Parse(drv["CreateTime"].ToString()),
                    drv["Revert"].ToString(),
                    drv["HostIp"].ToString(),
                    Boolean.Parse(drv["State"].ToString()));
                list.Add(d_messageEntity);
            }
            return list;
        }

        public IList GetD_MessageList(DevinFrame.Pagination.Pagination _pagination)
        {
            IList list = new ArrayList();

            if (_pagination.TableName == "")
                _pagination.TableName = "D_Message";
            SqlParameter[] Para = new SqlParameter[10];
            Para[0] = new SqlParameter("@TableName", _pagination.TableName);
            Para[1] = new SqlParameter("@PKey", _pagination.PKey);
            Para[2] = new SqlParameter("@FieldList", _pagination.FieldList);
            Para[3] = new SqlParameter("@Condition", _pagination.Condition);
            Para[4] = new SqlParameter("@OrderBy", _pagination.OrderBy);
            Para[5] = new SqlParameter("@Sql", _pagination.Sql);
            Para[6] = new SqlParameter("@SqlGetRC", _pagination.SqlGetRC);
            Para[7] = new SqlParameter("@CurrPage", _pagination.CurrPage);
            Para[8] = new SqlParameter("@PageSize", _pagination.PageSize);
            Para[9] = new SqlParameter("@RecordCount", _pagination.RecordCount);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Pagination", Para);
            _recordcount = int.Parse(Set.Tables[1].Rows[0]["RecordCount"].ToString());
            _pagecount = int.Parse(Set.Tables[1].Rows[0]["PageCount"].ToString());
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_MessageEntity d_messageEntity = new D_MessageEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["ByName"].ToString(),
                    drv["MirName"].ToString(),
                    drv["TencentQQ"].ToString(),
                    drv["MirUrl"].ToString(),
                    drv["Telphone"].ToString(),
                    drv["Email"].ToString(),
                    drv["Content"].ToString(),
                    DateTime.Parse(drv["CreateTime"].ToString()),
                    drv["Revert"].ToString(),
                    drv["HostIp"].ToString(),
                    Boolean.Parse(drv["State"].ToString()));
                list.Add(d_messageEntity);
            }
            return list;
        }
    }
}