using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections;
using DevinFrame.WebGame.Entity;
using DevinFrame.Date;
using DevinFrame.WebGame.Methods;

namespace DevinFrame.WebGame.SqlServer
{
    public class D_Musci : MD_Musci
    {
        protected int _recordcount;
        protected int _pagecount;
        public D_Musci() { }
        public int RecordCount()
        {
            return _recordcount;
        }
        public int PageCount()
        {
            return _pagecount;
        }
        public Int32 Insert(D_MusciEntity d_MusciEntity)
        {
            SqlParameter[] Para = new SqlParameter[3];
            Para[0] = new SqlParameter("@Title", d_MusciEntity.Title);
            Para[1] = new SqlParameter("@Singer", d_MusciEntity.Singer);
            Para[2] = new SqlParameter("@FilePath", d_MusciEntity.FilePath);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Musci_Create", Para);
        }

        public int Update(D_MusciEntity d_MusciEntity)
        {
            SqlParameter[] Para = new SqlParameter[4];
            Para[0] = new SqlParameter("@Id", d_MusciEntity.Id);
            Para[1] = new SqlParameter("@Title", d_MusciEntity.Title);
            Para[2] = new SqlParameter("@Singer", d_MusciEntity.Singer);
            Para[3] = new SqlParameter("@FilePath", d_MusciEntity.FilePath);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Musci_Update", Para);
        }

        public int Del(Int32 Id)
        {
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Musci_Del", Para);
        }

        public int Del(string Id)
        {
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Musci_Dels", Para);
        }

        public D_MusciEntity GetD_MusciEntity(Int32 Id)
        {
            D_MusciEntity d_musciEntity = null;
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Musci_GetInfoById", Para);
            if (Set.Tables[0].Rows.Count > 0)
            {
                DataRow drv = Set.Tables[0].Rows[0];
                d_musciEntity = new D_MusciEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["Title"].ToString(),
                    drv["Singer"].ToString(),
                    drv["FilePath"].ToString());
            }
            return d_musciEntity;
        }

        public IList GetD_MusciList(DevinFrame.Pagination.Condition _condition)
        {
            IList list = new ArrayList();

            if (_condition.TableName == "")
                _condition.TableName = "D_Musci";
            SqlParameter[] Para = new SqlParameter[5];
            Para[0] = new SqlParameter("@TableName", _condition.TableName);
            Para[1] = new SqlParameter("@TopNum", _condition.TopNum);
            Para[2] = new SqlParameter("@FieldList", _condition.FieldList);
            Para[3] = new SqlParameter("@Conditions", _condition.Conditions);
            Para[4] = new SqlParameter("@OrderBy", _condition.OrderBy);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Condition", Para);
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_MusciEntity d_musciEntity = new D_MusciEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["Title"].ToString(),
                    drv["Singer"].ToString(),
                    drv["FilePath"].ToString());
                list.Add(d_musciEntity);
            }
            return list;
        }

        public IList GetD_MusciList(DevinFrame.Pagination.Pagination _pagination)
        {
            IList list = new ArrayList();

            if (_pagination.TableName == "")
                _pagination.TableName = "D_Musci";
            SqlParameter[] Para = new SqlParameter[10];
            Para[0] = new SqlParameter("@TableName", _pagination.TableName);
            Para[1] = new SqlParameter("@PKey", _pagination.PKey);
            Para[2] = new SqlParameter("@FieldList", _pagination.FieldList);
            Para[3] = new SqlParameter("@Condition", _pagination.Condition);
            Para[4] = new SqlParameter("@OrderBy", _pagination.OrderBy);
            Para[5] = new SqlParameter("@Sql", _pagination.Sql);
            Para[6] = new SqlParameter("@SqlGetRC", _pagination.SqlGetRC);
            Para[7] = new SqlParameter("@CurrPage", _pagination.CurrPage);
            Para[8] = new SqlParameter("@PageSize", _pagination.PageSize);
            Para[9] = new SqlParameter("@RecordCount", _pagination.RecordCount);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Pagination", Para);
            _recordcount = int.Parse(Set.Tables[1].Rows[0]["RecordCount"].ToString());
            _pagecount = int.Parse(Set.Tables[1].Rows[0]["PageCount"].ToString());
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_MusciEntity d_musciEntity = new D_MusciEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["Title"].ToString(),
                    drv["Singer"].ToString(),
                    drv["FilePath"].ToString());
                list.Add(d_musciEntity);
            }
            return list;
        }
    }
}