using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections;
using DevinFrame.WebGame.Entity;
using DevinFrame.Date;
using DevinFrame.WebGame.Methods;

namespace DevinFrame.WebGame.SqlServer
{
    public class D_News : MD_News
    {
        protected int _recordcount;
        protected int _pagecount;
        public D_News() { }
        public int RecordCount()
        {
            return _recordcount;
        }
        public int PageCount()
        {
            return _pagecount;
        }
        public Int32 Insert(D_NewsEntity d_NewsEntity)
        {
            SqlParameter[] Para = new SqlParameter[7];
            Para[0] = new SqlParameter("@NewsTitle", d_NewsEntity.NewsTitle);
            Para[1] = new SqlParameter("@Content", d_NewsEntity.Content);
            Para[2] = new SqlParameter("@FileName", d_NewsEntity.FileName);
            Para[3] = new SqlParameter("@ClassName", d_NewsEntity.ClassName);
            Para[4] = new SqlParameter("@ClassId", d_NewsEntity.ClassId);
            Para[5] = new SqlParameter("@State", d_NewsEntity.State);
            Para[6] = new SqlParameter("@Commend", d_NewsEntity.Commend);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_News_Create", Para);
        }

        public int Update(D_NewsEntity d_NewsEntity)
        {
            SqlParameter[] Para = new SqlParameter[8];
            Para[0] = new SqlParameter("@Id", d_NewsEntity.Id);
            Para[1] = new SqlParameter("@NewsTitle", d_NewsEntity.NewsTitle);
            Para[2] = new SqlParameter("@Content", d_NewsEntity.Content);
            Para[3] = new SqlParameter("@FileName", d_NewsEntity.FileName);
            Para[4] = new SqlParameter("@ClassName", d_NewsEntity.ClassName);
            Para[5] = new SqlParameter("@ClassId", d_NewsEntity.ClassId);
            Para[6] = new SqlParameter("@State", d_NewsEntity.State);
            Para[7] = new SqlParameter("@Commend", d_NewsEntity.Commend);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_News_Update", Para);
        }

        public int Del(Int32 Id)
        {
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_News_Del", Para);
        }

        public int Del(string Id)
        {
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_News_Dels", Para);
        }

        public D_NewsEntity GetD_NewsEntity(Int32 Id)
        {
            D_NewsEntity d_newsEntity = null;
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_News_GetInfoById", Para);
            if (Set.Tables[0].Rows.Count > 0)
            {
                DataRow drv = Set.Tables[0].Rows[0];
                d_newsEntity = new D_NewsEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["NewsTitle"].ToString(),
                    drv["Content"].ToString(),
                    drv["Vists"].ToString(),
                    drv["FileName"].ToString(),
                    drv["ClassName"].ToString(),
                    Int32.Parse(drv["ClassId"].ToString()),
                    Boolean.Parse(drv["State"].ToString()),
                    Boolean.Parse(drv["Commend"].ToString()),
                    DateTime.Parse(drv["CreateTime"].ToString()));
            }
            return d_newsEntity;
        }

        public IList GetD_NewsList(DevinFrame.Pagination.Condition _condition)
        {
            IList list = new ArrayList();

            if (_condition.TableName == "")
                _condition.TableName = "D_News";
            SqlParameter[] Para = new SqlParameter[5];
            Para[0] = new SqlParameter("@TableName", _condition.TableName);
            Para[1] = new SqlParameter("@TopNum", _condition.TopNum);
            Para[2] = new SqlParameter("@FieldList", _condition.FieldList);
            Para[3] = new SqlParameter("@Conditions", _condition.Conditions);
            Para[4] = new SqlParameter("@OrderBy", _condition.OrderBy);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Condition", Para);
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_NewsEntity d_newsEntity = new D_NewsEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["NewsTitle"].ToString(),
                    drv["Content"].ToString(),
                    drv["Vists"].ToString(),
                    drv["FileName"].ToString(),
                    drv["ClassName"].ToString(),
                    Int32.Parse(drv["ClassId"].ToString()),
                    Boolean.Parse(drv["State"].ToString()),
                    Boolean.Parse(drv["Commend"].ToString()),
                    DateTime.Parse(drv["CreateTime"].ToString()));
                list.Add(d_newsEntity);
            }
            return list;
        }

        public IList GetD_NewsList(DevinFrame.Pagination.Pagination _pagination)
        {
            IList list = new ArrayList();

            if (_pagination.TableName == "")
                _pagination.TableName = "D_News";
            SqlParameter[] Para = new SqlParameter[10];
            Para[0] = new SqlParameter("@TableName", _pagination.TableName);
            Para[1] = new SqlParameter("@PKey", _pagination.PKey);
            Para[2] = new SqlParameter("@FieldList", _pagination.FieldList);
            Para[3] = new SqlParameter("@Condition", _pagination.Condition);
            Para[4] = new SqlParameter("@OrderBy", _pagination.OrderBy);
            Para[5] = new SqlParameter("@Sql", _pagination.Sql);
            Para[6] = new SqlParameter("@SqlGetRC", _pagination.SqlGetRC);
            Para[7] = new SqlParameter("@CurrPage", _pagination.CurrPage);
            Para[8] = new SqlParameter("@PageSize", _pagination.PageSize);
            Para[9] = new SqlParameter("@RecordCount", _pagination.RecordCount);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Pagination", Para);
            _recordcount = int.Parse(Set.Tables[1].Rows[0]["RecordCount"].ToString());
            _pagecount = int.Parse(Set.Tables[1].Rows[0]["PageCount"].ToString());
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_NewsEntity d_newsEntity = new D_NewsEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["NewsTitle"].ToString(),
                    drv["Content"].ToString(),
                    drv["Vists"].ToString(),
                    drv["FileName"].ToString(),
                    drv["ClassName"].ToString(),
                    Int32.Parse(drv["ClassId"].ToString()),
                    Boolean.Parse(drv["State"].ToString()),
                    Boolean.Parse(drv["Commend"].ToString()),
                    DateTime.Parse(drv["CreateTime"].ToString()));
                list.Add(d_newsEntity);
            }
            return list;
        }
    }
}