using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections;
using DevinFrame.WebGame.Entity;
using DevinFrame.Date;
using DevinFrame.WebGame.Methods;

namespace DevinFrame.WebGame.SqlServer
{
    public class D_Pictures : MD_Pictures
    {
        protected int _recordcount;
        protected int _pagecount;
        public D_Pictures() { }
        public int RecordCount()
        {
            return _recordcount;
        }
        public int PageCount()
        {
            return _pagecount;
        }
        public Int32 Insert(D_PicturesEntity d_PicturesEntity)
        {
            SqlParameter[] Para = new SqlParameter[4];
            Para[0] = new SqlParameter("@Title", d_PicturesEntity.Title);
            Para[1] = new SqlParameter("@PicUrl", d_PicturesEntity.PicUrl);
            Para[2] = new SqlParameter("@ClassId", d_PicturesEntity.ClassId);
            Para[3] = new SqlParameter("@ClassName", d_PicturesEntity.ClassName);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Pictures_Create", Para);
        }

        public int Update(D_PicturesEntity d_PicturesEntity)
        {
            SqlParameter[] Para = new SqlParameter[5];
            Para[0] = new SqlParameter("@Id", d_PicturesEntity.Id);
            Para[1] = new SqlParameter("@Title", d_PicturesEntity.Title);
            Para[2] = new SqlParameter("@PicUrl", d_PicturesEntity.PicUrl);
            Para[3] = new SqlParameter("@ClassId", d_PicturesEntity.ClassId);
            Para[4] = new SqlParameter("@ClassName", d_PicturesEntity.ClassName);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Pictures_Update", Para);
        }

        public int Del(Int32 Id)
        {
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Pictures_Del", Para);
        }

        public int Del(string Id)
        {
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Pictures_Dels", Para);
        }

        public D_PicturesEntity GetD_PicturesEntity(Int32 Id)
        {
            D_PicturesEntity d_picturesEntity = null;
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Pictures_GetInfoById", Para);
            if (Set.Tables[0].Rows.Count > 0)
            {
                DataRow drv = Set.Tables[0].Rows[0];
                d_picturesEntity = new D_PicturesEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["Title"].ToString(),
                    drv["PicUrl"].ToString(),
                    Int32.Parse(drv["ViewNum"].ToString()),
                    Int32.Parse(drv["ClassId"].ToString()),
                    drv["ClassName"].ToString());
            }
            return d_picturesEntity;
        }

        public IList GetD_PicturesList(DevinFrame.Pagination.Condition _condition)
        {
            IList list = new ArrayList();

            if (_condition.TableName == "")
                _condition.TableName = "D_Pictures";
            SqlParameter[] Para = new SqlParameter[5];
            Para[0] = new SqlParameter("@TableName", _condition.TableName);
            Para[1] = new SqlParameter("@TopNum", _condition.TopNum);
            Para[2] = new SqlParameter("@FieldList", _condition.FieldList);
            Para[3] = new SqlParameter("@Conditions", _condition.Conditions);
            Para[4] = new SqlParameter("@OrderBy", _condition.OrderBy);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Condition", Para);
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_PicturesEntity d_picturesEntity = new D_PicturesEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["Title"].ToString(),
                    drv["PicUrl"].ToString(),
                    Int32.Parse(drv["ViewNum"].ToString()),
                    Int32.Parse(drv["ClassId"].ToString()),
                    drv["ClassName"].ToString());
                list.Add(d_picturesEntity);
            }
            return list;
        }

        public IList GetD_PicturesList(DevinFrame.Pagination.Pagination _pagination)
        {
            IList list = new ArrayList();

            if (_pagination.TableName == "")
                _pagination.TableName = "D_Pictures";
            SqlParameter[] Para = new SqlParameter[10];
            Para[0] = new SqlParameter("@TableName", _pagination.TableName);
            Para[1] = new SqlParameter("@PKey", _pagination.PKey);
            Para[2] = new SqlParameter("@FieldList", _pagination.FieldList);
            Para[3] = new SqlParameter("@Condition", _pagination.Condition);
            Para[4] = new SqlParameter("@OrderBy", _pagination.OrderBy);
            Para[5] = new SqlParameter("@Sql", _pagination.Sql);
            Para[6] = new SqlParameter("@SqlGetRC", _pagination.SqlGetRC);
            Para[7] = new SqlParameter("@CurrPage", _pagination.CurrPage);
            Para[8] = new SqlParameter("@PageSize", _pagination.PageSize);
            Para[9] = new SqlParameter("@RecordCount", _pagination.RecordCount);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Pagination", Para);
            _recordcount = int.Parse(Set.Tables[1].Rows[0]["RecordCount"].ToString());
            _pagecount = int.Parse(Set.Tables[1].Rows[0]["PageCount"].ToString());
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_PicturesEntity d_picturesEntity = new D_PicturesEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["Title"].ToString(),
                    drv["PicUrl"].ToString(),
                    Int32.Parse(drv["ViewNum"].ToString()),
                    Int32.Parse(drv["ClassId"].ToString()),
                    drv["ClassName"].ToString());
                list.Add(d_picturesEntity);
            }
            return list;
        }
    }
}