using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections;
using DevinFrame.WebGame.Entity;
using DevinFrame.Date;
using DevinFrame.WebGame.Methods;

namespace DevinFrame.WebGame.SqlServer
{
    public class D_Service : MD_Service
    {
        protected int _recordcount;
        protected int _pagecount;
        public D_Service() { }
        public int RecordCount()
        {
            return _recordcount;
        }
        public int PageCount()
        {
            return _pagecount;
        }
        public Int32 Insert(D_ServiceEntity d_ServiceEntity)
        {
            SqlParameter[] Para = new SqlParameter[6];
            Para[0] = new SqlParameter("@Titles", d_ServiceEntity.Titles);
            Para[1] = new SqlParameter("@QQ", d_ServiceEntity.QQ);
            Para[2] = new SqlParameter("@Msn", d_ServiceEntity.Msn);
            Para[3] = new SqlParameter("@Mobile", d_ServiceEntity.Mobile);
            Para[4] = new SqlParameter("@Telphone", d_ServiceEntity.Telphone);
            Para[5] = new SqlParameter("@Fax", d_ServiceEntity.Fax);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Service_Create", Para);
        }

        public int Update(D_ServiceEntity d_ServiceEntity)
        {
            SqlParameter[] Para = new SqlParameter[7];
            Para[0] = new SqlParameter("@Id", d_ServiceEntity.Id);
            Para[1] = new SqlParameter("@Titles", d_ServiceEntity.Titles);
            Para[2] = new SqlParameter("@QQ", d_ServiceEntity.QQ);
            Para[3] = new SqlParameter("@Msn", d_ServiceEntity.Msn);
            Para[4] = new SqlParameter("@Mobile", d_ServiceEntity.Mobile);
            Para[5] = new SqlParameter("@Telphone", d_ServiceEntity.Telphone);
            Para[6] = new SqlParameter("@Fax", d_ServiceEntity.Fax);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Service_Update", Para);
        }

        public int Del(Int32 Id)
        {
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Service_Del", Para);
        }

        public int Del(string Id)
        {
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Service_Dels", Para);
        }

        public D_ServiceEntity GetD_ServiceEntity(Int32 Id)
        {
            D_ServiceEntity d_serviceEntity = null;
            SqlParameter[] Para = new SqlParameter[1];
            Para[0] = new SqlParameter("@Id", Id);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Service_GetInfoById", Para);
            if (Set.Tables[0].Rows.Count > 0)
            {
                DataRow drv = Set.Tables[0].Rows[0];
                d_serviceEntity = new D_ServiceEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["Titles"].ToString(),
                    drv["QQ"].ToString(),
                    drv["Msn"].ToString(),
                    drv["Mobile"].ToString(),
                    drv["Telphone"].ToString(),
                    drv["Fax"].ToString());
            }
            return d_serviceEntity;
        }

        public IList GetD_ServiceList(DevinFrame.Pagination.Condition _condition)
        {
            IList list = new ArrayList();

            if (_condition.TableName == "")
                _condition.TableName = "D_Service";
            SqlParameter[] Para = new SqlParameter[5];
            Para[0] = new SqlParameter("@TableName", _condition.TableName);
            Para[1] = new SqlParameter("@TopNum", _condition.TopNum);
            Para[2] = new SqlParameter("@FieldList", _condition.FieldList);
            Para[3] = new SqlParameter("@Conditions", _condition.Conditions);
            Para[4] = new SqlParameter("@OrderBy", _condition.OrderBy);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Condition", Para);
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_ServiceEntity d_serviceEntity = new D_ServiceEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["Titles"].ToString(),
                    drv["QQ"].ToString(),
                    drv["Msn"].ToString(),
                    drv["Mobile"].ToString(),
                    drv["Telphone"].ToString(),
                    drv["Fax"].ToString());
                list.Add(d_serviceEntity);
            }
            return list;
        }

        public IList GetD_ServiceList(DevinFrame.Pagination.Pagination _pagination)
        {
            IList list = new ArrayList();

            if (_pagination.TableName == "")
                _pagination.TableName = "D_Service";
            SqlParameter[] Para = new SqlParameter[10];
            Para[0] = new SqlParameter("@TableName", _pagination.TableName);
            Para[1] = new SqlParameter("@PKey", _pagination.PKey);
            Para[2] = new SqlParameter("@FieldList", _pagination.FieldList);
            Para[3] = new SqlParameter("@Condition", _pagination.Condition);
            Para[4] = new SqlParameter("@OrderBy", _pagination.OrderBy);
            Para[5] = new SqlParameter("@Sql", _pagination.Sql);
            Para[6] = new SqlParameter("@SqlGetRC", _pagination.SqlGetRC);
            Para[7] = new SqlParameter("@CurrPage", _pagination.CurrPage);
            Para[8] = new SqlParameter("@PageSize", _pagination.PageSize);
            Para[9] = new SqlParameter("@RecordCount", _pagination.RecordCount);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Pagination", Para);
            _recordcount = int.Parse(Set.Tables[1].Rows[0]["RecordCount"].ToString());
            _pagecount = int.Parse(Set.Tables[1].Rows[0]["PageCount"].ToString());
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_ServiceEntity d_serviceEntity = new D_ServiceEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["Titles"].ToString(),
                    drv["QQ"].ToString(),
                    drv["Msn"].ToString(),
                    drv["Mobile"].ToString(),
                    drv["Telphone"].ToString(),
                    drv["Fax"].ToString());
                list.Add(d_serviceEntity);
            }
            return list;
        }
    }
}