using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections;
using DevinFrame.WebGame.Entity;
using DevinFrame.Date;
using DevinFrame.WebGame.Methods;

namespace DevinFrame.WebGame.SqlServer
{
    public class D_property : MD_property
    {
        protected int _recordcount;
        protected int _pagecount;
        public D_property() { }
        public int RecordCount()
        {
            return _recordcount;
        }
        public int PageCount()
        {
            return _pagecount;
        }
        public Int32 Insert(D_propertyEntity d_propertyEntity)
        {
            SqlParameter[] Para = new SqlParameter[6];
            Para[0] = new SqlParameter("@Property", d_propertyEntity.Property);
            Para[1] = new SqlParameter("@Picture", d_propertyEntity.Picture);
            Para[2] = new SqlParameter("@Attributes", d_propertyEntity.Attributes);
            Para[3] = new SqlParameter("@ClassName", d_propertyEntity.ClassName);
            Para[4] = new SqlParameter("@ClassId", d_propertyEntity.ClassId);
            Para[5] = new SqlParameter("@TableName", d_propertyEntity.TableName);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_property_Create", Para);
        }

        public int Update(D_propertyEntity d_propertyEntity)
        {
            SqlParameter[] Para = new SqlParameter[7];
            Para[0] = new SqlParameter("@Id", d_propertyEntity.Id);
            Para[1] = new SqlParameter("@Property", d_propertyEntity.Property);
            Para[2] = new SqlParameter("@Picture", d_propertyEntity.Picture);
            Para[3] = new SqlParameter("@Attributes", d_propertyEntity.Attributes);
            Para[4] = new SqlParameter("@ClassName", d_propertyEntity.ClassName);
            Para[5] = new SqlParameter("@ClassId", d_propertyEntity.ClassId);
            Para[6] = new SqlParameter("@TableName", d_propertyEntity.TableName);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_property_Update", Para);
        }

        public int Del(Int32 Id, String TableName)
        {
            SqlParameter[] Para = new SqlParameter[2];
            Para[0] = new SqlParameter("@Id", Id);
            Para[1] = new SqlParameter("@TableName", TableName);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Category_Del", Para);
        }

        public int Del(String Id, String TableName)
        {
            SqlParameter[] Para = new SqlParameter[2];
            Para[0] = new SqlParameter("@Id", Id);
            Para[1] = new SqlParameter("@TableName", TableName);

            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "D_Category_Dels", Para);
        }

        public D_propertyEntity GetD_propertyEntity(Int32 Id, String TableName)
        {
            D_propertyEntity d_propertyEntity = null;
            SqlParameter[] Para = new SqlParameter[2];
            Para[0] = new SqlParameter("@Id", Id);
            Para[1] = new SqlParameter("@TableName", TableName);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_property_GetInfoById", Para);
            if (Set.Tables[0].Rows.Count > 0)
            {
                DataRow drv = Set.Tables[0].Rows[0];
                d_propertyEntity = new D_propertyEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["Property"].ToString(),
                    drv["Picture"].ToString(),
                    drv["Attributes"].ToString(),
                    drv["Remark"].ToString(),
                    Int32.Parse(drv["State"].ToString()),
                    drv["ClassName"].ToString(),
                    Int32.Parse(drv["ClassId"].ToString()));
            }
            return d_propertyEntity;
        }

        public IList GetD_propertyList(DevinFrame.Pagination.Condition _condition)
        {
            IList list = new ArrayList();

            SqlParameter[] Para = new SqlParameter[5];
            Para[0] = new SqlParameter("@TableName", _condition.TableName);
            Para[1] = new SqlParameter("@TopNum", _condition.TopNum);
            Para[2] = new SqlParameter("@FieldList", _condition.FieldList);
            Para[3] = new SqlParameter("@Conditions", _condition.Conditions);
            Para[4] = new SqlParameter("@OrderBy", _condition.OrderBy);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Condition", Para);
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_propertyEntity d_propertyEntity = new D_propertyEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["Property"].ToString(),
                    drv["Picture"].ToString(),
                    drv["Attributes"].ToString(),
                    drv["Remark"].ToString(),
                    Int32.Parse(drv["State"].ToString()),
                    drv["ClassName"].ToString(),
                    Int32.Parse(drv["ClassId"].ToString()));
                list.Add(d_propertyEntity);
            }
            return list;
        }

        public IList GetD_propertyList(DevinFrame.Pagination.Pagination _pagination)
        {
            IList list = new ArrayList();

            SqlParameter[] Para = new SqlParameter[10];
            Para[0] = new SqlParameter("@TableName", _pagination.TableName);
            Para[1] = new SqlParameter("@PKey", _pagination.PKey);
            Para[2] = new SqlParameter("@FieldList", _pagination.FieldList);
            Para[3] = new SqlParameter("@Condition", _pagination.Condition);
            Para[4] = new SqlParameter("@OrderBy", _pagination.OrderBy);
            Para[5] = new SqlParameter("@Sql", _pagination.Sql);
            Para[6] = new SqlParameter("@SqlGetRC", _pagination.SqlGetRC);
            Para[7] = new SqlParameter("@CurrPage", _pagination.CurrPage);
            Para[8] = new SqlParameter("@PageSize", _pagination.PageSize);
            Para[9] = new SqlParameter("@RecordCount", _pagination.RecordCount);

            DataSet Set = SqlHelper.ExecuteDataSet(CommandType.StoredProcedure, "D_Pagination", Para);
            _recordcount = int.Parse(Set.Tables[1].Rows[0]["RecordCount"].ToString());
            _pagecount = int.Parse(Set.Tables[1].Rows[0]["PageCount"].ToString());
            for (int i = 0; i < Set.Tables[0].Rows.Count; i++)
            {
                DataRow drv = Set.Tables[0].Rows[i];
                D_propertyEntity d_propertyEntity = new D_propertyEntity(
                    Int32.Parse(drv["Id"].ToString()),
                    drv["Property"].ToString(),
                    drv["Picture"].ToString(),
                    drv["Attributes"].ToString(),
                    drv["Remark"].ToString(),
                    Int32.Parse(drv["State"].ToString()),
                    drv["ClassName"].ToString(),
                    Int32.Parse(drv["ClassId"].ToString()));
                list.Add(d_propertyEntity);
            }
            return list;
        }
    }
}