using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DevinFrame.Common;
using DevinFrame.WebGame.Entity;
using DevinFrame.WebGame.Operation;
using System.Text;
namespace DevinFrame.WebGame.Web.aspx
{
    public partial class aspx : System.Web.UI.Page
    {
        protected string action;
        protected void Page_Load(object sender, EventArgs e)
        {
            action = Utility.CheckStr(Request["action"]);
            switch (action)
            {
                case "message":
                    LiveMessage();
                    break;
                case "messages":
                    Messages();
                    break;
                default:
                    Response.Write("<font color=\"red\">%&%&%&&()(_)_(&*!%&^!%&*@&!(*&*^*~)@!)_@</font>");
                    break;

            }
        }
        private void LiveMessage()
        {
            D_MessageEntity o = new D_MessageEntity();
            o.ByName = Utility.CheckStr(Request["ByName"]);
            o.Content = Utility.CheckStr(Request["Content"]);
            o.Email = Utility.CheckStr(Request["Email"]);
            o.HostIp = Utility.getClientIP();
            o.MirName = Utility.CheckStr(Request["MirName"]);
            o.MirUrl = Utility.CheckStr(Request["MirUrl"]);
            o.Telphone = Utility.CheckStr(Request["Telphone"]);
            o.TencentQQ = Utility.CheckStr(Request["TencentQQ"]);
            if (new D_Message().Insert(o) > 0)
                Response.Write(1);
            else
                Response.Write(0);
        }
        private void Messages()
        {
            int CurPage = 1;
            int PageSize = 8;
            if (Request["page"] != null)
                CurPage = int.Parse(Request["page"].ToString());
            if (Request["PageSize"] != null)
                PageSize = int.Parse(Request["PageSize"].ToString());
            if (CurPage < 1) CurPage = 1;
            DevinFrame.Pagination.Pagination pl = new DevinFrame.Pagination.Pagination();
            pl.OrderBy = "Id Desc";
            pl.CurrPage = CurPage;
            pl.PageSize = PageSize;
            pl.Condition = " And State = 1 ";
            D_Message d = new D_Message();
            IList i = (IList)d.GetD_MessageList(pl);
            StringBuilder s = new StringBuilder();
            StringBuilder ss = new StringBuilder();
            s.Append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\t<root>");
            s.Append("\n\t\t<pageinfo page=\"" + CurPage.ToString() + "\" RecordCount=\"" + d.PageCount() + "\" TotleCount=\"" + d.RecordCount() + "\" PageSize=\"" + PageSize + "\"></pageinfo>");
            foreach (D_MessageEntity o in i)
            {
                ss.Append("<div class=\"message\"><div class=\"b\">ߣ" + o.ByName + " ڣ" + o.CreateTime.ToShortDateString() + " ԣ<a href=\"http://www.ip.cn/?q=" + o.HostIp + "\" target=\"_blank\" title=\"ѯIP\">" + o.HostIp + "</a></div></div>");
                ss.Append("<div class=\"messages\">" + o.Content + "<div class=\"line\">վظ</div><div class=\"admin\">" + o.Revert + "</div></div>");
            }
            s.Append("\n\t\t\t<item> ");
            s.Append("<![CDATA[" + ss.ToString());
            s.Append("]]></item>");
            s.Append("\n\t</root>");
            Response.ContentType = "text/xml";
            Response.Write(s.ToString());
        }
    }
}
