using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DevinFrame.Common;
using DevinFrame.Pagination;
using DevinFrame.WebGame.Operation;
using DevinFrame.WebGame.Entity;
using System.Text;

namespace DevinFrame.WebGame.Web.manage
{
    public partial class Category : System.Web.UI.Page
    {
        protected string TableName = "";
        protected string PageTitle = "";
        protected string Action = "";
        protected string Type = "";
        protected int CurPage = 1;
        protected int PageCount = 0;
        protected int PageSize = 6;
        protected int TotalCount = 0;
        protected int KeepNum = 0;
        protected void Page_Load(object sender, EventArgs e)
        {
            Action = Utility.CheckStr(Request["action"]);
            Type = Utility.CheckStr(Request["t"]);
            switch (Type)
            {
                case "map":
                    TableName = "D_MapCategory";
                    PageTitle = Action == "add" ? "ӵͼ" : Action == "edit" ? "޸ĵͼ" : "ͼ";
                    KeepNum = 0;
                    break;
                case "monster":
                    TableName = "D_MonsterCategory";
                    PageTitle = Action == "add" ? "ӹ" : Action == "edit" ? "޸Ĺ" : "";
                    break;
                case "property":
                    TableName = "D_PropertyCategory";
                    PageTitle = Action == "add" ? "װ߷" : Action == "edit" ? "޸װ߷" : "װ߷";
                    KeepNum = 6;
                    break;
                case "blackart":
                    TableName = "D_BlackartCategory";
                    PageTitle = Action == "add" ? "Ӽħ" : Action == "edit" ? "޸ļħ" : "ħ";
                    KeepNum = 4;
                    break;
                case "news":
                    TableName = "D_NewsGategory";
                    PageTitle = Action == "add" ? "ŷ" : Action == "edit" ? "޸ŷ" : "ŷ";
                    KeepNum = 7;
                    break;
                case "ula":
                    TableName = "D_FormulaCategory";
                    PageTitle = Action == "add" ? "Ӻϳɹʽ" : Action == "edit" ? "޸ĺϳɹʽ" : "ϳɹʽ";
                    KeepNum = 4;
                    break;
                case "pic":
                    TableName = "D_PicturesCategory";
                    PageTitle = Action == "add" ? "ͼƬ" : Action == "edit" ? "޸ͼƬʽ" : "ͼƬ";
                    KeepNum = 3;
                    break;
            }
            if (!Page.IsPostBack)
            {
                btnSubmit.Attributes.Add("onclick", "return PageValid();");
                switch (Action)
                {
                    case "add":
                        AddItems.Visible = true;
                        ListItems.Visible = false;
                        break;
                    case "edit":
                        AddItems.Visible = true;
                        ListItems.Visible = false;
                        GetItem();
                        break;
                    case "del":
                        Delete();
                        break;
                    case "dels":
                        Deletes();
                        break;
                    default:
                        AddItems.Visible = false;
                        ListItems.Visible = true;
                        break;
                }
            }

        }
        private void Delete()
        {
            int id = Utility.CheckInt(Request["i"]);
            if (id < KeepNum)
            {
                Response.Write("<script>alert(\"˷ֶΪϵͳ,ֻ޸,ɾ!\");location.href=\"?t=" + Type + "\";</script>");
                return;
            }
            else
            {
                if (new D_Category().Del(id, TableName) > 0)
                    Response.Write("<script>alert(\"ɾɹ\");location.href=\"?t=" + Type + "\";</script>");
                else
                    Response.Write("<script>alert(\"ɾʧ\");location.href=\"?t=" + Type + "\";</script>");
            }

        }
        private void Deletes()
        {
            string str = "0" + Utility.CheckStr(Request["i"]) + "0";
            string[] o = str.Split(',');
            string temp = "0";
            for (int k = 0; k < o.Length; k++)
            {
                if (o[k] == "") continue;
                if (Utility.CheckInt(o[k]) > KeepNum) temp = temp + "," + o[k];
            }
            temp = temp + ",0";
            if (new D_Category().Del(temp, TableName) > 0)
                Response.Write("<script>alert(\"ɾɹ!\");location.href=\"?t=" + Type + "\";</script>");
            else
                Response.Write("<script>alert(\"ɾʧ,ϷֿΪϵͳؼ,ֻ޸,ɾ!\");location.href=\"?t=" + Type + "\";</script>");

        }
        private void GetItem()
        {
            int i = Utility.CheckInt(Request["i"]);
            if (i < 1) return;
            D_CategoryEntity o = new D_Category().GetD_CategoryEntity(i, TableName);
            if (o == null) return;
            ClassName.Text = o.ClassName;
            State.SelectedValue = o.State.ToString();
            FileName.Text = o.FileName;
            if (i < KeepNum)
            {
                FileName.ReadOnly = true;
                FileName.ToolTip = "ϵͳֶ,޸!";
                State.Enabled = false;
            }
        }
        protected void GetItems()
        {
            if (Request["page"] != null)
                CurPage = Utility.CheckInt(Request["page"].ToString());
            if (Request["PageSize"] != null)
                PageSize = Utility.CheckInt(Request["PageSize"].ToString());
            if (CurPage < 1) CurPage = 1;
            Pagination.Pagination pl = new Pagination.Pagination();
            pl.OrderBy = "Id Desc";
            pl.CurrPage = CurPage;
            pl.PageSize = PageSize;
            pl.Condition = " ";
            pl.TableName = TableName;
            D_Category category = new D_Category();
            IList i = category.GetD_CategoryList(pl);
            PageCount = category.PageCount();
            TotalCount = category.RecordCount();
            StringBuilder s = new StringBuilder();
            foreach (D_CategoryEntity o in i)
            {
                s.Append("\n\t<tr onmousemove=\"this.style.backgroundColor = '#E4E4E4'\" onmouseout=\"this.style.backgroundColor = ''\">");
                s.Append("\n\t\t<td  style=\"width:10px;text-align:center\" align=\"center\"><input type=\"checkbox\" name=\"checkme\" value=\"" + o.Id + "\" onclick=\"game.checkdels(this)\" /></td>");
                s.Append("\n\t\t<td  style=\"width:20px;text-align:center\" align=\"center\">" + o.Id + "</td>");
                s.Append("\n\t\t<td>" + o.ClassName + "</td>");
                s.Append("\n\t\t<td>" + o.FileName + "</td>");
                s.Append("\n\t\t<td>" + (o.State ? "<font color=\"red\">ǰ̨ʾ</font>" : "ǰ̨") + "</td>");
                s.Append("\n\t\t<td><img src=\"" + (Utility.CheckStr(o.ICO) == "" ? "/themes/red/nomiss.gif" : o.ICO) + "\" alt=\"ʾͼ\" title=\"ʾͼ\" /></td>");
                s.Append("\n\t\t<td style=\"width:50px;text-align:center\"><a href=\"?action=edit&t=" + Type + "&i=" + o.Id + "\" ><img src=\"themes/blue/edit.gif\" alt=\"޸Ĵ\" title=\"޸Ĵ\" /></a> <a onclick=\"javascript:if(!confirm('ȷɾ ?')) return; else this.setAttribute('href','?action=del&t=" + Type + "&i=" + o.Id + "');\" class=\"hand\"><img src=\"themes/blue/del.gif\" alt=\"ɾ\" title=\"ɾ\" /></a></td>");
                s.Append("</tr>");
            }
            if (Action == "")
                Response.Write(s.ToString());
        }
        protected void PageView()
        {
            Pagination.ShowPages p = new Pagination.ShowPages();
            p.CurPage = CurPage;
            p.PageCount = PageCount;
            p.PageSize = PageSize;
            p.TotalCount = TotalCount;
            Response.Write(p.ChinesePage());
        }

        protected void btnSubmit_Click(object sender, EventArgs e)
        {
            D_CategoryEntity o = new D_CategoryEntity();
            o.ClassName = Utility.CheckStr(ClassName.Text);
            o.State = Utility.CheckInt(State.SelectedValue) == 1 ? true : false;
            o.TableName = TableName;
            o.ICO = "";
            o.Id = Utility.CheckInt(Request["i"]);
            o.FileName = Utility.CheckStr(FileName.Text);
            if (Action == "edit")
            {
                if (new D_Category().Update(o) > 0)
                    Response.Write("<script>alert(\"޸ĳɹ\");location.href=\"Category.aspx?t=" + Type + "\";</script>");
                else
                    Response.Write("<script>alert(\"޸ʧ,ԶĿ¼Ѵ!\");location.href=\"Category.aspx?t=" + Type + "\";</script>");

            }
            else
            {
                if (new D_Category().Insert(o) > 0)
                    Response.Write("<script>alert(\"ӳɹ\");location.href=\"Category.aspx?t=" + Type + "\";</script>");
                else
                    Response.Write("<script>alert(\"ʧ,ԶĿ¼Ѵ!\");location.href=\"Category.aspx?t=" + Type + "\";</script>");
            }
   
        }
    }
}
