using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DevinFrame.WebGame.Entity;
using DevinFrame.WebGame.Operation;
using DevinFrame.Common;
using DevinFrame;
using DevinFrame.Encrypt;
using System.Text;

namespace DevinFrame.WebGame.Web.manage
{
    public partial class admin : System.Web.UI.Page
    {
        protected int CurPage = 1;
        protected int PageCount = 0;
        protected int PageSize = 6;
        protected int TotalCount = 0;
        protected string action;
        protected void Page_Load(object sender, EventArgs e)
        {
            action = Utility.CheckStr(Request["action"]);
            if (!Page.IsPostBack)
            {
                btnSubmit.Attributes.Add("onclick", "return PageValid();");
                switch (action)
                {
                    case "add":
                        AddItems.Visible = true;
                        ListItems.Visible = false;
                        break;
                    case "edit":
                        AddItems.Visible = true;
                        ListItems.Visible = false;
                        GetAdminOne();
                        break;
                    case "del":
                        Delete();
                        break;
                    case "dels":
                        Deletes();
                        break;
                    case "power":
                        UpdatePower();
                        break;
                    default:
                        AddItems.Visible = false;
                        ListItems.Visible = true;
                        break;
                }
            }
        }
        private void GetAdminOne()
        {
            int id = Utility.CheckInt(Request["i"]);
            if (id < 1)
                return;
            D_AdminEntity o = new D_Admin().GetD_AdminEntity(id);
            UserName.Text = o.UserName;
            UserName.ReadOnly = true;
            UserName.ToolTip = "û޸";
            btnSubmit.Text = "޸";
            if (o.UserPower) UserPower.SelectedValue = "1"; else UserPower.SelectedValue = "0";

        }
        private void UpdatePower()
        {
            FredCK.FCKeditorV2.FCKeditor o = new FredCK.FCKeditorV2.FCKeditor();
            int id = Utility.CheckInt(Request["i"]);
            if (id < 1)
                return;
            if (new D_Admin().UpdatePower(id) > 0)
                Response.Write("<script>alert(\"ĳɹ\");location.href=\"?\";</script>");
            else
                Response.Write("<script>alert(\"ʧ\");location.href=\"?\";</script>");
        }
        private void Delete()
        {
            int id = Utility.CheckInt(Request["i"]);
            if (new D_Admin().Del(id) > 0)
                Response.Write("<script>alert(\"ɾɹ\");location.href=\"?\";</script>");
            else
                Response.Write("<script>alert(\"ɾʧ\");location.href=\"?\";</script>");

        }
        private void Deletes()
        {
            string str = "0" + Utility.CheckStr(Request["i"]) + "0";
            if (new D_Admin().Del(str) > 0)
                Response.Write("<script>alert(\"ɾɹ\");location.href=\"?\";</script>");
            else
                Response.Write("<script>alert(\"ɾʧ\");location.href=\"?\";</script>");

        }
        protected void GetItemsList()
        {
            if (Request["page"] != null)
                CurPage = Utility.CheckInt(Request["page"].ToString());
            if (Request["PageSize"] != null)
                PageSize = Utility.CheckInt(Request["PageSize"].ToString());
            if (CurPage < 1) CurPage = 1;
            DevinFrame.Pagination.Pagination pl = new DevinFrame.Pagination.Pagination();
            pl.OrderBy = "Id Desc";
            pl.CurrPage = CurPage;
            pl.PageSize = PageSize;
            pl.Condition = " ";
            D_Admin _admin = new D_Admin();
            IList i = _admin.GetD_AdminList(pl);
            PageCount = _admin.PageCount();
            TotalCount = _admin.RecordCount();
            StringBuilder s = new StringBuilder();
            foreach (D_AdminEntity o in i)
            {
                s.Append("\n\t<tr onmousemove=\"this.style.backgroundColor = '#E4E4E4'\" onmouseout=\"this.style.backgroundColor = ''\">");
                s.Append("\n\t\t<td  style=\"width:10px;text-align:center\" align=\"center\"><input type=\"checkbox\" name=\"checkme\" value=\"" + o.Id + "\" onclick=\"game.checkdels(this)\" /></td>");
                s.Append("\n\t\t<td  style=\"width:20px;text-align:center\" align=\"center\">" + o.Id + "</td>");
                s.Append("\n\t\t<td>" + o.UserName + "</td>");
                s.Append("\n\t\t<td>" + (o.UserPower ? "<a href=\"?action=power&i=" + o.Id + "\" ><font color=\"red\"></font></a>" : "<a href=\"?action=power&i=" + o.Id + "\" >ͨ</a>") + "</td>");
                s.Append("\n\t\t<td>" + o.LastIp + "</td>");
                s.Append("\n\t\t<td style=\"width:50px;text-align:center\"><a href=\"?action=edit&i=" + o.Id + "\" ><img src=\"themes/blue/edit.gif\" alt=\"޸Ĵ\" title=\"޸Ĵ\" /></a> <a onclick=\"javascript:if(!confirm('ȷɾ ?')) return; else this.setAttribute('href','?action=del&i=" + o.Id + "');\" class=\"hand\"><img src=\"themes/blue/del.gif\" alt=\"ɾ\" title=\"ɾ\" /></a></td>");
                s.Append("</tr>");
            }
            Response.Write(s.ToString());
        }
        protected void btnSubmit_Click(object sender, EventArgs e)
        {
            D_AdminEntity o = new D_AdminEntity();
            o.UserName = Utility.CheckStr(UserName.Text);
            o.UserPwd = CryptCore.Md5(Utility.CheckStr(UserPwd.Text));
            string v = Utility.CheckStr(UserPower.SelectedValue);
            o.UserPower = (v == "0" || v == "") ? false : true;
            o.LastIp = Utility.getClientIP();
            o.Id = Utility.CheckInt(Request["i"]);
            if (action == "edit")
            {
                if (new D_Admin().Update(o) > 0)
                    Response.Write("<script>alert(\"޸ĳɹ!\");location.href=\"?\";</script>");
                else
                    Response.Write("<script>alert(\"޸ʧ!\");location.href=\"?\";</script>");
            }
            else
            {
                if (new D_Admin().Insert(o) > 0)
                    Response.Write("<script>alert(\"ӳɹ!\");location.href=\"?\";</script>");
                else
                    Response.Write("<script>alert(\"ʧ!\");location.href=\"?\";</script>");
            }
        }
        protected void PageView()
        {
            DevinFrame.Pagination.ShowPages p = new DevinFrame.Pagination.ShowPages();
            p.CurPage = CurPage;
            p.PageCount = PageCount;
            p.PageSize = PageSize;
            p.TotalCount = TotalCount;
            Response.Write(p.ChinesePage());
        }
    }
}
