using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using System.IO;
using DevinFrame.IO;
using DevinFrame.WebGame.Entity;
using DevinFrame.WebGame.Expand;
using DevinFrame.WebGame.Operation;
using DevinFrame.Common;

namespace DevinFrame.WebGame.Web.manage
{
    public partial class createhtml : System.Web.UI.Page
    {
        private static string HtmlSavePath = ConfigurationSettings.AppSettings["DevinFrame:HtmlSavePath"];
        private static string TemplatePath = ConfigurationSettings.AppSettings["DevinFrame:TemplatePath"];
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        protected void CreateMonster_Click(object sender, EventArgs e)
        {
            if (DevinFrame.IO.CreateHtml.CheckLegal(TemplatePath + "map.html"))
            {
                string path = HtmlSavePath + "monster/";
                IO.DirectoryAction.DeleteDirectory(Server.MapPath(path));
                IO.DirectoryAction.CreateDirectory(Server.MapPath(path));
                DevinFrame.Pagination.Condition condtion = new DevinFrame.Pagination.Condition();
                condtion.TableName = "D_MapCategory";
                condtion.Conditions = " And State=1 ";
                IList i = (IList)new D_Category().GetD_CategoryList(condtion);
                StringBuilder map = new StringBuilder();
                string pagetitle = "";
                foreach (D_CategoryEntity c in i)
                {
                    string filname = "";
                    filname = path + (Utility.CheckStr(c.FileName) == "" ? DevinFrame.Encrypt.CryptCore.Encrypt(c.Id.ToString()) : c.FileName) + ".html";
                    map.Append("<li><a href=\"" + filname + "\">" + c.ClassName + "</a></li>");
                }
                int num = 0;
                foreach (D_CategoryEntity o in i)
                {
                    if (num == 0)
                    {
                        pagetitle = o.ClassName + " >> " + Valid.Configure.WebSiteName;
                        DevinFrame.IO.CreateHtml cc = new DevinFrame.IO.CreateHtml();
                        cc.Encoding = "utf-8";
                        cc.FilePath = path;
                        cc.Template = TemplatePath + "map.html";
                        cc.FileName = "default.html";
                        cc.ReplaceText = new string[] { "$PageTitles$", "$Metas$", "$GetCategory$", "$Monsters$", "$Maps$" };
                        cc.ReplaceContent = new string[] { pagetitle, Valid.Metas(), map.ToString(), Monsters(0), Maps(0) };
                        cc.Create();

                    }
                    string filname = (Utility.CheckStr(o.FileName) == "" ? DevinFrame.Encrypt.CryptCore.Encrypt(o.Id.ToString()) : o.FileName) + ".html";
                    pagetitle = o.ClassName + " >> " + Valid.Configure.WebSiteName;
                    DevinFrame.IO.CreateHtml c = new DevinFrame.IO.CreateHtml();
                    c.Encoding = "utf-8";
                    c.FilePath = path;
                    c.Template = TemplatePath + "map.html";
                    c.FileName = filname;
                    c.ReplaceText = new string[] { "$PageTitles$", "$Metas$", "$GetCategory$", "$Monsters$", "$Maps$" };
                    c.ReplaceContent = new string[] { pagetitle, Valid.Metas(), map.ToString(), Monsters(o.Id), Maps(o.Id) };
                    c.Create();

                    num++;
                    LiterMonster.Text = "ɳɹ,ļ: " + num.ToString() + " ,Ŀ¼: <a href=\"" + path + "default.html\" target=\"_blank\" title=\"˲鿴\"> " + path + "</a>";
                }
            }
            else
            {
                LiterMonster.Text = "<font color='red'>û</font>ܺ,ɹֹ.ذȨ,֧. : <a href=\"http://www.m66.com.cn/legal/default.html\"><font color='red'>ԯ</font></a> ϵQQ:644976 Եõļ֧.";
            }
        }
        /// <summary>
        /// ȡù
        /// </summary>
        /// <param name="ClassId"></param>
        private string Monsters(int ClassId)
        {
            DevinFrame.Pagination.Condition conditon = new DevinFrame.Pagination.Condition();
            conditon.TableName = "D_Monster";
            if (ClassId > 0)
            {
                conditon.Conditions = " And ClassId=" + ClassId;
            }
            else
            {
                conditon.TopNum = " top 20";
            }
            StringBuilder s = new StringBuilder();
            IList i = (IList)new D_property().GetD_propertyList(conditon);
            foreach (D_propertyEntity o in i)
            {
                s.Append("<tr >");
                s.Append("<td class=\"c\"><img src=\"" + o.Picture + "\" /></td>");
                s.Append("<td class=\"z\" rowspan=\"2\" valign=\"top\" >"+o.Attributes+"</td>");
                s.Append("</tr>");
                s.Append("<tr >");
                s.Append("<td class=\"t\" valign=\"top\">" + o.Property + "</td>");
                s.Append("</tr>");

            }
            return s.ToString();

        }
        /// <summary>
        /// ȡõͼ
        /// </summary>
        /// <param name="ClassId"></param>
        private string Maps(int ClassId)
        {
            DevinFrame.Pagination.Condition conditon = new DevinFrame.Pagination.Condition();
            conditon.TableName = "D_Map";
            if (ClassId > 0)
            {
                conditon.Conditions = " And ClassId=" + ClassId;
            }
            else
            {
                conditon.TopNum = " top 20";
            }
            StringBuilder s = new StringBuilder();
            IList i = (IList)new D_property().GetD_propertyList(conditon);
            foreach (D_propertyEntity o in i)
            {
                s.Append("<div class=\"map\"><a href=\"" + o.Picture + "\" target=\"_blank\"><img src=\"" + o.Picture + "\" /></a></div>");

            }
            return s.ToString();
        }
        /// <summary>
        /// ɼħ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void CreateBlackart_Click(object sender, EventArgs e)
        {
            if (DevinFrame.IO.CreateHtml.CheckLegal(TemplatePath + "blackart.html"))
            {
                string path = HtmlSavePath + "blackart/";
                IO.DirectoryAction.DeleteDirectory(Server.MapPath(path));
                IO.DirectoryAction.CreateDirectory(Server.MapPath(path));
                DevinFrame.Pagination.Condition condtion = new DevinFrame.Pagination.Condition();
                condtion.TableName = "D_BlackartCategory";
                condtion.Conditions = " And State=1 ";
                condtion.OrderBy = "";
                IList i = (IList)new D_Category().GetD_CategoryList(condtion);
                StringBuilder map = new StringBuilder();
                string pagetitle = "";
                int num = 0;
                StringBuilder ss = new StringBuilder();
                foreach (D_CategoryEntity c in i)
                {
                    string filname = path + (Utility.CheckStr(c.FileName) == "" ? DevinFrame.Encrypt.CryptCore.Encrypt(c.Id.ToString()) : c.FileName) + ".html";
                    map.Append("<a href=\"" + filname + "\">" + c.ClassName + "</a></li>");
                    ss.Append(GetBlackart(c.Id, "<a href=\"" + filname + "\">" + c.ClassName + "</a></li>"));
                }
                foreach (D_CategoryEntity o in i)
                {
                    if (num == 0)
                    {


                        pagetitle = o.ClassName + " >> " + Valid.Configure.WebSiteName;
                        DevinFrame.IO.CreateHtml cc = new DevinFrame.IO.CreateHtml();
                        cc.Encoding = "utf-8";
                        cc.FilePath = path;
                        cc.Template = TemplatePath + "blackart.html";
                        cc.FileName = "default.html";
                        cc.ReplaceText = new string[] { "$PageTitles$", "$Metas$", "$Items$" };
                        cc.ReplaceContent = new string[] { pagetitle, Valid.Metas(), ss.ToString() };
                        cc.Create();
                    }
                    string filname = (Utility.CheckStr(o.FileName) == "" ? DevinFrame.Encrypt.CryptCore.Encrypt(o.Id.ToString()) : o.FileName) + ".html";
                    pagetitle = o.ClassName + " >> " + Valid.Configure.WebSiteName;
                    DevinFrame.IO.CreateHtml c = new DevinFrame.IO.CreateHtml();
                    c.Encoding = "utf-8";
                    c.FilePath = path;
                    c.Template = TemplatePath + "blackart.html";
                    c.FileName = filname;
                    c.ReplaceText = new string[] { "$PageTitles$", "$Metas$", "$Items$" };
                    c.ReplaceContent = new string[] { pagetitle, Valid.Metas(), GetBlackart(o.Id, map.ToString()) };
                    c.Create();
                    num++;
                    LiterBlackart.Text = "ɳɹ,ļ: " + num.ToString() + " ,Ŀ¼: <a href=\"" + path + "default.html\" target=\"_blank\" title=\"˲鿴\"> " + path + "</a>";
                }
            }
            else
            {
                LiterMonster.Text = "<font color='red'>û</font>ܺ,ɹֹ.ذȨ,֧. : <a href=\"http://www.m66.com.cn/legal/default.html\"><font color='red'>ԯ</font></a> ϵQQ:644976 Եõļ֧.";
            }

        }

        private string GetBlackart(int id, string nav)
        {
            DevinFrame.Pagination.Condition conditon = new DevinFrame.Pagination.Condition();
            conditon.TableName = "D_Blackart";
            if (id > 0)
                conditon.Conditions = " And ClassId=" + id;
            StringBuilder s = new StringBuilder();
            IList i = (IList)new D_property().GetD_propertyList(conditon);
            s.Append("<div class=\"blackart ico" + id + "\"><span id=\"blackNav\"><a href=\"/HtmlFiles/blackart/default.html\">м</a>" + nav + "</span></div>");
            s.Append("<div class=\"blackarts\">");
            s.Append("<table cellspacing=\"1\">");
            foreach (D_propertyEntity o in i)
            {
                s.Append("<tr >");
                s.Append("<td class=\"c\"><img src=\"" + o.Picture + "\" /></td>");
                s.Append("<td class=\"z\" rowspan=\"2\" valign=\"top\" >111111</td>");
                s.Append("</tr>");
                s.Append("<tr >");
                s.Append("<td class=\"t\" valign=\"top\">" + o.Property + "</td>");
                s.Append("</tr>");

            }
            s.Append("</table>");
            s.Append("</div>");
            s.Append("<div class=\"blackartb\"></div>");
            return s.ToString();
        }
        /// <summary>
        /// Ʒ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void CreateProperty_Click(object sender, EventArgs e)
        {
            if (DevinFrame.IO.CreateHtml.CheckLegal(TemplatePath + "property.html"))
            {
                string path = HtmlSavePath + "property/";
                IO.DirectoryAction.DeleteDirectory(Server.MapPath(path));
                IO.DirectoryAction.CreateDirectory(Server.MapPath(path));
                DevinFrame.Pagination.Condition condtion = new DevinFrame.Pagination.Condition();
                condtion.TableName = "D_PropertyCategory";
                condtion.Conditions = " And State=1 ";
                IList i = (IList)new D_Category().GetD_CategoryList(condtion);
                StringBuilder map = new StringBuilder();
                string pagetitle = "";
                foreach (D_CategoryEntity c in i)
                {
                    string filname = "";
                    filname = path + (Utility.CheckStr(c.FileName) == "" ? DevinFrame.Encrypt.CryptCore.Encrypt(c.Id.ToString()) : c.FileName) + ".html";
                    map.Append("<li><a href=\"" + filname + "\">" + c.ClassName + "</a></li>");
                }
                int num = 0;
                foreach (D_CategoryEntity o in i)
                {
                    if (num == 0)
                    {
                        pagetitle = o.ClassName + " >> " + Valid.Configure.WebSiteName;
                        DevinFrame.IO.CreateHtml cc = new DevinFrame.IO.CreateHtml();
                        cc.Encoding = "utf-8";
                        cc.FilePath = path;
                        cc.Template = TemplatePath + "property.html";
                        cc.FileName = "default.html";
                        cc.ReplaceText = new string[] { "$PageTitles$", "$Metas$", "$Category$", "$Itmes$", "$ItmeTitle$" };
                        cc.ReplaceContent = new string[] { pagetitle, Valid.Metas(), map.ToString(), GetProperty(0), "з [ ǰ50 ]" };
                        cc.Create();

                    }
                    string filname = (Utility.CheckStr(o.FileName) == "" ? DevinFrame.Encrypt.CryptCore.Encrypt(o.Id.ToString()) : o.FileName) + ".html";
                    pagetitle = o.ClassName + " >> " + Valid.Configure.WebSiteName;
                    DevinFrame.IO.CreateHtml c = new DevinFrame.IO.CreateHtml();
                    c.Encoding = "utf-8";
                    c.FilePath = path;
                    c.Template = TemplatePath + "property.html";
                    c.FileName = filname;
                    c.ReplaceText = new string[] { "$PageTitles$", "$Metas$", "$Category$", "$Itmes$", "$ItmeTitle$" };
                    c.ReplaceContent = new string[] { pagetitle, Valid.Metas(), map.ToString(), GetProperty(o.Id), o.ClassName };
                    c.Create();

                    num++;
                    LiterCreateProperty.Text = "ɳɹ,ļ: " + num.ToString() + " ,Ŀ¼:<a href=\"" + path + "default.html\" target=\"_blank\" title=\"˲鿴\"> " + path + "</a>";
                }
            }
            else
            {
                LiterMonster.Text = "<font color='red'>û</font>ܺ,ɹֹ.ذȨ,֧. : <a href=\"http://www.m66.com.cn/legal/default.html\"><font color='red'>ԯ</font></a> ϵQQ:644976 Եõļ֧.";
            }
        }
        private string GetProperty(int id)
        {
            DevinFrame.Pagination.Condition conditon = new DevinFrame.Pagination.Condition();
            conditon.TableName = "D_Property";
            if (id > 0)
            {
                conditon.Conditions = " And ClassId=" + id;
            }
            else
            {
                conditon.TopNum = " Top 50";
            }
            StringBuilder s = new StringBuilder();
            IList i = (IList)new D_property().GetD_propertyList(conditon);
            foreach (D_propertyEntity o in i)
            {
                s.Append("<tr>");
                s.Append("<td valign=\"middle\" align=\"left\" class=\"text-12\">" + o.Property + "</td>");
                s.Append("<td valign=\"middle\" align=\"center\" class=\"text-12\"><img  src=\"" + o.Picture + "\" /></td>");
                s.Append("<td valign=\"middle\" class=\"text-12\">" + o.Attributes + "</td>");
                s.Append("</tr>");
            }
            return s.ToString();
        }

        protected void CreateFormula_Click(object sender, EventArgs e)
        {
            if (DevinFrame.IO.CreateHtml.CheckLegal(TemplatePath + "formula.html"))
            {
                string path = HtmlSavePath + "formula/";
                IO.DirectoryAction.DeleteDirectory(Server.MapPath(path));
                IO.DirectoryAction.CreateDirectory(Server.MapPath(path));
                DevinFrame.Pagination.Condition condtion = new DevinFrame.Pagination.Condition();
                condtion.TableName = "D_FormulaCategory";
                condtion.Conditions = " And State=1 ";
                IList i = (IList)new D_Category().GetD_CategoryList(condtion);
                StringBuilder map = new StringBuilder();
                string pagetitle = "";
                foreach (D_CategoryEntity c in i)
                {
                    string filname = "";
                    filname = path + (Utility.CheckStr(c.FileName) == "" ? DevinFrame.Encrypt.CryptCore.Encrypt(c.Id.ToString()) : c.FileName) + ".html";
                    map.Append("<li><a href=\"" + filname + "\">" + c.ClassName + "</a></li>");
                }
                int num = 0;
                foreach (D_CategoryEntity o in i)
                {
                    if (num == 0)
                    {
                        pagetitle = o.ClassName + " >> " + Valid.Configure.WebSiteName;
                        DevinFrame.IO.CreateHtml cc = new DevinFrame.IO.CreateHtml();
                        cc.Encoding = "utf-8";
                        cc.FilePath = path;
                        cc.Template = TemplatePath + "formula.html";
                        cc.FileName = "default.html";
                        cc.ReplaceText = new string[] { "$PageTitles$", "$Metas$", "$Category$", "$Itmes$", "$ItmeTitle$" };
                        cc.ReplaceContent = new string[] { pagetitle, Valid.Metas(), map.ToString(), GetFormula(0), "з [ ǰ50 ]" };
                        cc.Create();

                    }
                    string filname = (Utility.CheckStr(o.FileName) == "" ? DevinFrame.Encrypt.CryptCore.Encrypt(o.Id.ToString()) : o.FileName) + ".html";
                    pagetitle = o.ClassName + " >> " + Valid.Configure.WebSiteName;
                    DevinFrame.IO.CreateHtml c = new DevinFrame.IO.CreateHtml();
                    c.Encoding = "utf-8";
                    c.FilePath = path;
                    c.Template = TemplatePath + "formula.html";
                    c.FileName = filname;
                    c.ReplaceText = new string[] { "$PageTitles$", "$Metas$", "$Category$", "$Itmes$", "$ItmeTitle$" };
                    c.ReplaceContent = new string[] { pagetitle, Valid.Metas(), map.ToString(), GetFormula(o.Id), o.ClassName };
                    c.Create();

                    num++;
                    LiterFormula.Text = "ɳɹ,ļ: " + num.ToString() + " ,Ŀ¼: <a href=\"" + path + "default.html\" target=\"_blank\" title=\"˲鿴\"> " + path + "</a>";
                }
            }
            else
            {
                LiterMonster.Text = "<font color='red'>û</font>ܺ,ɹֹ.ذȨ,֧. : <a href=\"http://www.m66.com.cn/legal/default.html\"><font color='red'>ԯ</font></a> ϵQQ:644976 Եõļ֧.";
            }

        }
        private string GetFormula(int id)
        {
            DevinFrame.Pagination.Condition conditon = new DevinFrame.Pagination.Condition();
            conditon.TableName = "D_Formula";
            if (id > 0)
            {
                conditon.Conditions = " And ClassId=" + id;
            }
            else
            {
                conditon.TopNum = " Top 50";
            }
            StringBuilder s = new StringBuilder();
            IList i = (IList)new D_Formula().GetD_FormulaList(conditon);
            foreach (D_FormulaEntity o in i)
            {
                string pic = "";
                string text = "";
                pic += Common.RegexLib.IsImage(o.PicUrlOne) ? "<img src=\"" + o.PicUrlOne + "\" />+" : "";
                pic += Common.RegexLib.IsImage(o.PicUrlTwo) ? "<img src=\"" + o.PicUrlTwo + "\" /> +" : "";
                pic += Common.RegexLib.IsImage(o.PicUrlThree) ? "<img src=\"" + o.PicUrlThree + "\" /> +" : "";
                pic += Common.RegexLib.IsImage(o.PicUrlFour) ? "<img src=\"" + o.PicUrlFour + "\" /> +" : "";
                pic += Common.RegexLib.IsImage(o.PicUrlFive) ? "<img src=\"" + o.PicUrlFive + "\" /> +" : "";
                pic += Common.RegexLib.IsImage(o.PicUrlSix) ? "<img src=\"" + o.PicUrlSix + "\" /> +" : "";
                pic += Common.RegexLib.IsImage(o.PicUrlSeven) ? "<img src=\"" + o.PicUrlSeven + "\" /> +" : "";
                pic += Common.RegexLib.IsImage(o.PicUrlEight) ? "<img src=\"" + o.PicUrlEight + "\" /> +" : "";
                pic += Common.RegexLib.IsImage(o.PicUrlNine) ? "<img src=\"" + o.PicUrlNine + "\" /> +" : "";
                pic += Common.RegexLib.IsImage(o.PicUrlTen) ? "<img src=\"" + o.PicUrlTen + "\" />" : "";

                text += Utility.CheckStr(o.GoodsOne) == "" ? "" : o.GoodsOne + " + ";
                text += Utility.CheckStr(o.GoodsTwo) == "" ? "" : o.GoodsTwo + " + ";
                text += Utility.CheckStr(o.GoodsThree) == "" ? "" : o.GoodsThree + " + ";
                text += Utility.CheckStr(o.GoodsFour) == "" ? "" : o.GoodsFour + " + ";
                text += Utility.CheckStr(o.GoodsFive) == "" ? "" : o.GoodsFive + " + ";
                text += Utility.CheckStr(o.GoodsSix) == "" ? "" : o.GoodsSix + " + ";
                text += Utility.CheckStr(o.GoodsSeven) == "" ? "" : o.GoodsSeven + " + ";
                text += Utility.CheckStr(o.GoodsEight) == "" ? "" : o.GoodsEight + " + ";
                text += Utility.CheckStr(o.GoodsNine) == "" ? "" : o.GoodsNine + " + ";
                text += Utility.CheckStr(o.GoodsTen) == "" ? "" : o.GoodsTen;
                s.Append("<tr>");
                s.Append("<td valign=\"middle\" class=\"text\"><strong>" + o.Formulary + "</strong></td>");
                s.Append("</tr>");
                s.Append("<tr>");
                s.Append("<td valign=\"middle\"><img src=\"" + o.FormularyPic + "\" /> = " + pic + "</td>");
                s.Append("</tr>");
                s.Append("<tr>");
                s.Append("<td valign=\"middle\" >" + text + "</td>");
                s.Append("</tr>");
            }
            return s.ToString();
        }

        protected void CreateInfo_Click(object sender, EventArgs e)
        {
            if (DevinFrame.IO.CreateHtml.CheckLegal(TemplatePath + "info.html"))
            {
                string path = HtmlSavePath + "info/";
                IO.DirectoryAction.DeleteDirectory(Server.MapPath(path));
                IO.DirectoryAction.CreateDirectory(Server.MapPath(path));
                IO.DirectoryAction.DeleteDirectory(Server.MapPath(path + "details"));
                IO.DirectoryAction.CreateDirectory(Server.MapPath(path + "details"));

                DevinFrame.Pagination.Condition condtion = new DevinFrame.Pagination.Condition();
                condtion.Conditions = " And State=1 ";
                condtion.TableName = "D_NewsGategory";
                IList i = (IList)new D_Category().GetD_CategoryList(condtion);
                StringBuilder s = new StringBuilder();
                foreach (D_CategoryEntity o in i)
                {
                    string t = path + (Utility.CheckStr(o.FileName) == "" ? o.Id.ToString() : o.FileName);
                    s.Append("<p class=\"b\"><a href=\"" + t + "/1GfwL9TQCqJ05pLFqBqFPN===.html\">" + o.ClassName + "</a></p>");
                }
                CreateNewsPages(0, path, "ȫѶ", s.ToString());
                foreach (D_CategoryEntity o in i)
                {
                    string t = path + (Utility.CheckStr(o.FileName) == "" ? o.Id.ToString() : o.FileName) + "/";
                    IO.DirectoryAction.DeleteDirectory(Server.MapPath(t));
                    IO.DirectoryAction.CreateDirectory(Server.MapPath(t));
                    CreateNewsPages(o.Id, t, o.ClassName, s.ToString());
                }
                LiterInfo.Text = "ɳɹ,Ŀ¼: <a href=\"" + path + "1GfwL9TQCqJ05pLFqBqFPN===.html\" target=\"_blank\" title=\"˲鿴\"> " + path + "</a>";
            }
            else
            {
                LiterMonster.Text = "<font color='red'>û</font>ܺ,ɹֹ.ذȨ,֧. : <a href=\"http://www.m66.com.cn/legal/default.html\"><font color='red'>ԯ</font></a> ϵQQ:644976 Եõļ֧.";
            }
        }
        private void CreateNewsPages(int ClassId, string filepath, string ClassName, string ClassNav)
        {
            int CountNum = 1;
            string pagetitle = "";
            for (int k = 0; k <= CountNum; k++)
            {
                int PageSize = 10;
                DevinFrame.Pagination.Pagination pagination = new DevinFrame.Pagination.Pagination();
                pagination.OrderBy = "Id Desc";
                pagination.CurrPage = k;
                pagination.PageSize = PageSize;
                if (ClassId == 0)
                {
                    pagination.Condition = " And State = 1";
                }
                else
                {
                    pagination.Condition = " And State = 1 And ClassId = " + ClassId;
                }
                D_News dnew = new D_News();
                IList i = dnew.GetD_NewsList(pagination);
                int PageCount = dnew.PageCount();
                int TotalCount = dnew.RecordCount();
                CountNum = PageCount;
                StringBuilder s = new StringBuilder();
                foreach (D_NewsEntity o in i)
                {
                    pagetitle = o.NewsTitle + " >> " + Valid.Configure.WebSiteName;
                    string _file = (Utility.CheckStr(o.FileName) == "" ? DevinFrame.Encrypt.CryptCore.Encrypt(o.Id.ToString()) : o.FileName);
                    s.Append("<li><span><a href=\"" + HtmlSavePath + "info/details/" + _file + ".html\" target=\"_blank\">" + o.NewsTitle + "</a></span><label>" + o.CreateTime.ToShortDateString() + "</label></li>");
                    DevinFrame.IO.CreateHtml c = new DevinFrame.IO.CreateHtml();
                    c.Encoding = "utf-8";
                    c.FilePath = HtmlSavePath + "/info/details";
                    c.Template = TemplatePath + "info.html";
                    c.FileName = _file + ".html";
                    c.ReplaceText = new string[] { "$PageTitles$", "$Metas$", "$Title$", "$Content$", "$ClassName$", "$ClassNav$" };
                    c.ReplaceContent = new string[] { pagetitle, Valid.Metas(), o.NewsTitle, o.Content, ClassName, ClassNav };
                    c.Create();

                }
                pagetitle = ClassName + " >> " + Valid.Configure.WebSiteName;
                DevinFrame.IO.CreateHtml cc = new DevinFrame.IO.CreateHtml();
                cc.Encoding = "utf-8";
                cc.FilePath = filepath;
                cc.Template = TemplatePath + "news.html";
                if (CountNum == 0)
                {
                    cc.FileName = DevinFrame.Encrypt.CryptCore.Encrypt("1") + ".html";
                    cc.ReplaceText = new string[] { "$PageTitles$", "$Metas$", "$Items$", "$PageList$", "$ClassName$", "$ClassNav$" };
                    cc.ReplaceContent = new string[] { pagetitle, Valid.Metas(), "", DevinFrame.IO.CreateHtml.Pages(k, PageCount, PageSize, TotalCount, filepath), ClassName, ClassNav };
                }
                else
                {

                    cc.FileName = DevinFrame.Encrypt.CryptCore.Encrypt(k.ToString()) + ".html";
                    cc.ReplaceText = new string[] { "$PageTitles$", "$Metas$", "$Items$", "$PageList$", "$ClassName$", "$ClassNav$" };
                    cc.ReplaceContent = new string[] { pagetitle, Valid.Metas(), s.ToString(), DevinFrame.IO.CreateHtml.Pages(k, PageCount, PageSize, TotalCount, filepath), ClassName, ClassNav };
                }
                
                cc.Create();
            }
        }

        protected void CreatePicture_Click(object sender, EventArgs e)
        {
            if (DevinFrame.IO.CreateHtml.CheckLegal(TemplatePath + "piclist.html"))
            {
                string path = HtmlSavePath + "picture/";
                IO.DirectoryAction.DeleteDirectory(Server.MapPath(path));
                IO.DirectoryAction.CreateDirectory(Server.MapPath(path));

                DevinFrame.Pagination.Condition condtion = new DevinFrame.Pagination.Condition();
                condtion.Conditions = " And State=1 ";
                condtion.TableName = "D_PicturesCategory";
                IList i = (IList)new D_Category().GetD_CategoryList(condtion);
                StringBuilder s = new StringBuilder();
                foreach (D_CategoryEntity o in i)
                {
                    string t = path + (Utility.CheckStr(o.FileName) == "" ? o.Id.ToString() : o.FileName);
                    s.Append("<p class=\"b\"><a href=\"" + t + "/1GfwL9TQCqJ05pLFqBqFPN===.html\">" + o.ClassName + "</a></p>");
                }
                CreatePicPages(0, path, "ȫͼƬ", s.ToString());
                foreach (D_CategoryEntity o in i)
                {
                    string t = path + (Utility.CheckStr(o.FileName) == "" ? o.Id.ToString() : o.FileName) + "/";
                    IO.DirectoryAction.DeleteDirectory(Server.MapPath(t));
                    IO.DirectoryAction.CreateDirectory(Server.MapPath(t));
                    CreatePicPages(o.Id, t, o.ClassName, s.ToString());
                }
                LiterPicture.Text = "ɳɹ,Ŀ¼: <a href=\"" + path + "1GfwL9TQCqJ05pLFqBqFPN===.html\" target=\"_blank\" title=\"˲鿴\"> " + path + "</a>";
            }
            else
            {
                LiterMonster.Text = "<font color='red'>û</font>ܺ,ɹֹ.ذȨ,֧. : <a href=\"http://www.m66.com.cn/legal/default.html\"><font color='red'>ԯ</font></a> ϵQQ:644976 Եõļ֧.";
            }

        }
        private void CreatePicPages(int ClassId, string filepath, string ClassName, string ClassNav)
        {
            int CountNum = 1;
            string pagetitle = "";
            for (int k = 0; k <= CountNum; k++)
            {
                int PageSize = 9;
                DevinFrame.Pagination.Pagination pagination = new DevinFrame.Pagination.Pagination();
                pagination.OrderBy = "Id Desc";
                pagination.CurrPage = k;
                pagination.PageSize = PageSize;
                if (ClassId == 0)
                {
                    pagination.Condition = "";
                }
                else
                {
                    pagination.Condition = " And ClassId = " + ClassId;
                }
                D_Pictures dnew = new D_Pictures();
                IList i = dnew.GetD_PicturesList(pagination);
                int PageCount = dnew.PageCount();
                int TotalCount = dnew.RecordCount();
                CountNum = PageCount;
                StringBuilder s = new StringBuilder();
                foreach (D_PicturesEntity o in i)
                {
                    pagetitle = o.ClassName + " >> " + Valid.Configure.WebSiteName;
                    string pic = o.PicUrl.Split('|')[0];
                    s.Append("<div class=\"b\">");
                    s.Append("<a href=\"" + pic + "\" target=\"_blank\" title=\"" + o.Title + "\"><img src=\"" + pic + "\" /></a>");
                    s.Append("<p><a href=\"" + pic + "\" target=\"_blank\" title=\"" + o.Title + "\">" + DevinFrame.Common.Utility.Substring(o.Title, 10) + " </a></p>");
                    s.Append("</div>");
                }
                DevinFrame.IO.CreateHtml cc = new DevinFrame.IO.CreateHtml();
                cc.Encoding = "utf-8";
                cc.FilePath = filepath;
                cc.Template = TemplatePath + "piclist.html";
                if (CountNum == 0)
                {
                    cc.FileName = DevinFrame.Encrypt.CryptCore.Encrypt("1") + ".html";
                    cc.ReplaceText = new string[] { "$PageTitles$", "$Metas$", "$Items$", "$PageList$", "$ClassName$", "$ClassNav$" };
                    cc.ReplaceContent = new string[] { pagetitle, Valid.Metas(), "", DevinFrame.IO.CreateHtml.Pages(k, PageCount, PageSize, TotalCount, filepath), ClassName, ClassNav };
                }
                else
                {

                    cc.FileName = DevinFrame.Encrypt.CryptCore.Encrypt(k.ToString()) + ".html";
                    cc.ReplaceText = new string[] { "$PageTitles$", "$Metas$", "$Items$", "$PageList$", "$ClassName$", "$ClassNav$" };
                    cc.ReplaceContent = new string[] { pagetitle, Valid.Metas(), s.ToString(), DevinFrame.IO.CreateHtml.Pages(k, PageCount, PageSize, TotalCount, filepath), ClassName, ClassNav };
                }

                cc.Create();
            }
        }

        protected void CreateDefault_Click(object sender, EventArgs e)
        {
            if (DevinFrame.IO.CreateHtml.CheckLegal(TemplatePath + "formula.html"))
            {
                // 
                DevinFrame.Pagination.Condition downscondition = new DevinFrame.Pagination.Condition();
                downscondition.TopNum = " Top 5";
                IList downs = (IList)new D_Downs().GetD_DownsList(downscondition);
                StringBuilder sdowns = new StringBuilder();
                foreach (D_DownsEntity o in downs)
                {
                    sdowns.Append("<div class=\"mb\"><a href=\"" + o.FileUrl + "\" target=\"_blank\">" + DevinFrame.Common.Utility.Truncated(o.Titles, 8) + "</a></div>");
                }

                //͵
                DevinFrame.Pagination.Condition condition = new DevinFrame.Pagination.Condition();
                condition.TopNum = " Top 5";
                IList propertys = (IList)new D_Ads().GetD_AdsList(condition);
                StringBuilder sproperty = new StringBuilder();
                foreach (D_AdsEntity o in propertys)
                {
                    string pic = o.PicUrl.Split('|')[0];
                    string p = (pic.ToLower().IndexOf("jpg") > -1) ? pic : "";
                    if (p != "")
                        sproperty.Append(p + "|");

                }
                string t = sproperty.ToString();
                if (t.Length > 2)
                    t = t.Substring(0, t.Length - 1);
                //
                DevinFrame.Pagination.Condition pictureconditon = new DevinFrame.Pagination.Condition();
                pictureconditon.TopNum = " Top 10";
                IList picturesilist = (IList)new D_Pictures().GetD_PicturesList(pictureconditon);
                StringBuilder pictures = new StringBuilder();
                foreach (D_PicturesEntity o in picturesilist)
                {
                    string pic = o.PicUrl.Split('|')[0];
                    pictures.Append("<img src=\"" + pic + "\" />");
                }
                //QQ
                DevinFrame.Pagination.Condition kfcondition = new DevinFrame.Pagination.Condition();
                kfcondition.TopNum = " Top 5";
                IList kflist = (IList)new D_Service().GetD_ServiceList(kfcondition);
                StringBuilder kfs = new StringBuilder();
                foreach (D_ServiceEntity o in kflist)
                {
                    kfs.Append("<li>" + o.Titles + "" + o.QQ + "</li>"); ;
                }
                DevinFrame.IO.CreateHtml c = new DevinFrame.IO.CreateHtml();
                c.Encoding = "utf-8";
                c.FilePath = "/";
                c.Template = TemplatePath + "default.html";
                c.FileName = "default.html";
                c.ReplaceText = new string[] {
                "$PageTitles$", 
                "$Metas$", 
                "$Downs$", 
                "$Property$", 
                "$Service$", 
                "$HotNews$", 
                "$FoucNews$", 
                "$NoteNews$" , 
                "$HonNews$", 
                "$Marquee$",
                "$PlayerPic$",
                "$MapPic$",
                "$FriendLinks$"
            };
                c.ReplaceContent = new string[] { 
                Valid.Configure.WebSiteName, 
                Valid.Metas(), 
                sdowns.ToString(), 
                t, 
                kfs.ToString(), 
                DefaultNews(0), 
                DefaultNews(1), 
                DefaultNews(2), 
                DefaultNews(3), 
                pictures.ToString() ,
                DefaultPic(2),
                DefaultPic(1),
                DefaultLinks()
            };
                c.Create();
                LiterCreateDefault.Text = "ɳɹ,Ŀ¼: <a href=\"/default.html\" target=\"_blank\" title=\"˲鿴\"> ҳ</a>";
            }
            else
            {
                LiterCreateDefault.Text = "<font color='red'>û</font>ܺ,ɹֹ.ذȨ,֧. : <a href=\"http://www.m66.com.cn/legal/default.html\"><font color='red'>ԯ</font></a> ϵQQ:644976 Եõļ֧.";

            }


        }
        private string DefaultNews(int id)
        {
            string path = ConfigurationSettings.AppSettings["DevinFrame:HtmlSavePath"] + "/info/details/";
            DevinFrame.Pagination.Condition pictureconditon = new DevinFrame.Pagination.Condition();
            pictureconditon.TopNum = " Top 14";
            if (id == 0)
                pictureconditon.Conditions = " ";
            else
                pictureconditon.Conditions = " And ClassId=" + id;
            IList picturesilist = (IList)new D_News().GetD_NewsList(pictureconditon);
            StringBuilder pictures = new StringBuilder();
            foreach (D_NewsEntity o in picturesilist)
            {
                string fileName = (Utility.CheckStr(o.FileName) == "" ? DevinFrame.Encrypt.CryptCore.Encrypt(o.Id.ToString()) : o.FileName) + ".html";
                fileName = path + fileName;

                pictures.Append("<li><a href=\"" + fileName + "\" target=\"_blank\">" + o.NewsTitle + "</a></li>");
            }
            return pictures.ToString();
        }
        private string DefaultPic(int id)
        {
            DevinFrame.Pagination.Condition pictureconditon = new DevinFrame.Pagination.Condition();
            pictureconditon.TopNum = " Top 4";
            pictureconditon.Conditions = " And ClassId=" + id;
            IList picturesilist = (IList)new D_Pictures().GetD_PicturesList(pictureconditon);
            StringBuilder pictures = new StringBuilder();
            foreach (D_PicturesEntity o in picturesilist)
            {
                string pic = o.PicUrl.Split('|')[0];
                pictures.Append("<img src=\"" + pic + "\" class=\"lz\" />");
            }
            return pictures.ToString();
        }
        private string DefaultLinks()
        {
            DevinFrame.Pagination.Condition pictureconditon = new DevinFrame.Pagination.Condition();
            pictureconditon.TopNum = " Top 4";
            pictureconditon.Conditions = "";
            IList picturesilist = (IList)new D_Links().GetD_LinksList(pictureconditon);
            StringBuilder pictures = new StringBuilder();
            foreach (D_LinksEntity o in picturesilist)
            {
                string pic = o.LinkICO.Split('|')[0];
                pictures.Append("<a href=\"" + o.LinkUrl + "\" title=\"" + o.LinkName + "\" target=\"_blank\"><img src=\"" + pic + "\" class=\"lz\" /></a>");
            }
            return pictures.ToString();
        }
    }
}
