using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DevinFrame.WebGame.Entity;
using DevinFrame.WebGame.Operation;
using DevinFrame.Common;
using DevinFrame;
using DevinFrame.Encrypt;
using System.Text;


namespace DevinFrame.WebGame.Web.manage
{
    public partial class formula : System.Web.UI.Page
    {
        protected int CurPage = 1;
        protected int PageCount = 0;
        protected int PageSize = 6;
        protected int TotalCount = 0;
        protected string action;
        protected void Page_Load(object sender, EventArgs e)
        {
            action = Utility.CheckStr(Request["action"]);
            if (!Page.IsPostBack)
            {
                btnSubmit.Attributes.Add("onclick", "return PageValid();");
                switch (action)
                {
                    case "add":
                        AddItems.Visible = true;
                        ListItems.Visible = false;
                        BindClass();
                        break;
                    case "edit":
                        AddItems.Visible = true;
                        ListItems.Visible = false;
                        GetAdminOne();
                        break;
                    case "del":
                        Delete();
                        break;
                    case "dels":
                        Deletes();
                        break;
                    default:
                        AddItems.Visible = false;
                        ListItems.Visible = true;
                        break;
                }
            }
        }
        private void BindClass()
        {
            DevinFrame.Pagination.Condition conditon = new DevinFrame.Pagination.Condition();
            conditon.TableName = "D_FormulaCategory";
            IList i = (IList)new D_Category().GetD_CategoryList(conditon);
            if (i.Count < 1)
                Response.Write("<script>alert(\"ŷ.\");location.href=\"Category.aspx?t=news&action=add\";</script>");
            foreach (D_CategoryEntity o in i)
            {
                ClassName.Items.Add(new ListItem(o.ClassName, o.Id.ToString()));

            }

        }
        private void GetAdminOne()
        {
            int id = Utility.CheckInt(Request["i"]);
            if (id < 1)
                return;
            D_FormulaEntity o = new D_Formula().GetD_FormulaEntity(id);
            BindClass();
            ClassName.SelectedValue = o.ClassId.ToString();
            Formulary.Text = o.Formulary;
            FormularyPic.Value = o.FormularyPic;
            GoodsOne.Text = o.GoodsOne;
            GoodsTwo.Text = o.GoodsTwo;
            GoodsThree.Text = o.GoodsThree;
            GoodsFour.Text = o.GoodsFour;
            GoodsFive.Text = o.GoodsFive;
            GoodsSix.Text = o.GoodsSix;
            GoodsSeven.Text = o.GoodsSeven;
            GoodsEight.Text = o.GoodsEight;
            GoodsNine.Text = o.GoodsNine;
            GoodsTen.Text = o.GoodsTen;
            PicUrlOne.Value = o.PicUrlOne;
            PicUrlTwo.Value = o.PicUrlTwo;
            PicUrlThree.Value = o.PicUrlThree;
            PicUrlFour.Value = o.PicUrlFour;
            PicUrlFive.Value = o.PicUrlFive;
            PicUrlSix.Value = o.PicUrlSix;
            PicUrlEight.Value = o.PicUrlEight;
            PicUrlSeven.Value = o.PicUrlSeven;
            PicUrlNine.Value = o.PicUrlNine;
            PicUrlTen.Value = o.PicUrlTen;

        }
        private void Delete()
        {
            int id = Utility.CheckInt(Request["i"]);
            if (new D_Formula().Del(id) > 0)
                Response.Write("<script>alert(\"ɾɹ\");location.href=\"?\";</script>");
            else
                Response.Write("<script>alert(\"ɾʧ\");location.href=\"?\";</script>");

        }
        private void Deletes()
        {
            string str = "0" + Utility.CheckStr(Request["i"]) + "0";
            if (new D_Formula().Del(str) > 0)
                Response.Write("<script>alert(\"ɾɹ\");location.href=\"?\";</script>");
            else
                Response.Write("<script>alert(\"ɾʧ\");location.href=\"?\";</script>");

        }
        protected void GetItemsList()
        {
            if (Request["page"] != null)
                CurPage = Utility.CheckInt(Request["page"].ToString());
            if (Request["PageSize"] != null)
                PageSize = Utility.CheckInt(Request["PageSize"].ToString());
            if (CurPage < 1) CurPage = 1;
            DevinFrame.Pagination.Pagination pl = new DevinFrame.Pagination.Pagination();
            pl.OrderBy = "Id Desc";
            pl.CurrPage = CurPage;
            pl.PageSize = PageSize;
            pl.Condition = " ";
            D_Formula _admin = new D_Formula();
            IList i = _admin.GetD_FormulaList(pl);
            PageCount = _admin.PageCount();
            TotalCount = _admin.RecordCount();
            StringBuilder s = new StringBuilder();
            foreach (D_FormulaEntity o in i)
            {
                s.Append("\n\t<tr onmousemove=\"this.style.backgroundColor = '#E4E4E4'\" onmouseout=\"this.style.backgroundColor = ''\">");
                s.Append("\n\t\t<td  style=\"width:10px;text-align:center\" align=\"center\"><input type=\"checkbox\" name=\"checkme\" value=\"" + o.Id + "\" onclick=\"game.checkdels(this)\" /></td>");
                s.Append("\n\t\t<td  style=\"width:20px;text-align:center\" align=\"center\">" + o.Id + "</td>");
                s.Append("\n\t\t<td>" + o.Formulary + "</td>");
                s.Append("\n\t\t<td><img src=\"" + (Utility.CheckStr(o.FormularyPic) == "" ? "/themes/red/nomiss.gif" : o.FormularyPic) + "\" alt=\"ʾͼ\" title=\"ʾͼ\" style=\"width:32px;height:30px;\" /></td>");
                s.Append("\n\t\t<td style=\"width:50px;text-align:center\"><a href=\"?action=edit&i=" + o.Id + "\" ><img src=\"themes/blue/edit.gif\" alt=\"޸Ĵ\" title=\"޸Ĵ\" /></a> <a onclick=\"javascript:if(!confirm('ȷɾ ?')) return; else this.setAttribute('href','?action=del&i=" + o.Id + "');\" class=\"hand\"><img src=\"themes/blue/del.gif\" alt=\"ɾ\" title=\"ɾ\" /></a></td>");
                s.Append("</tr>");
            }
            Response.Write(s.ToString());
        }
        protected void btnSubmit_Click(object sender, EventArgs e)
        {
            D_FormulaEntity o = new D_FormulaEntity();
            o.Id = Utility.CheckInt(Request["i"]);
            o.ClassId = Utility.CheckInt(ClassName.SelectedValue);
            o.ClassName = Utility.CheckStr(ClassName.SelectedItem.Text);
            o.Formulary = Utility.CheckStr(Formulary.Text);
            o.FormularyPic = FormularyPic.Value;
            o.GoodsEight = Utility.CheckStr(GoodsEight.Text);
            o.GoodsFive = Utility.CheckStr(GoodsFive.Text);
            o.GoodsFour = Utility.CheckStr(GoodsFour.Text);
            o.GoodsNine = Utility.CheckStr(GoodsNine.Text);
            o.GoodsOne = Utility.CheckStr(GoodsOne.Text);
            o.GoodsSeven = Utility.CheckStr(GoodsSeven.Text);
            o.GoodsSix = Utility.CheckStr(GoodsSix.Text);
            o.GoodsTen = Utility.CheckStr(GoodsTen.Text);
            o.GoodsThree = Utility.CheckStr(GoodsThree.Text);
            o.GoodsTwo = Utility.CheckStr(GoodsTwo.Text);
            o.PicUrlEight = PicUrlEight.Value;
            o.PicUrlFive = PicUrlFive.Value;
            o.PicUrlFour = PicUrlFour.Value;
            o.PicUrlNine = PicUrlNine.Value;
            o.PicUrlOne = PicUrlOne.Value;
            o.PicUrlSeven = PicUrlSeven.Value;
            o.PicUrlSix = PicUrlSix.Value;
            o.PicUrlTen = PicUrlTen.Value;
            o.PicUrlThree = PicUrlThree.Value;
            o.PicUrlTwo = PicUrlTwo.Value;
            
            if (action == "edit")
            {
                if (new D_Formula().Update(o) > 0)
                    Response.Write("<script>alert(\"޸ĳɹ!\");location.href=\"?\";</script>");
                else
                    Response.Write("<script>alert(\"޸ʧ!\");location.href=\"?\";</script>");
            }
            else
            {
                if (new D_Formula().Insert(o) > 0)
                    Response.Write("<script>alert(\"ӳɹ!\");location.href=\"?\";</script>");
                else
                    Response.Write("<script>alert(\"ʧ!\");location.href=\"?\";</script>");
            }
        }
        protected void PageView()
        {
            DevinFrame.Pagination.ShowPages p = new DevinFrame.Pagination.ShowPages();
            p.CurPage = CurPage;
            p.PageCount = PageCount;
            p.PageSize = PageSize;
            p.TotalCount = TotalCount;
            Response.Write(p.ChinesePage());
        }
    }
}
