using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DevinFrame.WebGame.Entity;
using DevinFrame.WebGame.Operation;
using DevinFrame.Common;
using DevinFrame;
using DevinFrame.Encrypt;
using System.Text;

namespace DevinFrame.WebGame.Web.manage
{
    public partial class picture : System.Web.UI.Page
    {
        protected int CurPage = 1;
        protected int PageCount = 0;
        protected int PageSize = 6;
        protected int TotalCount = 0;
        protected string action;
        protected void Page_Load(object sender, EventArgs e)
        {
            action = Utility.CheckStr(Request["action"]);
            if (!Page.IsPostBack)
            {
                btnSubmit.Attributes.Add("onclick", "return PageValid();");
                switch (action)
                {
                    case "add":
                        AddItems.Visible = true;
                        ListItems.Visible = false;
                        BindClass();
                        break;
                    case "edit":
                        AddItems.Visible = true;
                        ListItems.Visible = false;
                        GetAdminOne();
                        break;
                    case "del":
                        Delete();
                        break;
                    case "dels":
                        Deletes();
                        break;
                    default:
                        AddItems.Visible = false;
                        ListItems.Visible = true;
                        break;
                }
            }
        }
        private void BindClass()
        {
            DevinFrame.Pagination.Condition conditon = new DevinFrame.Pagination.Condition();
            conditon.TableName = "D_PicturesCategory";
            IList i = (IList)new D_Category().GetD_CategoryList(conditon);
            if (i.Count < 1)
                Response.Write("<script>alert(\"ӷ.\");location.href=\"Category.aspx?t=pic&action=add\";</script>");
            foreach (D_CategoryEntity o in i)
            {
                ClassName.Items.Add(new ListItem(o.ClassName, o.Id.ToString()));

            }

        }
        private void GetAdminOne()
        {
            int id = Utility.CheckInt(Request["i"]);
            if (id < 1)
                return;
            BindClass();
            D_PicturesEntity o = new D_Pictures().GetD_PicturesEntity(id);
            Title.Text = o.Title;
            DevinUploader.Value = o.PicUrl;
            ClassName.SelectedValue = o.ClassId.ToString();
        }
        private void Delete()
        {
            int id = Utility.CheckInt(Request["i"]);
            if (new D_Pictures().Del(id) > 0)
                Response.Write("<script>alert(\"ɾɹ\");location.href=\"?\";</script>");
            else
                Response.Write("<script>alert(\"ɾʧ\");location.href=\"?\";</script>");

        }
        private void Deletes()
        {
            string str = "0" + Utility.CheckStr(Request["i"]) + "0";
            if (new D_Pictures().Del(str) > 0)
                Response.Write("<script>alert(\"ɾɹ\");location.href=\"?\";</script>");
            else
                Response.Write("<script>alert(\"ɾʧ\");location.href=\"?\";</script>");

        }
        protected void GetItemsList()
        {
            if (Request["page"] != null)
                CurPage = Utility.CheckInt(Request["page"].ToString());
            if (Request["PageSize"] != null)
                PageSize = Utility.CheckInt(Request["PageSize"].ToString());
            if (CurPage < 1) CurPage = 1;
            DevinFrame.Pagination.Pagination pl = new DevinFrame.Pagination.Pagination();
            pl.OrderBy = "Id Desc";
            pl.CurrPage = CurPage;
            pl.PageSize = PageSize;
            pl.Condition = " ";
            D_Pictures _admin = new D_Pictures();
            IList i = _admin.GetD_PicturesList(pl);
            PageCount = _admin.PageCount();
            TotalCount = _admin.RecordCount();
            StringBuilder s = new StringBuilder();
            foreach (D_PicturesEntity o in i)
            {
                s.Append("\n\t<tr onmousemove=\"this.style.backgroundColor = '#E4E4E4'\" onmouseout=\"this.style.backgroundColor = ''\">");
                s.Append("\n\t\t<td  style=\"width:10px;text-align:center\" align=\"center\"><input type=\"checkbox\" name=\"checkme\" value=\"" + o.Id + "\" onclick=\"game.checkdels(this)\" /></td>");
                s.Append("\n\t\t<td  style=\"width:20px;text-align:center\" align=\"center\">" + o.Id + "</td>");
                s.Append("\n\t\t<td>" + o.Title + "</td>");
                s.Append("\n\t\t<td>" + o.ClassName + "</td>");
                s.Append("\n\t\t<td><img src=\"" + (Utility.CheckStr(o.PicUrl) == "" ? "/themes/red/nomiss.gif" : o.PicUrl) + "\" alt=\"ʾͼ\" title=\"ʾͼ\" style=\"height:32px;\" /></td>");
                s.Append("\n\t\t<td style=\"width:50px;text-align:center\"><a href=\"?action=edit&i=" + o.Id + "\" ><img src=\"themes/blue/edit.gif\" alt=\"޸Ĵ\" title=\"޸Ĵ\" /></a> <a onclick=\"javascript:if(!confirm('ȷɾ ?')) return; else this.setAttribute('href','?action=del&i=" + o.Id + "');\" class=\"hand\"><img src=\"themes/blue/del.gif\" alt=\"ɾ\" title=\"ɾ\" /></a></td>");
                s.Append("</tr>");
            }
            Response.Write(s.ToString());
        }
        protected void btnSubmit_Click(object sender, EventArgs e)
        {
            D_PicturesEntity o = new D_PicturesEntity();
            o.Title = Utility.CheckStr(Title.Text);
            o.PicUrl = Utility.CheckStr(DevinUploader.Value);
            o.Id = Utility.CheckInt(Request["i"]);
            o.ClassId = Utility.CheckInt(ClassName.SelectedValue);
            o.ClassName = Utility.CheckStr(ClassName.SelectedItem.Text);
            if (action == "edit")
            {
                if (new D_Pictures().Update(o) > 0)
                    Response.Write("<script>alert(\"޸ĳɹ!\");location.href=\"?\";</script>");
                else
                    Response.Write("<script>alert(\"޸ʧ!\");location.href=\"?\";</script>");
            }
            else
            {
                if (new D_Pictures().Insert(o) > 0)
                    Response.Write("<script>alert(\"ӳɹ!\");location.href=\"?\";</script>");
                else
                    Response.Write("<script>alert(\"ʧ!\");location.href=\"?\";</script>");
            }
        }
        protected void PageView()
        {
            DevinFrame.Pagination.ShowPages p = new DevinFrame.Pagination.ShowPages();
            p.CurPage = CurPage;
            p.PageCount = PageCount;
            p.PageSize = PageSize;
            p.TotalCount = TotalCount;
            Response.Write(p.ChinesePage());
        }
    }
}
