using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DevinFrame.WebGame.Entity;
using DevinFrame.WebGame.Operation;
using DevinFrame.Common;
using DevinFrame;
using DevinFrame.Encrypt;
using System.Text;

namespace DevinFrame.WebGame.Web.manage
{
    public partial class property : System.Web.UI.Page
    {
        protected int CurPage = 1;
        protected int PageCount = 0;
        protected int PageSize = 6;
        protected int TotalCount = 0;
        protected string Type = "";
        protected string TableName = "";
        protected string PageTitle = "";
        protected string action = "";
        protected string Title = "";
        protected string Info = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            action = Utility.CheckStr(Request["action"]);
            Type = Utility.CheckStr(Request["t"]);
            switch (Type)
            {
                case "map":
                    TableName = "D_Map";
                    PageTitle = action == "add" ? "Ϸͼ" : action == "edit" ? "޸Ϸͼ" : "Ϸͼ";
                    Title = "ͼ";
                    Info = "ͼ˵";
                    break;
                case "monster":
                    TableName = "D_Monster";
                    PageTitle = action == "add" ? "Ϸ" : action == "edit" ? "޸Ϸ" : "Ϸ";
                    Title = "";
                    Info = "˵";
                    break;
                case "property":
                    TableName = "D_property";
                    PageTitle = action == "add" ? "װ" : action == "edit" ? "޸װ" : "װ߹";
                    Title = "װ";
                    Info = "Լ;";
                    break;
                case "blackart":
                    TableName = "D_Blackart";
                    PageTitle = action == "add" ? "Ӽħ" : action == "edit" ? "޸ļħ" : "ħ";
                    Title = "ħ";
                    Info = "ħ˵";
                    break;
            }
            if (!Page.IsPostBack)
            {
                btnSubmit.Attributes.Add("onclick", "return PageValid();");
                switch (action)
                {
                    case "add":
                        AddItems.Visible = true;
                        ListItems.Visible = false;
                        BindPrertyClass();
                        break;
                    case "edit":
                        AddItems.Visible = true;
                        ListItems.Visible = false;
                        GetAdminOne();
                        break;
                    case "del":
                        Delete();
                        break;
                    case "dels":
                        Deletes();
                        break;
                    default:
                        AddItems.Visible = false;
                        ListItems.Visible = true;
                        break;
                }
            }
        }
        private void BindPrertyClass()
        {
            string t = "";
            switch (Type)
            {
                case "map":
                    t = "D_MapCategory";
                    break;
                case "monster":
                    t = "D_MapCategory";
                    break;
                case "property":
                    t = "D_PropertyCategory";
                    break;
                case "blackart":
                    t = "D_BlackartCategory";
                    break;
            }
            DevinFrame.Pagination.Condition conditon = new DevinFrame.Pagination.Condition();
            conditon.TableName = t;
            IList i = (IList)new D_Category().GetD_CategoryList(conditon);
            if(i.Count<1)
                Response.Write("<script>alert(\"װ߷.\");location.href=\"Category.aspx?t=" + Type + "&action=add\";</script>");
            foreach (D_CategoryEntity o in i)
            {
                ClassName.Items.Add(new ListItem(o.ClassName, o.Id.ToString()));

            }

        }
        private void GetAdminOne()
        {
            BindPrertyClass();
            int id = Utility.CheckInt(Request["i"]);
            if (id < 1)
                return;
            D_propertyEntity o = new D_property().GetD_propertyEntity(id, TableName);
            Property.Text = o.Property;
            DevinUploader.Value = o.Picture;
            ClassName.SelectedValue = o.ClassId.ToString();
            Attributes.Text = o.Attributes;
            btnSubmit.Text = "޸";
        }
        private void Delete()
        {
            int id = Utility.CheckInt(Request["i"]);
            if (new D_property().Del(id, TableName) > 0)
                Response.Write("<script>alert(\"ɾɹ\");location.href=\"?t=" + Type + "\";</script>");
            else
                Response.Write("<script>alert(\"ɾʧ\");location.href=\"?t=" + Type + "\";</script>");

        }
        private void Deletes()
        {
            string str = "0" + Utility.CheckStr(Request["i"]) + "0";
            if (new D_property().Del(str, TableName) > 0)
                Response.Write("<script>alert(\"ɾɹ\");location.href=\"?t=" + Type + "\";</script>");
            else
                Response.Write("<script>alert(\"ɾʧ\");location.href=\"?t=" + Type + "\";</script>");

        }
        protected void GetItemsList()
        {
            if (Request["page"] != null)
                CurPage = Utility.CheckInt(Request["page"].ToString());
            if (Request["PageSize"] != null)
                PageSize = Utility.CheckInt(Request["PageSize"].ToString());
            if (CurPage < 1) CurPage = 1;
            DevinFrame.Pagination.Pagination pl = new DevinFrame.Pagination.Pagination();
            pl.OrderBy = "Id Desc";
            pl.CurrPage = CurPage;
            pl.PageSize = PageSize;
            pl.Condition = " ";
            pl.TableName = TableName;
            D_property _admin = new D_property();
            IList i = _admin.GetD_propertyList(pl);
            PageCount = _admin.PageCount();
            TotalCount = _admin.RecordCount();
            StringBuilder s = new StringBuilder();
            foreach (D_propertyEntity o in i)
            {
                s.Append("\n\t<tr onmousemove=\"this.style.backgroundColor = '#E4E4E4'\" onmouseout=\"this.style.backgroundColor = ''\">");
                s.Append("\n\t\t<td  style=\"width:10px;text-align:center\" align=\"center\"><input type=\"checkbox\" name=\"checkme\" value=\"" + o.Id + "\" onclick=\"game.checkdels(this)\" /></td>");
                s.Append("\n\t\t<td  style=\"width:20px;text-align:center\" align=\"center\">" + o.Id + "</td>");
                s.Append("\n\t\t<td>" + o.Property + "</td>");
                s.Append("\n\t\t<td>" + o.ClassName + "</td>");
                s.Append("\n\t\t<td>" + o.Attributes + "</td>");
                s.Append("\n\t\t<td><img src=\"" + (Utility.CheckStr(o.Picture) == "" ? "/themes/red/nomiss.gif" : o.Picture) + "\" alt=\"ʾͼ\" title=\"ʾͼ\" style=\"height:32px;\" /></td>");
                s.Append("\n\t\t<td style=\"width:50px;text-align:center\"><a href=\"?action=edit&t=" + Type + "&i=" + o.Id + "\" ><img src=\"themes/blue/edit.gif\" alt=\"޸Ĵ\" title=\"޸Ĵ\" /></a> <a onclick=\"javascript:if(!confirm('ȷɾ ?')) return; else this.setAttribute('href','?action=del&t=" + Type + "&i=" + o.Id + "');\" class=\"hand\"><img src=\"themes/blue/del.gif\" alt=\"ɾ\" title=\"ɾ\" /></a></td>");
                s.Append("</tr>");
            }
            Response.Write(s.ToString());
        }
        protected void btnSubmit_Click(object sender, EventArgs e)
        {
            D_propertyEntity o = new D_propertyEntity();
            o.Property = Utility.CheckStr(Property.Text);
            o.ClassName = Utility.CheckStr(ClassName.SelectedItem.Text);
            o.ClassId = Utility.CheckInt(ClassName.SelectedValue);
            o.Picture = DevinUploader.Value;
            o.Id = Utility.CheckInt(Request["i"]);
            o.Attributes = Utility.CheckStr(Attributes.Text);
            o.TableName = TableName;
            if (action == "edit")
            {
                if (new D_property().Update(o) > 0)
                    Response.Write("<script>alert(\"޸ĳɹ!\");location.href=\"?t=" + Type + "\";</script>");
                else
                    Response.Write("<script>alert(\"޸ʧ!\");location.href=\"?t=" + Type + "\";</script>");
            }
            else
            {
                if (new D_property().Insert(o) > 0)
                    Response.Write("<script>alert(\"ӳɹ!\");location.href=\"?t=" + Type + "\";</script>");
                else
                    Response.Write("<script>alert(\"ʧ!\");location.href=\"?t=" + Type + "\";</script>");
            }
        }
        protected void PageView()
        {
            DevinFrame.Pagination.ShowPages p = new DevinFrame.Pagination.ShowPages();
            p.CurPage = CurPage;
            p.PageCount = PageCount;
            p.PageSize = PageSize;
            p.TotalCount = TotalCount;
            Response.Write(p.ChinesePage());
        }
    }
}
