﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Drawing;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;

/// <summary>
/// CompressPic 的摘要说明
/// </summary>
public class CompressPic
{
    /// <summary>
    /// 压缩指定尺寸的封面
    /// </summary>
    /// <param name="oldfile">原文件</param>
    /// <param name="newfile">新文件</param>
    /// <returns></returns>
    public bool Compress(string oldfile, string newfile)
    {
        try
        {
            System.Drawing.Image img = System.Drawing.Image.FromFile(oldfile);
            System.Drawing.Imaging.ImageFormat thisFormat = img.RawFormat;
            Size newSize = new Size(100, 125);
            Bitmap outBmp = new Bitmap(newSize.Width, newSize.Height);
            Graphics g = Graphics.FromImage(outBmp);
            g.CompositingQuality = CompositingQuality.HighQuality;
            g.SmoothingMode = SmoothingMode.HighQuality;
            g.InterpolationMode = InterpolationMode.HighQualityBicubic;
            g.DrawImage(img, new Rectangle(0, 0, newSize.Width, newSize.Height), 0, 0, img.Width, img.Height, GraphicsUnit.Pixel);
            g.Dispose();
            EncoderParameters encoderParams = new EncoderParameters();
            long[] quality = new long[1];
            quality[0] = 100;
            EncoderParameter encoderParam = new EncoderParameter(System.Drawing.Imaging.Encoder.Quality, quality);
            encoderParams.Param[0] = encoderParam;
            ImageCodecInfo[] arrayICI = ImageCodecInfo.GetImageEncoders();
            ImageCodecInfo jpegICI = null;
            for (int x = 0; x < arrayICI.Length; x++)
                if (arrayICI[x].FormatDescription.Equals("JPEG"))
                {
                    jpegICI = arrayICI[x];//设置JPEG编码
                    break;
                }
            img.Dispose();
            if (jpegICI != null)
                outBmp.Save(newfile, System.Drawing.Imaging.ImageFormat.Jpeg);
            else
                outBmp.Save(newfile, System.Drawing.Imaging.ImageFormat.Jpeg);
            outBmp.Dispose();
            return true;
        }
        catch
        {
            return false;
        }
    }
}
