﻿using System;
using System.IO;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class addchapter : System.Web.UI.Page
{
    protected string title = "";
    protected string chaptername = "";
    protected string chaptercontent = "";
    protected string chapterpath = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session.Contents["username"] == null)
            Response.Write("<script language='javascript' type='text/javascript'>alert('" + Resources.Resource.AddChapter1+ "');location='default.aspx';</script>");
        if (Request.QueryString["topicid"] != null && Regular.IsId(Request.QueryString["topicid"].ToString()))
        {
            string path = "";
            int chapterid = 0, operate = 0;
            if (Request.QueryString["operate"] != null && (Request.QueryString["operate"].ToString() == "1" || Request.QueryString["operate"].ToString() == "2") && Request.QueryString["chapterid"] != null && Regular.IsId(Request.QueryString["chapterid"].ToString()))
            {
                chapterid = int.Parse(Request.QueryString["chapterid"].ToString());
                operate = int.Parse(Request.QueryString["operate"].ToString());
            }
            int topicid = int.Parse(Request.QueryString["topicid"].ToString());
            DataSet dataset = SqlStore.SqlDiyReadChapter(topicid, Session.Contents["username"].ToString(), chapterid, operate, ref title, ref path, ref chapterpath);
            if (chapterpath != "")
                File.Delete(Server.MapPath(path) + chapterpath);
            this.List_ChapterList.DataSource = dataset.Tables[0];
            this.List_ChapterList.DataBind();
            if (operate == 1 && dataset.Tables.Count == 2)
            {
                this.Hidden_.Value = topicid + "," + chapterid;
                this.Button_Add.Text = "修改章节";
                chaptername = dataset.Tables[1].Rows[0]["chapter"].ToString();
                if (File.Exists(Server.MapPath(path+ dataset.Tables[1].Rows[0]["path"].ToString())))
                    chaptercontent = File.ReadAllText(Server.MapPath(path+ dataset.Tables[1].Rows[0]["path"].ToString()), System.Text.Encoding.Default).Replace("<br>","\n");
            }
        }
    }

    protected void Button_Add_Click(object sender, EventArgs e)
    {
        if (Request.Form["Text_Chapter"] != null && Request.Form["Text_Content"] != null && Request.QueryString["topicid"] != null && Regular.IsId(Request.QueryString["topicid"].ToString()))
        {
            string novelinfo = this.Hidden_.Value;
            string chapter = Regular.Filtrate(Request.Form["Text_Chapter"].ToString().Trim());
            string content = Regular.Filtrate(Request.Form["Text_Content"].ToString().TrimEnd());
            int topicid = int.Parse(Request.QueryString["topicid"].ToString());
            if (chapter.Length == 0 || chapter.Length > 60 || content.Length == 0)
            {
                Response.Write("<script language='javascript' type='text/javascript'>alert('" + Resources.Resource.AddChapter2 + "');</script>");
                return;
            }
            string author = Session.Contents["username"].ToString();
            string root = Server.MapPath("")+"/";
            string topicpath, filename;
            SqlStore.SqlDiyPath(topicid, out topicpath,out filename);
            topicpath = root + topicpath;
            Directory.CreateDirectory(topicpath);
            if (novelinfo != "0")
            {
                int topicid_ = int.Parse(novelinfo.Split(',')[0]);
                int chapterid_ = int.Parse(novelinfo.Split(',')[1]);
                string topicpath_ = topicpath + SqlStore.SqlDiyModChapter(author, topicid_, chapterid_, chapter, content.Length);
                WriteChapter(topicpath_, content);
                Response.Redirect(Request.Url.ToString());
            }
            int i = 1;
            if (filename!="")
                i = int.Parse(filename.Substring(0, filename.LastIndexOf('.'))) + 1;
            WriteChapter(topicpath + i + ".txt", content);
            SqlStore.SqlDiyAddChapter(topicid, chapter, i+ ".txt", content.Length);
            Response.Write("<script language='javascript' type='text/javascript'>if(confirm('" + Resources.Resource.AddChapter3 + "')) location='addchapter.aspx?topicid=" + topicid + "'; else location='editnovel.aspx';</script>");
        }
    }

    private void WriteChapter(string topicpath, string content)
    {
        StreamWriter write = new StreamWriter(topicpath, false, System.Text.Encoding.Default);
        write.Write(content);
        write.Close();
    }
}