﻿using System;
using System.IO;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class addnovel : System.Web.UI.Page
{
    protected string boardid = "1";
    protected string title = "";
    protected string cover = "image/nocover.jpg";
    protected string intro = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session.Contents["username"] == null)
            Response.Write("<script language='javascript' type='text/javascript'>alert('" + Resources.Resource.AddNovel1 + "');location='default.aspx';</script>");
        this.File_Pic.Attributes.Add("onChange", "imageshow();");
        if (Request.QueryString["topicid"] != null && Regular.IsId(Request.QueryString["topicid"].ToString()))
        {
            DataTable table = SqlStore.SqlDiyIntro(Session.Contents["username"].ToString(), int.Parse(Request.QueryString["topicid"].ToString()));
            if (table.Rows.Count == 1)
            {
                this.Hidden_.Value = table.Rows[0]["topicid"].ToString();
                boardid = table.Rows[0]["boardid"].ToString();
                title = table.Rows[0]["title"].ToString();
                cover = table.Rows[0]["pic"].ToString();
                this.Hidden_Cover.Value = cover;
                if (cover == "") cover = "image/nocover.jpg";
                intro = table.Rows[0]["intro"].ToString().Replace("<br>", "\n");
                this.Button_Add.Text = "修 改";
            }
        }
    }

    protected void Button_Add_Click(object sender, EventArgs e)
    {
        if (Request.Form["Text_Title"] != null && Request.Form["Text_Intro"] != null)
        {
            string title =Regular.Filtrate(Request.Form["Text_Title"].ToString().Trim());
            string intro = Regular.Filtrate(Request.Form["Text_Intro"].ToString().TrimEnd());
            string boardid = Request.Form["Select_Boardid"].ToString();
            if (title.Length == 0 || title.Length > 100 || intro.Length == 0 || intro.Length > 3000)
            {
                Response.Write("<script language='javascript' type='text/javascript'>alert('" + Resources.Resource.AddNovel2 + "');</script>");
                return;
            }
            string author = Session.Contents["username"].ToString();
            string root = Server.MapPath("") + "/";
            string topicid_ = this.Hidden_.Value;
            string cover = "";
            bool ismark = false;
            if (topicid_ != "0" && this.Button_Add.Text == "修 改")
                ismark =  SqlStore.SqlDiyModTopic(title, author, intro, int.Parse(boardid), int.Parse(topicid_), ref cover);
            if (File_Pic.HasFile)
            {
                string suffix = File_Pic.FileName.Remove(0, File_Pic.FileName.LastIndexOf('.')).ToLower();
                if(suffix!=".jpg" && suffix!=".gif")
                    Response.Write("<script language='javascript' type='text/javascript'>alert('" + Resources.Resource.AddNovel3 + "'); history.back();</script>");
                cover = cover != "" ? (root + cover) : (CreatePath(root + "pic/", suffix));
                Directory.CreateDirectory(cover.Remove(cover.LastIndexOf("/")));
                File_Pic.PostedFile.SaveAs(cover);
                CompressPic compress = new CompressPic();
                compress.Compress(cover, cover);
                cover = cover.Replace(root, "");
            }
            if (!ismark)
            {
                string topicpath = CreatePath(root + "chapter/");
                int topicid = SqlStore.SqlDiyAddTopic(title, author, cover,topicpath.Replace(root,""), intro, int.Parse(boardid));
                Response.Write("<script language='javascript' type='text/javascript'>if(confirm('" + Resources.Resource.AddNovel4 + "')) location='addchapter.aspx?topicid=" + topicid + "'; else location='editnovel.aspx';</script>");
            }
            else
            {
                SqlStore.SqlExec("update novel_topic set pic='"+cover+"' where topicid="+topicid_+" and serial=(select serial from novel_user where username='"+author+"')");
                Response.Write("<script language='javascript' type='text/javascript'>alert('" + Resources.Resource.AddNovel5 + "'); location='addchapter.aspx?topicid=" + topicid_ + "';</script>");
            }
        }
    }
    private string CreatePath(string path)
    {
        DateTime time = DateTime.Now;
        string route = "";
        for (int i = 1; i < 80; i++)
        {
            route = path + time.ToString("yyyy") + "/" + time.ToString("MM") + time.ToString("dd") + "/" + i + "/";
            if (!Directory.Exists(route))
            {
                Directory.CreateDirectory(route);
                break;
            }
            else if (Directory.GetDirectories(route).Length < 300)
                break;
        }
        Directory.CreateDirectory(route);
        return route;
    }
    private string CreatePath(string path, string suffix)
    {
        DateTime time = DateTime.Now;
        for (int i = 1; i < 60; i++)
        {
            string route = path + time.ToString("yyyy") + "/" + time.ToString("MM") + time.ToString("dd") + "/" + i;
            if (!Directory.Exists(route))
            {
                Directory.CreateDirectory(route);
                path = route + "/" + time.Ticks.ToString().Substring(7, 7) + suffix;
                break;
            }
            else if (Directory.GetFiles(route).Length < 600)
            {
                path = route + "/" + time.Ticks.ToString().Substring(7, 7) + suffix;
                break;
            }
        }
        return path;
    }
}