﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class manage_commend : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            if (Request.QueryString["commend"] != null && Regular.IsId(Request.QueryString["commend"].ToString()))
            {
                SqlStore.SqlCommend(int.Parse(Request.QueryString["commend"].ToString()));
                Response.Redirect("commend.aspx");
            }
            if (Request.QueryString["delcommendid"] != null && Regular.IsId(Request.QueryString["delcommendid"].ToString()))
            {
                SqlStore.SqlCommendDel(int.Parse(Request.QueryString["delcommendid"].ToString()));
                Response.Redirect("commend.aspx");
            }
            ShowPage(1);
        }
    }
    protected void Button_Add_Click(object sender, EventArgs e)
    {
        string topicid=this.Text_Topicid.Text;
        if (Regular.IsId(topicid))
        {
            SqlStore.SqlCommendNovel(int.Parse(topicid));
            Response.Redirect("commend.aspx");
        }
    }
    protected void Button_Jump_Click(object sender, EventArgs e)
    {
        #region GO按扭
        Button button = (Button)sender;
        string page = "";
        page = this.Text_Jump.Text.Trim();
        this.Text_Jump.Text = "";
        page = page == "" ? "1" : page;
        page = Regular.IsId(page) ? page : "1";
        int pageCurrent = int.Parse(page);
        int PageAmount = int.Parse(this.Text_PageCount.Text);
        if (pageCurrent > PageAmount && PageAmount != -1)
            pageCurrent = PageAmount;
        if (pageCurrent < 1)
            pageCurrent = 1;
        ShowPage(pageCurrent);
        #endregion
    }
    protected void LinkButton_Front_Click(object sender, EventArgs e)
    {
        #region 上一页
        this.Button_Next.Enabled = true;
        this.Button_Last.Enabled = true;
        int pageCurrent = int.Parse(this.Text_CurrentPage.Text);
        int PageAmount = int.Parse(this.Text_PageCount.Text);
        if (pageCurrent > PageAmount && PageAmount != -1)
            pageCurrent = PageAmount;
        ShowPage(pageCurrent - 1);
        #endregion
    }
    protected void LinkButton_Next_Click(object sender, EventArgs e)
    {
        #region 下一页
        this.Button_First.Enabled = true;
        this.Button_Front.Enabled = true;
        int pageCurrent = int.Parse(this.Text_CurrentPage.Text);
        int PageAmount = int.Parse(this.Text_PageCount.Text);
        if (pageCurrent > PageAmount && PageAmount != -1)
            pageCurrent = PageAmount;
        ShowPage(pageCurrent + 1);
        #endregion
    }
    protected void LinkButton_First_Click(object sender, EventArgs e)
    {
        this.Button_First.Enabled = false;
        this.Button_Front.Enabled = false;
        ShowPage(1);
    }

    protected void LinkButton_Last_Click(object sender, EventArgs e)
    {
        this.Button_Last.Enabled = false;
        this.Button_Next.Enabled = false;
        int PageAmount = int.Parse(this.Text_PageCount.Text);
        ShowPage(PageAmount);
    }

    protected void ShowPage(int requestPage)
    {
        int recordAmount = 0, pageAmount = 0;
        string showField = "topicid,ispic,mark,boardname,title,'../novelintro.aspx?topicid='+convert(char(10),topicid) as link,'commend.aspx?commend='+convert(char(10),topicid) as iscommend,'commend.aspx?delcommendid='+convert(char(10),topicid) as delcommendid";
        DataTable table = SqlStore.SqlPage("novel_commend", "commendid", showField, "mark desc,boardid,topicid desc", "", requestPage, 30, ref recordAmount, ref pageAmount);

        this.List_Commend.DataSource = table;
        this.List_Commend.DataBind();

        if (requestPage > pageAmount)
            requestPage = pageAmount;
        if (pageAmount != 1)
        {
            this.Button_First.Enabled = true;
            this.Button_Front.Enabled = true;
            this.Button_Jump.Enabled = true;
            this.Button_Last.Enabled = true;
            this.Button_Next.Enabled = true;
        }
        if (requestPage == 1)
        {
            this.Button_First.Enabled = false;
            this.Button_Front.Enabled = false;
        }
        if (requestPage == pageAmount)
        {
            this.Button_Last.Enabled = false;
            this.Button_Next.Enabled = false;
        }
        this.Text_CurrentPage.Text = requestPage.ToString();
        this.Text_PageCount.Text = pageAmount.ToString();
        this.Label_Detail.Text = "页次<font color=red>" + requestPage + "</font>/<font color=red>" + pageAmount + "</font> 每页<font color=red>30</font>条 共<font color=red>" + recordAmount + "</font>条记录";
    }
}
