﻿using System;
using System.IO;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class manage_edit : System.Web.UI.Page
{
    protected int boardid;
    protected string title;
    protected string intro;
    protected string path;
    protected string cover = "image/nocover.jpg";
    protected void Page_Load(object sender, EventArgs e)
    {
        AjaxPro.Utility.RegisterTypeForAjax(typeof(manage_edit));
        this.File_Pic.Attributes.Add("onChange", "imageshow();");
        if (Request.QueryString["topicid"] != null && Regular.IsId(Request.QueryString["topicid"].ToString()))
            ReadInfo(int.Parse(Request.QueryString["topicid"].ToString()));
    }
    protected void Button_Add_Click(object sender, EventArgs e)
    {
        if (Regular.IsId(Text_Topicid.Text.Trim()))
            ReadInfo(int.Parse(Text_Topicid.Text.Trim()));
    }
    protected void ReadInfo(int topicid)
    {
        DataTable table = SqlStore.SqlManageEditRead(topicid, out boardid, out title, out cover, out intro, out path);
        this.List_ChapterList.DataSource = table;
        this.List_ChapterList.DataBind();
        if (boardid > 2 && boardid % 2 == 0) boardid--;
        this.Hidden_Topicid.Value = Text_Topicid.Text.Trim();
        this.Hidden_Cover.Value = cover;
        this.Hidden_NewChapter.Value = path + (table.Rows.Count + 1) + ".txt";
        if (cover == "") cover = "image/nocover.jpg";
    }
    /// <summary>
    /// 修改简介
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Button_ModIntro_Click(object sender, EventArgs e)
    {
        if (Request.Form["Text_Title"] != null && Request.Form["Text_Intro"] != null)
        {
            string root = Server.MapPath("../") + "/";
            int topicid = int.Parse(Hidden_Topicid.Value);
            boardid = int.Parse(Request.Form["Select_Boardid"].ToString());
            title = Request.Form["Text_Title"].ToString().Trim();
            intro = Request.Form["Text_Intro"].ToString().TrimEnd();
            cover = Hidden_Cover.Value;
            if (title.Length == 0 || title.Length > 100 || intro.Length == 0 || intro.Length > 3000)
                Response.Write("<script language='javascript' type='text/javascript'>alert('小说名称和介绍分别不得超出100和3000字符，且均不得为空！');location='edit.aspx';</script>");
            if (File_Pic.HasFile)
            {
                string suffix = File_Pic.FileName.Remove(0, File_Pic.FileName.LastIndexOf('.')).ToLower();
                if (suffix != ".jpg" && suffix != ".gif")
                    Response.Write("<script language='javascript' type='text/javascript'>alert('封面只能是gif或jpg类型图片！'); location='edit.aspx';</script>");
                cover = cover != "" ? (root + cover) : (CreatePath(root + "pic/", suffix));
                Directory.CreateDirectory(cover.Remove(cover.LastIndexOf("/")));
                File_Pic.PostedFile.SaveAs(cover);
                //图片压缩成指定大小
                //CompressPic compress = new CompressPic();
                //compress.Compress(cover, cover);
                cover = cover.Replace(root, "");
            }
            SqlStore.SqlManageEditModTopic(topicid, boardid, title, intro, cover);
        }
    }
    private string CreatePath(string path, string suffix)
    {
        DateTime time = DateTime.Now;
        for (int i = 1; i < 60; i++)
        {
            string route = path + time.ToString("yyyy") + "/" + time.ToString("MM") + time.ToString("dd") + "/" + i;
            if (!Directory.Exists(route))
            {
                Directory.CreateDirectory(route);
                path = route + "/" + time.Ticks.ToString().Substring(7, 7) + suffix;
                break;
            }
            else if (Directory.GetFiles(route).Length < 600)
            {
                path = route + "/" + time.Ticks.ToString().Substring(7, 7) + suffix;
                break;
            }
        }
        return path;
    }
    /// <summary>
    /// 修改章节
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Button_ModChapter_Click(object sender, EventArgs e)
    {
        if (Request.Form["Hidden_Chapterid"] != null && Request.Form["Hidden_Chapterid"].ToString()!="" && Request.Form["Text_ChapterName"] != null && Request.Form["Text_Content"] != null)
        {
            int topicid = int.Parse(Hidden_Topicid.Value);
            int chapterid = int.Parse(Request.Form["Hidden_Chapterid"].ToString());
            string title = Request.Form["Text_ChapterName"].ToString().Trim();
            string content = Request.Form["Text_Content"].ToString().TrimEnd();
            string Hidden_Path = Request.Form["Hidden_Path"].ToString().TrimEnd();
            if (title.Length == 0 || title.Length > 100 || content == "" || Hidden_Path == "")
                return;
            SqlStore.SqlManageEditModChapter(topicid, chapterid, content.Length, "'" + title + "'");
            if (File.Exists(Server.MapPath("../" + Hidden_Path)))
                WriteChapter(Server.MapPath("../" + Hidden_Path), content);
            ReadInfo(topicid);
        }
    }
    private void WriteChapter(string topicpath, string content)
    {
        StreamWriter write = new StreamWriter(topicpath, false, System.Text.Encoding.Default);
        write.Write(content);
        write.Close();
    }
    /// <summary>
    /// 删除章节
    /// </summary>
    /// <param name="topicid">小说ID</param>
    /// <param name="chapterid">章节ID</param>
    /// <param name="path">章节内容文本路径</param>
    [AjaxPro.AjaxMethod]
    public void delchapter(int topicid, int chapterid, string path)
    {
        if (File.Exists(HttpContext.Current.Server.MapPath("../" + path).Replace(@"ajaxpro\", "")))
            File.Delete(HttpContext.Current.Server.MapPath("../" + path).Replace(@"ajaxpro\", ""));
        SqlStore.SqlDelChapter(topicid, chapterid);
    }
    /// <summary>
    /// 新增章节
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Button_AddChapter_Click(object sender, EventArgs e)
    {
        if (Regular.IsId(Hidden_Topicid.Value))
        {
            int topicid = int.Parse(Hidden_Topicid.Value);
            string filepath = Hidden_NewChapter.Value;
            string title = Request.Form["Text_ChapterName"].ToString().Trim();
            string content = Request.Form["Text_Content"].ToString().TrimEnd();
            if (title.Length == 0 || title.Length > 100 || content == "") return;
            Directory.CreateDirectory(Server.MapPath("../"+ filepath.Substring(0, filepath.LastIndexOf("/") + 1)));
            WriteChapter(Server.MapPath("../" + filepath), content);
            SqlStore.SqlManual(topicid, "'" + title + "'", "'" + filepath.Remove(0, filepath.LastIndexOf("/") + 1) + "'", content.Length);
            ReadInfo(topicid);
        }
    }
}