﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class manage_error : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            if (Request.QueryString["errorid"] != null && Regular.IsId(Request.QueryString["errorid"].ToString()))
                SqlStore.SqlErrorDel(int.Parse(Request.QueryString["errorid"].ToString()));
            ShowPage(1);
        }
    }
    protected void Button_Jump_Click(object sender, EventArgs e)
    {
        #region GO按扭
        Button button = (Button)sender;
        string page = "";
        page = this.Text_Jump.Text.Trim();
        this.Text_Jump.Text = "";
        page = page == "" ? "1" : page;
        page = Regular.IsId(page) ? page : "1";
        int pageCurrent = int.Parse(page);
        int PageAmount = int.Parse(this.Text_PageCount.Text);
        if (pageCurrent > PageAmount && PageAmount != -1)
            pageCurrent = PageAmount;
        if (pageCurrent < 1)
            pageCurrent = 1;
        ShowPage(pageCurrent);
        #endregion
    }
    protected void LinkButton_Front_Click(object sender, EventArgs e)
    {
        #region 上一页
        this.Button_Next.Enabled = true;
        this.Button_Last.Enabled = true;
        int pageCurrent = int.Parse(this.Text_CurrentPage.Text);
        int PageAmount = int.Parse(this.Text_PageCount.Text);
        if (pageCurrent > PageAmount && PageAmount != -1)
            pageCurrent = PageAmount;
        ShowPage(pageCurrent - 1);
        #endregion
    }
    protected void LinkButton_Next_Click(object sender, EventArgs e)
    {
        #region 下一页
        this.Button_First.Enabled = true;
        this.Button_Front.Enabled = true;
        int pageCurrent = int.Parse(this.Text_CurrentPage.Text);
        int PageAmount = int.Parse(this.Text_PageCount.Text);
        if (pageCurrent > PageAmount && PageAmount != -1)
            pageCurrent = PageAmount;
        ShowPage(pageCurrent + 1);
        #endregion
    }
    protected void LinkButton_First_Click(object sender, EventArgs e)
    {
        #region 首页
        this.Button_First.Enabled = false;
        this.Button_Front.Enabled = false;
        ShowPage(1);
        #endregion
    }

    protected void LinkButton_Last_Click(object sender, EventArgs e)
    {
        #region 尾页
        this.Button_Last.Enabled = false;
        this.Button_Next.Enabled = false;
        int PageAmount = int.Parse(this.Text_PageCount.Text);
        ShowPage(PageAmount);
        #endregion
    }

    protected void ShowPage(int requestPage)
    {
        int recordAmount = 0, pageAmount = 0;
        string showField = @"errorid,topicid,chapterid,times,'error.aspx?errorid='+convert(char(10),errorid) as del";
        DataTable table = SqlStore.SqlPage("novel_error", "errorid", showField, "topicid desc,times desc", "", requestPage, 30, ref recordAmount, ref pageAmount);

        this.View_Note.DataSource = table;
        this.View_Note.DataBind();

        if (requestPage > pageAmount)
            requestPage = pageAmount;
        if (pageAmount != 1)
        {
            this.Button_First.Enabled = true;
            this.Button_Front.Enabled = true;
            this.Button_Jump.Enabled = true;
            this.Button_Last.Enabled = true;
            this.Button_Next.Enabled = true;
        }
        if (requestPage == 1)
        {
            this.Button_First.Enabled = false;
            this.Button_Front.Enabled = false;
        }
        if (requestPage == pageAmount)
        {
            this.Button_Last.Enabled = false;
            this.Button_Next.Enabled = false;
        }
        this.Text_CurrentPage.Text = requestPage.ToString();
        this.Text_PageCount.Text = pageAmount.ToString();
        this.Label_Detail.Text = "页次<font color=red>" + requestPage + "</font>/<font color=red>" + pageAmount + "</font> 每页<font color=red>30</font>条 共<font color=red>" + recordAmount + "</font>条记录";
    }
}
