﻿using System;
using System.IO;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class manage_recycler : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            if (Request.QueryString["resumeid"] != null && Regular.IsId(Request.QueryString["resumeid"].ToString()))
                SqlStore.SqlRecycler(int.Parse(Request.QueryString["resumeid"].ToString()), false);
            if (Request.QueryString["deleteid"] != null && Regular.IsId(Request.QueryString["deleteid"].ToString()))
            {
                string pic = "", path = "";
                int topicid = int.Parse(Request.QueryString["deleteid"].ToString());
                SqlStore.SqlNovelFilePath(topicid, ref pic, ref path);
                Delete_(pic != "" ? Server.MapPath("../") + pic : "", path != "" ? Server.MapPath("../") + path : "");
                SqlStore.SqlNovelDelete(topicid, true);
            }
            if (Request.QueryString["deleteid_"] != null && Regular.IsId(Request.QueryString["deleteid_"].ToString()))
            {
                string pic = "", path = "";
                int topicid = int.Parse(Request.QueryString["deleteid_"].ToString());
                SqlStore.SqlNovelFilePath(topicid, ref pic, ref path);
                Delete_(pic != "" ? Server.MapPath("../") + pic : "", path != "" ? Server.MapPath("../") + path : "");
                SqlStore.SqlNovelDelete(topicid, false);
            }
            ShowPage(1);
        }
    }
    protected void Button_Jump_Click(object sender, EventArgs e)
    {
        #region GO按扭
        Button button = (Button)sender;
        string page = "";
        page = this.Text_Jump.Text.Trim();
        this.Text_Jump.Text = "";
        page = page == "" ? "1" : page;
        page = Regular.IsId(page) ? page : "1";
        int pageCurrent = int.Parse(page);
        int PageAmount = int.Parse(this.Text_PageCount.Text);
        if (pageCurrent > PageAmount && PageAmount != -1)
            pageCurrent = PageAmount;
        if (pageCurrent < 1)
            pageCurrent = 1;
        ShowPage(pageCurrent);
        #endregion
    }
    protected void LinkButton_Front_Click(object sender, EventArgs e)
    {
        #region 上一页
        this.Button_Next.Enabled = true;
        this.Button_Last.Enabled = true;
        int pageCurrent = int.Parse(this.Text_CurrentPage.Text);
        int PageAmount = int.Parse(this.Text_PageCount.Text);
        if (pageCurrent > PageAmount && PageAmount != -1)
            pageCurrent = PageAmount;
        ShowPage(pageCurrent - 1);
        #endregion
    }
    protected void LinkButton_Next_Click(object sender, EventArgs e)
    {
        #region 下一页
        this.Button_First.Enabled = true;
        this.Button_Front.Enabled = true;
        int pageCurrent = int.Parse(this.Text_CurrentPage.Text);
        int PageAmount = int.Parse(this.Text_PageCount.Text);
        if (pageCurrent > PageAmount && PageAmount != -1)
            pageCurrent = PageAmount;
        ShowPage(pageCurrent + 1);
        #endregion
    }
    protected void LinkButton_First_Click(object sender, EventArgs e)
    {
        this.Button_First.Enabled = false;
        this.Button_Front.Enabled = false;
        ShowPage(1);
    }

    protected void LinkButton_Last_Click(object sender, EventArgs e)
    {
        this.Button_Last.Enabled = false;
        this.Button_Next.Enabled = false;
        int PageAmount = int.Parse(this.Text_PageCount.Text);
        ShowPage(PageAmount);
    }

    protected void ShowPage(int requestPage)
    {
        int recordAmount = 0, pageAmount = 0;
        string showField = @"topicid,boardid,'../novelintro.aspx?topicid='+convert(char(10),topicid) as link,title,hits,addtime,updatetime,'recycler.aspx?resumeid='+convert(char(10),topicid) as resume,'recycler.aspx?deleteid_='+convert(char(10),topicid) as delete_,'recycler.aspx?deleteid='+convert(char(10),topicid) as [delete]";
        DataTable table = SqlStore.SqlPage("novel_topic", "topicid", showField, "topicid desc","recycler=1", requestPage, 30, ref recordAmount, ref pageAmount);

        this.View_Note.DataSource = table;
        this.View_Note.DataBind();

        if (requestPage > pageAmount)
            requestPage = pageAmount;
        if (pageAmount != 1)
        {
            this.Button_First.Enabled = true;
            this.Button_Front.Enabled = true;
            this.Button_Jump.Enabled = true;
            this.Button_Last.Enabled = true;
            this.Button_Next.Enabled = true;
        }
        if (requestPage == 1)
        {
            this.Button_First.Enabled = false;
            this.Button_Front.Enabled = false;
        }
        if (requestPage == pageAmount)
        {
            this.Button_Last.Enabled = false;
            this.Button_Next.Enabled = false;
        }
        this.Text_CurrentPage.Text = requestPage.ToString();
        this.Text_PageCount.Text = pageAmount.ToString();
        this.Label_Detail.Text = "页次<font color=red>" + requestPage + "</font>/<font color=red>" + pageAmount + "</font> 每页<font color=red>30</font>条 共<font color=red>" + recordAmount + "</font>条记录";
    }
    protected void List_Type_SelectedIndexChanged(object sender, EventArgs e)
    {
        ShowPage(1);
    }
    protected void Delete_(string pic, string topicpath)
    {
        if (pic != "" && File.Exists(pic))
            File.Delete(pic);
        if (topicpath != "" && Directory.Exists(topicpath.Substring(0, topicpath.LastIndexOf('/'))))
            Directory.Delete(topicpath.Substring(0, topicpath.LastIndexOf('/')), true);
    }
    protected void Button_Clear_Click(object sender, EventArgs e)
    {
    }
}
