﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class _novelintro : System.Web.UI.Page
{
    protected int boardid=9;
    /// <summary>
    /// 版块名称
    /// </summary>
    protected string boardname = "未知";
    /// <summary>
    /// 标题
    /// </summary>
    protected string title = "未知";
    /// <summary>
    /// 作者
    /// </summary>
    protected string author = "未知";
    /// <summary>
    /// 介绍
    /// </summary>
    protected string intro = "未知";
    /// <summary>
    /// 长度
    /// </summary>
    protected string length = "未知";
    /// <summary>
    /// 状态
    /// </summary>
    protected string state = "未知";
    /// <summary>
    /// 更新时间
    /// </summary>
    protected string updatetime = "未知";
    /// <summary>
    /// 总点击
    /// </summary>
    protected string hits = "未知";
    /// <summary>
    /// 周点击
    /// </summary>
    protected string week = "未知";
    /// <summary>
    /// 收藏数
    /// </summary>
    protected string favorite = "未知";
    /// <summary>
    /// 类别
    /// </summary>
    protected string type = "未知";
    /// <summary>
    /// 推荐次数
    /// </summary>
    protected string commend = "未知";
    /// <summary>
    /// 小说ID
    /// </summary>
    protected string topicid = "";
    /// <summary>
    /// 封面
    /// </summary>
    protected string cover = "image/nocover.jpg";
    /// <summary>
    /// 最新章节ID
    /// </summary>
    protected string chapterid = "";
    /// <summary>
    /// 最新章节名称
    /// </summary>
    protected string chapetname = "未知";

    protected void Page_Load(object sender, EventArgs e)
    {
        //显示小说明细
        if (Request.QueryString["topicid"] != null && Regular.IsId(Request.QueryString["topicid"].ToString()))
        {
            DataSet dataset = SqlStore.SqlIntro(int.Parse(Request.QueryString["topicid"].ToString()));
            this.List_Comment.DataSource = dataset.Tables[0];
            this.List_Comment.DataBind();
            if (dataset.Tables[1].Rows.Count == 1)
            {
                this.Hidden_Topicid.Value = dataset.Tables[1].Rows[0]["topicid"].ToString();
                if (Session.Contents["username"] != null)
                    this.Text_Comment.Text = Session.Contents["username"].ToString();

                boardname = dataset.Tables[1].Rows[0]["name"].ToString();
                title = dataset.Tables[1].Rows[0]["title"].ToString().Replace("\"", "");
                author = dataset.Tables[1].Rows[0]["author"].ToString();
                intro = dataset.Tables[1].Rows[0]["intro"].ToString().Replace("\"", "").Replace("\n","<br />");
                length = dataset.Tables[1].Rows[0]["length"].ToString() + (dataset.Tables[1].Rows[0]["type"].ToString() == "1" ? "千" : "");
                state = (bool)dataset.Tables[1].Rows[0]["isfinish"] ? "完成" : "连载中";
                updatetime = dataset.Tables[1].Rows[0]["updatetime"].ToString().Split(' ')[0];
                hits = dataset.Tables[1].Rows[0]["hits"].ToString();
                week = dataset.Tables[1].Rows[0]["week"].ToString();
                favorite = dataset.Tables[1].Rows[0]["collection"].ToString();
                type = dataset.Tables[1].Rows[0]["type"].ToString();
                commend = dataset.Tables[1].Rows[0]["commend"].ToString();
                topicid = dataset.Tables[1].Rows[0]["topicid"].ToString();
                cover = dataset.Tables[1].Rows[0]["pic"].ToString().Trim();
                chapterid = dataset.Tables[1].Rows[0]["newchapter"].ToString().Split('|')[1];
                chapetname = dataset.Tables[1].Rows[0]["newchapter"].ToString().Split('|')[0];
                board();
            }
            else
            {
                string title = SqlStore.SqlTopicError(int.Parse(Request.QueryString["topicid"].ToString()));
                if (title != "") Response.Write("<script type=\"text/javascript\">document.location='novelsearch.aspx?key=" + title + "&sort=novel&judge=0'</script>");
            }
        }
    }
    protected void Button_Comment_Click(object sender, EventArgs e)
    {
        //访客发表评论
        if (Request.QueryString["topicid"] != null && Regular.IsId(Request.QueryString["topicid"].ToString()) && this.Hidden_Topicid.Value == Request.QueryString["topicid"].ToString())
        {
            string content =Regular.Filtrate( Request.Form["Text_Content"].ToString());
            SqlStore.SqlComment(int.Parse(Hidden_Topicid.Value), (Session.Contents["username"] == null ? "游客" : Session.Contents["username"].ToString()), content, Request.UserHostAddress);
            Response.Redirect(Request.Url.ToString());
        }
    }
    protected void board()
    {
        switch (boardname)
        {
            case "玄幻奇幻":
                boardid = 1;
                break;
            case "武侠仙侠":
                boardid = 2;
                break;
            case "浪漫言情":
                boardid = 3;
                break;
            case "历史军事":
                boardid = 5;
                break;
            case "游戏竞技":
                boardid = 7;
                break;
            case "科幻灵异":
                boardid = 9;
                break;
            case "美文同人":
                boardid = 11;
                break;
            case "最新漫画":
                boardid = 13;
                break;
        }
    }
}