﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class _novellist : System.Web.UI.Page
{
    protected int boardid = 1;
    protected string boardname = "玄幻奇幻";
    protected string topicamount;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request.Form["Text_CurrentPage"] != null && Request.Form["Text_PageCount"]!=null && Regular.IsId(Request.Form["Text_CurrentPage"].ToString()) && Request.Form["Text_PageCount"].ToString() == "static")
            ShowPage(int.Parse(Request.Form["Text_CurrentPage"].ToString()), ReturnWhere());
        if (!IsPostBack)
            ShowPage(1, ReturnWhere());
    }
    /// <summary>
    /// 分页显示小说列表
    /// </summary>
    /// <param name="requestPage">将要显示的页面</param>
    /// <param name="where">SQL条件部分</param>
    protected void ShowPage(int requestPage, string where)
    {
        #region 数据绑定及显示
        int recordAmount = 0, pageAmount = 0;
        BoardName();
        DataTable table;
        if (boardid < 15)
            table = SqlStore.SqlPage("novel_topic", "topicid", "*", Select_Type.SelectedValue+" desc", ReturnWhere(), requestPage, 40, ref recordAmount, ref pageAmount);
        else if (boardid == 15)
            table = SqlStore.SqlPage("commend_update", "topicid", "*", Select_Type.SelectedValue+" desc", "", requestPage, 40, ref recordAmount, ref pageAmount);
        else if (boardid == 16)
            table = SqlStore.SqlPage("novel_topic", "topicid", "*", Select_Type.SelectedValue+" desc", "isfinish=1 and hidden=0", requestPage, 40, ref recordAmount, ref pageAmount);
        else
        {
            Select_Type.Enabled = false;
            Button_Look.Enabled = false;
            table = SqlStore.SqlPage("novel_topic", "topicid", "*", "hits desc", "hidden=0", requestPage, 40, ref recordAmount, ref pageAmount);
        }
        this.List_.DataSource = table;
        this.List_.DataBind();

        if (requestPage > pageAmount)
            requestPage = pageAmount;
        if (pageAmount != 1)
        {
            this.LinkButton_Next.Enabled = true;
            this.LinkButton_Up.Enabled = true;
            this.LinkButton_First.Enabled = true;
            this.LinkButton_Last.Enabled = true;
        }
        if (requestPage == 1)
        {
            this.LinkButton_First.Enabled = false;
            this.LinkButton_Up.Enabled = false;
        }
        if (requestPage == pageAmount)
        {
            this.LinkButton_Next.Enabled = false;
            this.LinkButton_Last.Enabled = false;
        }
        topicamount = recordAmount.ToString();
        this.Text_CurrentPage.Text = requestPage.ToString();
        this.Text_PageCount.Text = pageAmount.ToString();
        this.Label_Detail.Text = "页次<font color=\"red\">" + requestPage + "</font>/<font color=\"red\">" + pageAmount + "</font> 每页<font color=\"red\">30</font>条 共<font color=\"red\">" + recordAmount + "</font>条记录";
        #endregion
    }

    protected void LinkButton_Up_Click(object sender, EventArgs e)
    {
        #region 上一页
        this.LinkButton_Next.Enabled = true;
        int pageCurrent = int.Parse(this.Text_CurrentPage.Text);
        int PageAmount = int.Parse(this.Text_PageCount.Text);
        if (pageCurrent > PageAmount && PageAmount != -1)
            pageCurrent = PageAmount;
        ShowPage(pageCurrent - 1, ReturnWhere());
        #endregion
    }

    protected void LinkButton_Down_Click(object sender, EventArgs e)
    {
        #region 下一页
        this.LinkButton_Up.Enabled = true;
        this.LinkButton_First.Enabled = true;
        int pageCurrent = int.Parse(this.Text_CurrentPage.Text);
        int PageAmount = int.Parse(this.Text_PageCount.Text);
        if (pageCurrent > PageAmount && PageAmount != -1)
            pageCurrent = PageAmount;
        ShowPage(pageCurrent + 1, ReturnWhere());
        #endregion
    }
    /// <summary>
    /// 组成SQL条件
    /// </summary>
    /// <returns></returns>
    protected string ReturnWhere()
    {
        #region 拼SQL Where部分
        if (Request.QueryString["boardid"] != null && Regular.IsId(Request.QueryString["boardid"].ToString()))
        {
            boardid = int.Parse(Request.QueryString["boardid"].ToString());
            if (boardid > 2)
                return "(boardid=" + boardid + " or boardid=" + (boardid + 1) + ") and hidden=0";
            else
                return "boardid=" + Request.QueryString["boardid"].ToString() + " and hidden=0";
        }
        else
            return "boardid=1 and hidden=0";
        #endregion
    }
    /// <summary>
    /// 匹配版块名称
    /// </summary>
    protected void BoardName()
    {
        #region 匹配版块名称
        switch (boardid)
        {
            case 1:
                boardname = "玄幻奇幻";
                break;
            case 2:
                boardname = "武侠仙侠";
                break;
            case 3:
                boardname = "浪漫言情";
                break;
            case 5:
                boardname = "历史军事";
                break;
            case 7:
                boardname = "游戏竞技";
                break;
            case 9:
                boardname = "科幻灵异";
                break;
            case 11:
                boardname = "美文同人";
                break;
            case 13:
                boardname = "最新漫画";
                break;
            case 15:
                boardname = "总推荐榜";
                break;
            case 16:
                boardname = "已完成小说";
                break;
            case 17:
                boardname = "总排行榜";
                break;
            default:
                boardname = "玄幻奇幻";
                break;
        }
        #endregion
    }
    protected string BoardName(int boardid)
    {
        #region 匹配版块名称
        switch (boardid)
        {
            case 1:
                return "玄幻奇幻";
            case 2:
                return "武侠仙侠";
            case 3:
            case 4:
                return "浪漫言情";
            case 5:
            case 6:
                return "历史军事";
            case 7:
            case 8:
                return "游戏竞技";
            case 9:
            case 10:
                return "科幻灵异";
            case 11:
            case 12:
                return "美文同人";
            case 13:
                return "最新漫画";
            default:
                return "玄幻奇幻";
        }
        #endregion
    }

    protected void LinkButton_First_Click(object sender, EventArgs e)
    {
        #region 首页
        this.LinkButton_First.Enabled = false;
        this.LinkButton_Up.Enabled = false;
        ShowPage(1, ReturnWhere());
        #endregion
    }

    protected void LinkButton_Last_Click(object sender, EventArgs e)
    {
        #region 尾页
        this.LinkButton_Last.Enabled = false;
        this.LinkButton_Next.Enabled = false;
        int PageAmount = int.Parse(this.Text_PageCount.Text);
        ShowPage(PageAmount, ReturnWhere());
        #endregion
    }
    protected void Button_Look_Click(object sender, EventArgs e)
    {
        ShowPage(1, ReturnWhere());
    }
}