﻿using System;
using System.IO;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class _pagetop : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        AjaxPro.Utility.RegisterTypeForAjax(typeof(_pagetop));
        //Cookie登陆
        if (Session.Contents["username"] == null && Request.Cookies["Qiezi"] != null)
        {
            Session.Contents["username"] = Request.Cookies["Qiezi"].Value;
            Response.Cookies["Qiezi"].Value = Request.Cookies["Qiezi"].Value;
            Response.Cookies["Qiezi"].HttpOnly = false;
            Response.Cookies["Qiezi"].Expires = DateTime.Now.AddYears(1);
            SqlStore.SqlUserCookie(Request.Cookies["Qiezi"].Value);
        }
    }
    /// <summary>
    /// 用户登陆
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Button_Submit_Click(object sender, EventArgs e)
    {
        if (Session.Contents["validate"] == null)
        {
            Response.Write("<script language='javascript' type='text/javascript'>alert('" + Resources.Resource.PageTop1+ "');</script>");
            return;
        }
        string username = Request.Form["Text_User"].ToString();
        string password = Request.Form["Text_Password"].ToString();
        string validate = Request.Form["Text_Validate"].ToString();
        Md5Pw md5 = new Md5Pw();
        if (validate == Session.Contents["validate"].ToString() && SqlStore.SqlUserLogin(username, md5.Md5(password)))
        {
            if (Request.Form["Check_Box"] != null)
            {
                Response.Cookies["Qiezi"].Value = username;
                Response.Cookies["Qiezi"].HttpOnly = false;
                Response.Cookies["Qiezi"].Expires = DateTime.Now.AddYears(1);
            }
            Session.Contents["username"] = username;
            Response.Redirect(Request.Url.ToString());
        }
        else
            Response.Write("<script language='javascript' type='text/javascript'>alert('" + Resources.Resource.PageTop2 + "');</script>");
    }

    /// <summary>
    /// 推荐小说
    /// </summary>
    /// <param name="topicid">小说id</param>
    /// <returns></returns>
    [AjaxPro.AjaxMethod]
    public string Commend(int topicid)
    {
        SqlStore.SqlAjax(topicid, 1, "");
        return "true";
    }

    /// <summary>
    /// 添加Cookie书库
    /// </summary>
    /// <param name="topicid">小说id</param>
    /// <param name="title">标题</param>
    /// <returns></returns>
    [AjaxPro.AjaxMethod]
    public string AddCookie(int topicid, string title)
    {
        SqlStore.SqlAjax(topicid, 5, "");
        System.Web.HttpCookie newcookie = HttpContext.Current.Request.Cookies["topicid"];
        if (newcookie == null) newcookie = HttpContext.Current.Response.Cookies["topicid"];
        if (newcookie.Values.Count >= 50)
            return "false";
        newcookie.Values[topicid.ToString()] = HttpContext.Current.Server.UrlEncode(title);
        newcookie.Expires = DateTime.Now.AddYears(1);
        HttpContext.Current.Response.AppendCookie(newcookie);
        return "true";
    }

    /// <summary>
    /// 添加书窝
    /// </summary>
    /// <param name="topicid">小说id</param>
    /// <returns></returns>
    [AjaxPro.AjaxMethod(AjaxPro.HttpSessionStateRequirement.Read)]
    public string AddSql(int topicid)
    {
        if (System.Web.HttpContext.Current.Session["username"] == null)
            return "nologin";
        else
        {//值=101，超出100本；  值=111，该书已收藏；  值=1，添加成功
            int mark = SqlStore.SqlLikeAdd(System.Web.HttpContext.Current.Session["username"].ToString(), topicid);
            if (mark == 1)
                return "success";
            else if (mark == 101)
                return "repeate";
            else
                return "sql>100";
        }
    }
    /// <summary>
    /// 判断书窝是否有更新
    /// </summary>
    /// <returns></returns>
    [AjaxPro.AjaxMethod(AjaxPro.HttpSessionStateRequirement.Read)]
    public string AddLikeUpdate()
    {
        if (System.Web.HttpContext.Current.Session["username"] != null && SqlStore.SqlLikeUpdate(System.Web.HttpContext.Current.Session["username"].ToString()))
            return "true";
        else
            return "false";
    }
    /// <summary>
    /// 清空Cookie书库
    /// </summary>
    /// <returns></returns>
    [AjaxPro.AjaxMethod]
    public void ClearCookie()
    {
        HttpContext.Current.Response.Cookies["topicid"].Expires = DateTime.Now.AddDays(-1);
    }

    /// <summary>
    /// 添加收藏夹,收藏数加一
    /// </summary>
    /// <param name="topicid">小说id</param>
    /// <returns></returns>
    [AjaxPro.AjaxMethod]
    public void Collection(int topicid)
    {
        SqlStore.SqlAjax(topicid, 5, "");
    }

    ///// <summary>
    ///// 返回章节内容
    ///// </summary>
    ///// <param name="topicid">小说id</param>
    ///// <param name="chapterid">章节id</param>
    ///// <returns></returns>
    //[AjaxPro.AjaxMethod]
    //public string Chapter(int topicid, int chapterid)
    //{
    //    string title = "", author = "", intro = "", content = "";
    //    DataTable table = SqlStore.SqlChapterList(topicid, out title, out author, out intro);
    //    for (int i = 0; i < table.Rows.Count; i++)
    //        if (chapterid.ToString() == table.Rows[i]["chapterid"].ToString())
    //        {
    //            if (File.Exists(HttpContext.Current.Server.MapPath("chapter/" + table.Rows[i]["path"].ToString()).Replace(@"ajaxpro\", "")))
    //            {
    //                content = "<div style=\"font-size:15px; font-weight:bold; color:#FF6C00; text-align:center; margin-top:20px; margin-bottom:20px; \">" + table.Rows[i]["chapter"].ToString() + "</div>" + File.ReadAllText(HttpContext.Current.Server.MapPath("chapter/" + table.Rows[i]["path"].ToString()).Replace(@"ajaxpro\", ""), System.Text.Encoding.Default)
    //                + "<div style=\"text-align:center; margin-top:20px; margin-bottom:20px;\">" + (i == 0 ? "<span style=\"color:gray;\">上一章</span>" : "<a onclick=\"return chapter(" + topicid + "," + table.Rows[i - 1]["chapterid"].ToString() + ");\" href=\"\">上一章</a>") + "&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"novelchapter.aspx?topicid=" + topicid + "\">目录</a>&nbsp;&nbsp;&nbsp;&nbsp;" + (i + 1 == table.Rows.Count ? "<span style=\"color:gray;\">下一章</span>" : "<a onclick=\"return chapter(" + topicid + "," + table.Rows[i + 1]["chapterid"].ToString() + ");\" href=\"\">下一章</a></div>");
    //            }
    //            break;
    //        }
    //    if (content == "") content = "<div style=\"color:red;margin-top:20px; margin-bottom:20px;text-align:center;\">抱歉，未找到该章节！</div>";
    //    return content;
    //}
    ///// <summary>
    ///// 返回所有章节内容
    ///// </summary>
    ///// <param name="topicid">小说id</param>
    ///// <returns></returns>
    //[AjaxPro.AjaxMethod]
    //public string ChapterAll(int topicid)
    //{
    //    string title = "", author = "",intro="", content = "";
    //    DataTable table = SqlStore.SqlChapterList(topicid, out title, out author,out intro);
    //    for (int i = 0; i < table.Rows.Count; i++)
    //        if (File.Exists(HttpContext.Current.Server.MapPath("chapter/" + table.Rows[i]["path"].ToString()).Replace(@"ajaxpro\", "")))
    //            content += "<div style=\"font-size:15px; font-weight:bold; color:Red; text-align:center; margin-top:20px; margin-bottom:20px; \">" + table.Rows[i]["chapter"].ToString() + "</div>" + File.ReadAllText(HttpContext.Current.Server.MapPath("chapter/" + table.Rows[i]["path"].ToString()).Replace(@"ajaxpro\", ""), System.Text.Encoding.Default);
    //    if (content == "") content = "<div style=\"color:red;margin-top:20px; margin-bottom:20px;text-align:center;\">抱歉，未找到该小说！</div>";
    //    return content;
    //}

    /// <summary>
    /// 搜索
    /// </summary>
    /// <param name="key">搜索关键字</param>
    /// <param name="type">搜索类别</param>
    /// <param name="search">1:精确搜索；0模糊搜索</param>
    /// <returns></returns>
    [AjaxPro.AjaxMethod]
    public string Search(string key, string type, int search)
    {
        string content = "";
        if (key != "" && (type == "novel" || type == "author"))
        {
            DataTable table = SqlStore.SqlSearch(key.Trim(), type == "novel" ? true : false,search==1);
            if (table.Rows.Count == 0)
            {
                SqlStore.SqlSearchKeys(key);
                content = "<br><span style=\"color:red;text-align:center;\">抱歉，本站暂未收录该书！</span><br><span style=\"color:green;text-align:center;\">我们已经记录您的搜索内容，并尽量在一天内收录该书！（如果您搜索时没有输入完整书名，请输入完整书名后再次搜索，以便本站明确收录何书，感谢您的支持）</span><br><br>";
            }
            for (int i = 0; i < table.Rows.Count; i++)
                content += "<div style=\"color:black;\"><a href=\"novelintro.aspx?topicid=" + table.Rows[i]["topicid"].ToString() + "\" style=\"color:#004D00;\" target=\"_blank\">" + table.Rows[i]["title"].ToString() + "</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[&nbsp;&nbsp;&nbsp;&nbsp;"
                        + table.Rows[i]["author"].ToString() + "&nbsp;&nbsp;|&nbsp;&nbsp;"
                        + "<span style=\"color:#004D00;\">" + table.Rows[i]["name"].ToString() + "</span>&nbsp;&nbsp;|&nbsp;&nbsp;"
                        + "<a href=\"viewchapter.aspx?topicid=" + table.Rows[i]["topicid"].ToString() + "&chapterid=" + table.Rows[i]["newchapter"].ToString().Split('|')[1] + "\" style=\"color:#ff9c00;\" target=\"_blank\">" + table.Rows[i]["newchapter"].ToString().Split('|')[0] + "</a>&nbsp;&nbsp;|&nbsp;&nbsp;"
                        + table.Rows[i]["updatetime"].ToString() + "更新&nbsp;&nbsp;&nbsp;&nbsp;"
                        + "]</div><div style=\"margin-top:10px;margin-left:20px;color:gray;\">"
                        + table.Rows[i]["intro"].ToString()
                        + "</div><hr style=\"color:green; height:1px;\" />";
        }
        else
            content = "<div style=\"color:red;margin-top:20px; margin-bottom:20px;text-align:center;\">抱歉，您输入有误！</div>";
        return content;
    }
}