﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class system_project : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request.QueryString["operate"] != null)
        {
            lock (typeof(system_project))
            {
                switch ((string)Request.QueryString["operate"])
                {
                    case "download":
                        AddDownload();
                        Response.Redirect("project.rar");
                        break;
                    case "view":
                        AddView();
                        Response.End();
                        break;
                    case "comment":
                        AddComment();
                        Response.Redirect("project.xml");
                        break;
                    case "suggest":
                        AddSuggest();
                        Response.Redirect("suggest.xml");
                        break;
                }
            }
        }
    }
    protected void AddDownload()
    {
        DataSet dataset = new DataSet();
        string path = this.Server.MapPath("project.xml");
        dataset.ReadXml(path);
        dataset.Tables["info"].Rows[0]["download"] = int.Parse(dataset.Tables["info"].Rows[0]["download"].ToString()) + 1;//文件下载次数
        System.Xml.XmlTextWriter xtw = new System.Xml.XmlTextWriter(path, null);
        xtw.WriteProcessingInstruction("xml", "version='1.0' encoding='UTF-8'");
        xtw.WriteProcessingInstruction("xml-stylesheet", "type='text/xsl' href='project.xsl'");
        dataset.WriteXml(xtw);
        xtw.Flush();
        xtw.Close();
    }
    protected void AddView()
    {
        DataSet dataset = new DataSet();
        string path = this.Server.MapPath("project.xml");
        dataset.ReadXml(path);
        dataset.Tables["info"].Rows[0]["view"] = int.Parse(dataset.Tables["info"].Rows[0]["view"].ToString()) + 1;//页面浏览次数
        System.Xml.XmlTextWriter xtw = new System.Xml.XmlTextWriter(path, null);
        xtw.WriteProcessingInstruction("xml", "version='1.0' encoding='UTF-8'");
        xtw.WriteProcessingInstruction("xml-stylesheet", "type='text/xsl' href='project.xsl'");
        dataset.WriteXml(xtw);
        xtw.Flush();
        xtw.Close();
    }
    protected void AddComment()
    {
        if (Request.Form["Text_Sender"] == null || Request.Form["Text_Content"] == null) return;
        DataSet dataset = new DataSet();
        string path = this.Server.MapPath("project.xml");
        dataset.ReadXml(path);
        if (dataset.Tables["comment"] == null)//评论表若不存在则添加该表
        {
            dataset.Tables.Add("comment");
            dataset.Tables["comment"].Columns.Add("sender");//评论者
            dataset.Tables["comment"].Columns.Add("time");//发表时间
            dataset.Tables["comment"].Columns.Add("content");//内容
        }
        dataset.Tables["comment"].Rows.Add(new string[3] { Regular.Filtrate(Request.Form["Text_Sender"].ToString()) + "(" + Request.UserHostAddress + ")", DateTime.Now.ToString(),Regular.Filtrate(Request.Form["Text_Content"].ToString()) });//新增评论
        System.Xml.XmlTextWriter xtw = new System.Xml.XmlTextWriter(path, null);
        xtw.WriteProcessingInstruction("xml", "version='1.0' encoding='UTF-8'");
        xtw.WriteProcessingInstruction("xml-stylesheet", "type='text/xsl' href='project.xsl'");
        dataset.WriteXml(xtw);
        xtw.Flush();
        xtw.Close();
    }
    protected void AddSuggest()
    {
        if (Request.Form["Text_Sender"] == null || Request.Form["Text_Content"] == null) return;
        DataSet dataset = new DataSet();
        string path = this.Server.MapPath("suggest.xml");
        dataset.ReadXml(path);
        if (dataset.Tables["suggest"] == null)//评论表若不存在则添加该表
        {
            dataset.Tables.Add("suggest");
            dataset.Tables["suggest"].Columns.Add("sender");//评论者
            dataset.Tables["suggest"].Columns.Add("time");//发表时间
            dataset.Tables["suggest"].Columns.Add("content");//内容
        }
        dataset.Tables["suggest"].Rows.Add(new string[3] { Regular.Filtrate(Request.Form["Text_Sender"].ToString()) + "(" + Request.UserHostAddress + ")", DateTime.Now.ToString(), Regular.Filtrate(Request.Form["Text_Content"].ToString()) });//新增评论
        System.Xml.XmlTextWriter xtw = new System.Xml.XmlTextWriter(path, null);
        xtw.WriteProcessingInstruction("xml", "version='1.0' encoding='UTF-8'");
        xtw.WriteProcessingInstruction("xml-stylesheet", "type='text/xsl' href='suggest.xsl'");
        dataset.WriteXml(xtw);
        xtw.Flush();
        xtw.Close();
    }
}
