﻿using System;
using System.Text;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using Winson.EntityOP;
using Winson.EntityOP.Entity;
using Winson.Framework.Utility;

public partial class Data_add : System.Web.UI.Page
{
    Test test;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!String.IsNullOrEmpty(Request["Action"]))
            {
                switch (Request["Action"].Trim().ToLower())
                {
                    case "add":
                        Add();
                        break;
                    case "addbatch":
                        AddBatch();
                        break;
                }
            }
        }
    }

    private void Add()
    {
        try
        {
            test = new Test();
            test.Entity.Name = String.IsNullOrEmpty(Request["Name"]) ? "" : Request["Name"];
            test.Entity.Age = String.IsNullOrEmpty(Request["Age"]) ? 0 : Convert.ToInt32(Request["Age"]);
            test.Entity.Context = String.IsNullOrEmpty(Request["Context"]) ? "" : Request["Context"];
            if (!String.IsNullOrEmpty(Request["IsUse"]))
                test.Entity.Isuse = Convert.ToBoolean(Request["IsUse"]);

            if (!String.IsNullOrEmpty(Request["Pic"]))
            {
                byte[] pic = Utility.ReadFile(@"" + Request["Pic"]);
                test.Entity.Pic = pic;
            }
            if (test.Add() > 0)
                ReturnResult("1");
            else
                ReturnResult("0");
        }
        catch (Exception e)
        {
            ReturnResult("0");
        }
    }

    private void AddBatch()
    {
        try
        {
            test = new Test();
            int count = String.IsNullOrEmpty(Request["Count"]) ? 1 : Convert.ToInt32(Request["Count"]);

            for (int i = 0; i < count; i++)
            {
                test.Entity.Name = String.IsNullOrEmpty(Request["Name"]) ? "" : Request["Name"];
                test.Entity.Age = String.IsNullOrEmpty(Request["Age"]) ? 0 : Convert.ToInt32(Request["Age"]);
                test.Entity.Context = String.IsNullOrEmpty(Request["Context"]) ? "" : Request["Context"];
                if (!String.IsNullOrEmpty(Request["Pic"]))
                {
                    byte[] pic = Utility.ReadFile(@"" + Request["Pic"]);
                    test.Entity.Pic = pic;
                }
                //上面的第一次不用创建，从第二个实体开始就需要创建新实体了
                test.AppendEntity();
                test.CreateEntity();
            }
            if (test.AddBatch())
                ReturnResult("1");
            else
                ReturnResult("0");
        }
        catch (Exception e)
        {
            ReturnResult("0");
        }
    }


    private void ReturnResult(string str)
    {
        Response.Write(str);
        Response.End();
    }
}
