﻿<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="Data_delete.aspx.cs" Inherits="Data_delete" %>

<asp:Content ID="Content1" ContentPlaceHolderID="Head" Runat="Server">
<title>Winson.Framework功能演示_删除数据</title>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="Title" Runat="Server">
<h2>删除数据演示</h2>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">

<h5>一、基本说明：</h5>

<p>    要向数据库里插入一条或者多条记录，在Winson.Framework3.0里此操作已变得非常轻松！<br /><br />
       在删除操作中，主要分以下3种方式：<br /><br />
       <b>1、以实体主键删除：</b><br />
       &#160;&#160;此方法适合删除单个记录，只需在为实体赋值时，同时指定实体主键的值，即会自动以此主键进行删除。<br /><br />
       <b>2、以自定义条件删除：</b><br />
       &#160;&#160;在调用删除方法时，可以输入以　<span class="comment"><b>NameValueCollection</b></span>　对象创建的条件，具体的条件创建说明，可查看 <a href="Data_select.aspx">查询数据</a> 演示。<br /><br />
        <b>3、批量删除：</b><br />
       &#160;&#160;此方法可以一次性删除多条实体记录，每条记录均要以实体主键进行删除，因此必须为每个实体类设置期主键值，然后即可以一个实体集合形式进行一次性删除。<br /><br />
<h5>二、操作步骤：</h5>
<P class="comment">注：以下演示均以WinsonFrameDB数据库的 Test 表为例:</P>
<p><h4>1、以实体主键删除：</h4><br />
操作步骤如下：<br /><br />
 a.引用以下命名空间：
<pre>
<code class="csharp">using Winson.EntityOP;</code></pre>

b.实例化一个实体操作类，此实体操作类已包括了实体类和所有相关的操作方法：
<pre><code class="csharp">Test test = new Test();</code></pre>

c.为实体赋值，其中 <span class="comment">Entity</span> 为实体类属性，所有实体操作类里都可通过此属性直接调用其实体里所有成员属性：
<pre><code class="csharp">
//以下代码将会删除Id等于1的记录
test.Entity.Id = 1;//必须为其主键赋值
</code></pre>

d.调用删除的方法，向数据库进行删除操作，此方法返回影响的记录行数：
<pre><code class="csharp">test.Delete();</code></pre>

e.完整的代码如下：
<pre><code class="csharp">
Test test = new Test();
test.Entity.Id = 1;//必须为其主键赋值
if (test.Delete() > 0 ) //判断是否添加成功
    Response.Write("success");
else
    Response.Write("fail");
</code></pre>


<p><h4>2、自定义条件删除：</h4><br />
a.此方法不需指定主键，甚至如果需要的话，可以连主键一起删除，不过一般不建议去删除主键啦，只需设置好条件对象即可：
<pre><code class="csharp">
using Winson.EntityOP;
//使用NameValueCollection必需先引用以下命名空间
using System.Collections.Specialized;

//创建查询条件对象
NameValueCollection conditionValue = new NameValueCollection();

conditionValue["Name like"] = "winson";//删除Name里包括winson里记录

//创建实体操作类
Test test = new Test();
</code></pre>

b.调用删除的方法，向数据库进行删除操作，此方法返回影响的记录行数：
<pre><code class="csharp">test.Delete(conditionValue);</code></pre>


c.完整的代码如下：
<pre><code class="csharp">
using Winson.EntityOP;
//使用NameValueCollection必需先引用以下命名空间
using System.Collections.Specialized;

//创建查询条件对象
NameValueCollection conditionValue = new NameValueCollection();

conditionValue["Name like"] = "winson";//删除Name里包括winson里记录

//创建实体操作类
Test test = new Test();
if (test.Delete(conditionValue) > 0 ) //判断是否添加成功
    Response.Write("success");
else
    Response.Write("fail");
</code></pre>

<p><h4>3、批量删除：</h4><br />
批量删除步骤 a-c 与单实体主键删除操作一样，从 d 步骤开始要创建一个新实体，同时添加到集合里，以下步骤从 d 开始：<br /><br />
d.需将以上实体添加到集合里，然后再创建另一个新实体，为新实体赋值，不断重复此步骤即可添加多个实体了：
<pre><code class="csharp">
test.AppendEntity(); //将第一个实体追加到实体集合里
test.CreateEntity(); //创建另一个新实体
//为新实体赋值
//每个实体均要设置好其主键
test.Entity.Id = 2;
test.AppendEntity(); //将新实体再追加到实体集合里
</code></pre>

e.调用批量删除的方法，向数据库进行删除操作，此方法返回一个布尔值，成功为True，否则为False：
<pre><code class="csharp">test.DeleteBatch();</code></pre>


f.完整的代码如下：
<pre><code class="csharp">
Test test = new Test();
test.Entity.Id = 1;
test.AppendEntity(); //将第一个实体追加到实体集合里
test.CreateEntity(); //创建另一个新实体
//为新实体赋值
test.Entity.Id = 2;
test.AppendEntity(); //将新实体再追加到实体集合里
if (test.DeleteBatch()) //判断是否删除成功
    Response.Write("success");
else
    Response.Write("fail");
</code></pre>

<h5>三、效果演示：</h5>

<p><h4>1、以实体主键删除：</h4><br />

<div id="DeleteOne">

<ul style="height: 30px;"> <li><a href="#DeleteOne-1"><span>　演　示　</span></a></li> <li><a href="#DeleteOne-2"><span>　源　码　</span></a></li>  <li><a href="#DeleteOne-3"><span>　查 询　</span></a></li>

</ul> 

<div id="DeleteOne-1">
<span class="comment">请输入要删除的记录ID</span><br />
ID：<input ID="TestId" Class="input" /><br />
<br /><br />
<Button ID="TestDelete" class="btn_mouseout" onmouseover="this.className='btn_mouseover'"
onmouseout="this.className='btn_mouseout'" onmousedown="this.className='btn_mousedown'"
    onmouseup="this.className='btn_mouseup'">&nbsp;&nbsp;删&nbsp;&nbsp;&nbsp;&nbsp;除&nbsp;&nbsp;</Button>
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
  
 </div> 
 
<div id="DeleteOne-2"> 

<pre><code class="csharp">
private void Delete()
{
    test = new Test();
    test.Entity.Id = String.IsNullOrEmpty(Request["ID"]) ? 1 : Convert.ToInt32(Request["ID"]);

    if (test.Delete() > 0)
        ReturnResult("1");
    else
        ReturnResult("0");
}
</code></pre>

 </div> 
 
 <div id="DeleteOne-3"> 
</div>

</div>


<p><h4>2、批量删除实体到数据库：</h4><br />

<div id="DeleteBatch">

<ul style="height: 30px;"> <li><a href="#DeleteBatch-1"><span>　演　示　</span></a></li> <li><a href="#DeleteBatch-2"><span>　源　码　</span></a></li>  <li><a href="#DeleteBatch-3"><span>　查 询　</span></a></li> 

</ul> 

<div id="DeleteBatch-1">
<span class="comment">请输入要删除的多个ID，以逗号隔开，必须是已存在的ID，否则只要有一个删除不了，均会全部Rollback了</span><br />
ID：<input ID="BTestId" Class="input" value="1,2,3,4"/><br />
<br /><br />
<Button ID="TestDeleteBatch" class="btn_mouseout" onmouseover="this.className='btn_mouseover'"
onmouseout="this.className='btn_mouseout'" onmousedown="this.className='btn_mousedown'"
    onmouseup="this.className='btn_mouseup'">&nbsp;&nbsp;批量删除&nbsp;&nbsp;</Button>
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 </div>
    
<div id="DeleteBatch-2"> 

<pre><code class="csharp">
private void DeleteBatch()
{
	try
	{
		test = new Test();
		string[] id = String.IsNullOrEmpty(Request["Id"]) ? "" : Request["Id"].Split(",");

		for (int i = 0; i < id.Length; i++)
		{
		    test.Entity.Id = Convert.ToInt32(id[i]);
		    //上面的第一次不用创建，从第二个实体开始就需要创建新实体了
		    test.AppendEntity();
		    test.CreateEntity();
		}
		if (test.DeleteBatch())
		    ReturnResult("1");
		else
		    ReturnResult("0");
	}
	catch (Exception e)
	{            
		ReturnResult("0");
	}
}
</code></pre>

 </div> 

<div id="DeleteBatch-3">  
</div>

</div>

</asp:Content>

