﻿<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="Data_select.aspx.cs" Inherits="Data_select" %>



<asp:Content ID="Content1" ContentPlaceHolderID="Head" Runat="Server">
<title>Winson.Framework功能演示_查询数据</title>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="Title" Runat="Server">
<h2>查询数据演示</h2>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">

<h5>一、基本说明：</h5>

<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;查询操作均以实体为主，如需查询多条记录，将会返回一个实体集合！现本框架已支持非常灵活的查询，所用到的查询条件，均使用　<span class="comment"><b>NameValueCollection</b></span>　对象的键值对来传递，在使用　<span class="comment"><b>NameValueCollection</b></span>　对象创建查询条件时，可以有三种参数形式：<br /><br />
<b>1.直接设置某字段为查询条件：</b><br />
&nbsp;&nbsp;&nbsp;&nbsp;可以直接设置要查询的字段和条件值
<pre><code class="csharp">
//使用NameValueCollection必需先引用以下命名空间
using System.Collections.Specialized;

//创建查询条件对象
NameValueCollection conditionValue = new NameValueCollection();

//对于字段条件，也可以直接加上SQL的条件运算符，
//字段与运算符之间必须以空格隔开，如下
conditionValue["Name like"] = "winson";//查询Name里包括winson里记录
conditionValue["Age >"] = "20";        //查询Age大于20的记录
conditionValue["ID <="] = "5";         //查询ID小于等于5的记录

//实现左右模糊查询
conditionValue["Name like left"] = "winson";
//实现左模糊查询，相当于 Name like '%winson' 语句
conditionValue["Name like left"] = "winson";
//实现右模糊查询，相当于 Name like 'winson%' 语句


//也可以直接为字段设置查询条件，如不加运算符则为等于运算
conditionValue["Name"] = "winson";

//创建实体操作类
Test test = new Test();

//将条件对象传入直接获取查询结果，多个条件将会以　And　方式为条件查询
IList t=test.GetList(conditionValue);
</code></pre>

<br /><br />
<b>2.使用自定义查询条件：</b><br />
&nbsp;&nbsp;&nbsp;&nbsp;为了让大家创建更灵活的查询条件，只要将　<span class="comment"><b>NameValueCollection</b></span>　对象的键值设置为　<span class="comment"><b>where</b></span>　即可输入任意组合的查询条件，条件值里不需要再输入　<span class="comment"><b>where</b></span>　关键字了
<pre><code class="csharp">
//使用NameValueCollection必需先引用以下命名空间
using System.Collections.Specialized;

//创建查询条件对象
NameValueCollection conditionValue = new NameValueCollection();

//只要键值为 where 则可以输入任意查询条件，甚至可以加上排序条件
conditionValue["where"] = " name = 'winson' or id > 3 order by id desc";

//创建实体操作类
Test test = new Test();

//将条件对象传入直接获取查询结果
IList t=test.GetList(conditionValue);
</code></pre>

<br /><br />
<b>3.使用自定义SQL语句：</b><br />
&nbsp;&nbsp;&nbsp;&nbsp;可以直接输入完整的SQL语句。其实这个功能主要是为了分页查询使用，一般情况下不需要直接输入完整的SQL语句了，因为上面提到的2种方式已基本上都够用了。只要将　<span class="comment"><b>NameValueCollection</b></span>　对象的键值设置为　<span class="comment"><b>sql</b></span>　即可输入完整的SQL语句
<pre><code class="csharp">
//使用NameValueCollection必需先引用以下命名空间
using System.Collections.Specialized;

//创建查询条件对象
NameValueCollection conditionValue = new NameValueCollection();

//只要键值为 sql 则可以输入完整的SQL语句
conditionValue["sql"] = "select * from test where name = 'winson' order by id desc";

//创建实体操作类
Test test = new Test();

//将条件对象传入直接获取查询结果
IList t=test.GetList(conditionValue);
</code></pre>
<br /><br />
<b>4.使用 <span class="comment"><b>in</b></span> 和 <span class="comment"><b>order</b></span> 语句：</b><br />
&nbsp;&nbsp;&nbsp;&nbsp;可以直接使用 <span class="comment"><b>in</b></span> 和 <span class="comment"><b>order</b></span> 语句进行查询，方法也很简单，请看以下代码：
<pre><code class="csharp">
//使用NameValueCollection必需先引用以下命名空间
using System.Collections.Specialized;

//创建查询条件对象
NameValueCollection conditionValue = new NameValueCollection();

//只要键值里包含了 in 则可以以 in 语句进行查询
conditionValue["id in"] = "1,2,3,4,5";

//将键值设为 order 则可以进行排序查询，当然，排序方式也需要指定在条件里
conditionValue["order"] = "id desc";

//创建实体操作类
Test test = new Test();

//将条件对象传入直接获取查询结果
IList t=test.GetList(conditionValue);
</code></pre>
<br /><br />
<b>5.使用 <span class="comment"><b>or</b></span> 和 <span class="comment"><b>and</b></span> 条件：(<font color=red>3.3新功能</font>)</b><br />
&nbsp;&nbsp;&nbsp;&nbsp;3.3版开始，即可以支持 <span class="comment"><b>or</b></span> 和 <span class="comment"><b>and</b></span> 条件交互进行查询(之前全部默认为 <span class="comment"><b>and</b></span> 条件)，方法也很简单，请看以下代码：
<pre><code class="csharp">
//实现 or 条件操作符
//在需要 or 的2个条件之前添加以下语句
conditionValue["operator"] = "or";
//然后接着写需要匹配的条件
conditionValue["Title like"] = "title";
conditionValue["Content like"] = "content";
conditionValue["Name"] = "winson";
//注意：每个 or 条件只会匹配紧接着的2个条件，以上语句将产生以下的SQL语句:
// Title like '%title%' or Content like '%content%' and name='winson'
//从第三个条件起，如果没有设置 conditionValue["operator"] 条件，将自动恢复为 and 条件
</code></pre>
       </p>
<h5>二、操作步骤：</h5>
<P class="comment">注：以下演示均以WinsonFrameDB数据库的 Test 表为例:</P>
<p><h4>1、获取单个实体查询：</h4><br />
操作步骤如下：<br /><br />
 a.引用以下命名空间：
<pre>
<code class="csharp">
using System.Collections.Specialized;
using Winson.EntityOP;
</code></pre>

b.实例化一个实体操作类，此实体操作类已包括了实体类和所有相关的操作方法：
<pre><code class="csharp">Test test = new Test();</code></pre>

c.创建查询条件：
<pre><code class="csharp">
//创建查询条件对象
NameValueCollection conditionValue = new NameValueCollection();

//对于字段条件，也可以直接加上SQL的条件运算符，
//字段与运算符之间必须以空格隔开，如下
conditionValue["Name like"] = "winson";//查询Name里包括winson里记录
conditionValue["Age >"] = "20";        //查询Age大于20的记录
conditionValue["ID <="] = "5";         //查询ID小于等于5的记录

//也可以直接为字段设置查询条件，如不加运算符则为等于运算
conditionValue["Name"] = "winson";
</code></pre>

d.调用查询的方法：
<pre><code class="csharp">
//此方法有2个重载
//直接从数据库获取实体
TestDS t = test.GetEntity(conditionValue);

//从实体集合里获取
//先得到一个实体集合
IList entityList = test.GetList(null);//参数为null则获取所有实体记录
TestDS t = test.GetEntity(entityList, 3);//然后在集合里获取ID为3的记录
</code></pre>

e.完整的代码如下：
<pre><code class="csharp">
//创建查询条件对象
NameValueCollection conditionValue = new NameValueCollection();

//对于字段条件，也可以直接加上SQL的条件运算符，
//字段与运算符之间必须以空格隔开，如下
conditionValue["Name like"] = "winson";//查询Name里包括winson里记录
conditionValue["Age >"] = "20";        //查询Age大于20的记录
conditionValue["ID <="] = "5";         //查询ID小于等于5的记录

//也可以直接为字段设置查询条件，如不加运算符则为等于运算
conditionValue["Name"] = "winson";

//此方法有2个重载
//直接从数据库获取实体
TestDS t = test.GetEntity(conditionValue);

//从实体集合里获取
//先得到一个实体集合
IList entityList = test.GetList(null);//参数为null则获取所有实体记录
TestDS t = test.GetEntity(entityList, 3);//然后在集合里获取ID为3的记录
</code></pre>


<p><h4>2、获取实体集合：</h4><br />
获取实体集合步骤基本上与获取单实体步骤一样，只是最后调用的方法不同：
<pre><code class="csharp">
//以下是获取实体集合的几种方式
IList entityList = test.GetList(null);//参数为null则获取所有实体记录

IList entityList = test.GetList(conditionValue);//参数为conditionValue则根据条件获取

//同时还支持获取DataSet数据
DataSet entityDS = test.GetDataSet(null);
DataSet entityDS = test.GetDataSet(conditionValue);
</code></pre>

如需分页获取数据，可使用以下方法，此方法的查询条件只能直接输入相关SQL语句，不支持 <span class="comment">NameValueCollection</span> 的构建：
<pre><code class="csharp">
IList LTest = test.GetList(limit, page, criteria, orderby, order);
</code></pre>
参数说明：<br />
<span class="comment">limit</span> 每页显示记录数<br />
<span class="comment">page</span> 当前页<br />
<span class="comment">criteria</span> 查询条件，如： " name='wnson' and age>20 "<br />
<span class="comment">orderby</span> 排序字段<br />
<span class="comment">order</span> 排序方式<br />

<p><h4>3、将数据库里的图片文件读出：</h4><br />
在此也说一下如何从数据库里读出图片等二进制文件：
<pre><code class="csharp">
//引用命名空间
using Winson.Framework.Utility;

//从数据库获取实体
TestDS t = test.GetEntity(conditionValue);
//将图片字段取出
byte[] bytes = t.Pic;
//将二进制数据写到文件
Utility.writeFile(b, @"d:\temp\test.png");
</code></pre>


<h5>三、效果演示：</h5>

<p><h4>获取实体：</h4><br />

<div id="SelectEntity">

<ul style="height: 30px;"> <li><a href="#SelectEntity-1"><span>　演　示　</span></a></li> <li><a href="#SelectEntity-2"><span>　源　码　</span></a></li>

</ul> 

<div id="SelectEntity-1">
请输入以下查询字段的条件，如为空时则不限制，所有字段将以 <span class="comment">And</span> 形式连接<br /><br />
姓名：<input ID="TestName" Class="input" /><br />
年龄：<input ID="TestAge" Class="input"/><br />
内容：<input ID="TestContext" Class="input"/>
<br /><br />
<Button ID="TestSelect" class="btn_mouseout" onmouseover="this.className='btn_mouseover'"
onmouseout="this.className='btn_mouseout'" onmousedown="this.className='btn_mousedown'"
    onmouseup="this.className='btn_mouseup'">&nbsp;&nbsp;查&nbsp;&nbsp;&nbsp;&nbsp;询&nbsp;&nbsp;</Button>
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
  <br /><br />
  
   <div id="SelectResult"> 
    </div>
 </div> 
 
<div id="SelectEntity-2"> 
由于此DEMO由于调用jqGrid(jQuery的插件)显示，因此并没用到 <span class="comment">NameValueCollection</span> 来构建查询条件，以下只例出主要代码
<pre><code class="csharp">
//获取分页数据
int totalpage = 0;
int page = Convert.ToInt32(Request["page"]);
int limit = Convert.ToInt32(Request["rows"]);
string orderby = Request["sidx"].Split('|')[0];
string criteria = Request["sidx"].Split('|')[1].Replace("+", " ");
string order = Request["sord"];

test = new Test();
//根据条件获取记录数
int totalCount = test.Count(criteria);
//获取实体集合
IList LTest = test.GetList(limit, page, criteria, orderby, order);
</code></pre>

 </div> 
 


</div>
</asp:Content>

