﻿<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="Dialog.aspx.cs" Inherits="DialogDemo"  %>
<asp:Content ID="Content1" ContentPlaceHolderID="Head" Runat="Server">
   <title>Winson.Framework_对话框的使用</title>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="Title" Runat="Server">
   <h2>对话框的使用</h2>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
 <h5>一、基本说明：</h5>
<p>
    在3.0版里，已整合了jQuery UI里的对话框控件，现在大家可以直接使用C#语法去调用jQuery里的对话框，可灵活设置所有属性，也可自行更改不同的skin
 <br /><br />
  <h5>二、属性说明：</h5>
<div class="detail">
<ul>

<li><span class="parm">Title:</span>对话框标题</li>
<li><span class="parm">ShowType:</span>对话框类型,分别为DialogType.Alert(默认)和DialogType.Confirm</li>
<li><span class="parm">Css:</span>CSS名称,默认为flora</li>
<li><span class="parm">Opacity:</span>背景透明度,默认为0.5</li>
<li><span class="parm">OkButton:</span>确定按钮文本,默认为'OK'</li>
<li><span class="parm">CancelButton:</span>取消按钮文本,默认为'Cancel'</li>
<li><span class="parm">Width:</span>对话框宽度,默认为300</li>
<li><span class="parm">Height:</span>对话框高度,默认为200</li>
<li><span class="parm">MinWidth:</span>对话框最小收缩宽度,默认为250</li>
<li><span class="parm">MinHeight:</span>对话框最小收缩高度,默认为150</li>
<li><span class="parm">Model:</span>是否使用模式对话框,默认为true</li>
<li><span class="parm">Resizable:</span>是否允许扡动对话框,默认为true</li>
<li><span class="parm">OkEvent:</span>确定按钮事件,以JS语法实现,默认关闭对话框</li>
<li><span class="parm">CancelEvent:</span>取消按钮事件,以JS语法实现,默认关闭对话框</li>
<li><span class="parm">ConfirmOK:</span>'为元素添加确认对话框'时的确定按钮文本</li>
<li><span class="parm">ConfirmCancel:</span>'为元素添加确认对话框'时的取消按钮文本</li>
<li><span class="parm">ConfirmOKEvent:</span>'为元素添加确认对话框'时的确定按钮事件,JS语法实现,默认为关闭对话框</li>
<li><span class="parm">ConfirmCancelEvent:</span>'为元素添加确认对话框'时的取消按钮事件,JS语法实现,默认为关闭对话框</li>
</ul>
</div>
  
    <h5>三、使用说明：</h5>
    此对话框可分三种形式调用:<br /><br />
    
   <b> 1.直接调用: </b><br /><br />
    
 只需实例化一个Dialog对象,然后为其设置相应的属性,调用ShowMsgBox方法即可,代码如下:
  <pre><code class="csharp">
//引用命名空间
using Winson.Framework.Controls;

//实体化对话框
Dialog dialog = new Dialog(this);
//设置各种属性
dialog.Title = Title.Text;
if (IsResizable.SelectedValue.Equals("1"))
	dialog.Resizable = true;
else
	dialog.Resizable = false;
if (IsModel.SelectedValue.Equals("1"))
	dialog.Modal = true;
else
	dialog.Modal = false;
if (DaType.SelectedValue.Equals("1"))
	dialog.ShowType = DialogType.Alert;
else
	dialog.ShowType = DialogType.Confirm;
//显示对话框
dialog.ShowMsgBox(Content.Text);
</code></pre>  

 <b>2.为页面元素添加确认对话框: </b><br /><br />
此方法可为页面一元素(如一个按钮)添加JS方式的确认对话框,代码如下:<br />
 前台HTML代码:
 <pre><code class="html">
 点击以下按钮:
 &lt;Input Type="Button" Name="TestButton01" value="  Test "&gt;
</code></pre>

 后台代码:
 <pre><code class="csharp">
Dialog dialog = new Dialog(this);
dialog.Title = "添加确认对话框测试";
dialog.ShowType = DialogType.Confirm;
dialog.ConfirmOK = " 确定 ";
dialog.ConfirmCancel = " 取消 ";

//指定要显示的信息
//指定要附加的元素(如input,div,a....)
//指定元素的name属性,如 "TestButton01"
dialog.AddConfirmBox("你确定要这样做吗?","input", "TestButton01");

//因此,此方法会为页面所有相同name的元素添加同一个对话框
</code></pre>
 
  <b>3.为页面元素添加确认对话框,同时可指定跳转的页面及添加参数<span class="comment">(只能跳转到相同的页面)</span>: </b><br /><br />
此方法是为了在列表里添加多个确定对话框时使用的,如每一行一个连接,然后点此连接后再跳转到相应的页面,然后根据传递的参数去做不同的事情,此方法已支持URL重写的跳转页面,只需在web.config里设置相关的UrlRewrite参数即可,代码如下:<br />

<br />
 前台HTML代码:
 <pre><code class="html">
以下有多个按钮,每个将指向同一个URL,但所传递的参数是不同的,参数使用para属性来传递,当然此属性可由你自定义的:
 &lt;Input Type="Button" Name="TestButton02" value="  Test "  para="pa01"&gt;
 &lt;Input Type="Button" Name="TestButton02" value="  Test "  para="pa02"&gt;
 &lt;Input Type="Button" Name="TestButton02" value="  Test "  para="pa03"&gt;
 &lt;Input Type="Button" Name="TestButton02" value="  Test "  para="pa04"&gt;
 &lt;Input Type="Button" Name="TestButton02" value="  Test "  para="pa05"&gt;
</code></pre>
 后台代码:
 <pre><code class="csharp">
Dialog dialog = new Dialog(this);
dialog.Title = "添加确认对话框测试";
dialog.ShowType = DialogType.Confirm;
dialog.ConfirmOK = " 确定 ";
dialog.ConfirmCancel = " 取消 ";

//指定要显示的信息
//指定要附加的元素(如input,div,a....)
//指定元素的name属性,如 "TestButton02"
//指定要跳转的页面名称,如 "Dialog" 即本页面,不需加后缀名,因为会自动判断有无使用URLRewrite
//指定要传递的参数属性名称, 如"para"
dialog.AddConfirmBox("你确定要这样做吗?","input", "TestButton02", "Dialog", "para");
</code></pre>
 
 <form id="form1" runat="server"> 
<h5>四、效果演示：</h5>

   <b> 1.直接调用: </b>
<div id="Dialog1">

<ul style="height: 30px;"> <li><a href="#Dialog1-1"><span>　演　示　</span></a></li> <li><a href="#Dialog1-2"><span>　源　码　</span></a></li>  

</ul> 

<div id="Dialog1-1">
以下是消息对话框显示,可输入以下参数以查看不同效果:
<br /><br />

对话框标题:<asp:TextBox ID="Title" runat ="server" Text="对话框测试"></asp:TextBox><br /><br />
对话框内容:<asp:TextBox ID="Content" runat ="server" Text="测试一下"></asp:TextBox><br /><br />
是否可伸缩:<asp:RadioButtonList ID="IsResizable" runat="server" RepeatDirection=Horizontal>
<asp:ListItem Selected="True" Value="1">是</asp:ListItem>
<asp:ListItem  Value="0">否</asp:ListItem>
    </asp:RadioButtonList>
    <br />
是否模式对话框:<asp:RadioButtonList ID="IsModel" runat="server" RepeatDirection=Horizontal>
<asp:ListItem Selected="True" Value="1">是</asp:ListItem>
<asp:ListItem  Value="0">否</asp:ListItem>
    </asp:RadioButtonList><br />
对话框类型:<asp:RadioButtonList ID="DaType" runat="server" RepeatDirection=Horizontal>
<asp:ListItem Selected="True" Value="1">消息框</asp:ListItem>
<asp:ListItem  Value="0">确认框</asp:ListItem>
    </asp:RadioButtonList><br />
<asp:Button ID="ShowBase" runat="server" Text="显示对话框" onclick="ShowBase_Click"  />
 </div> 
 
<div id="Dialog1-2"> 

<pre><code class="csharp">
//引用命名空间
using Winson.Framework.Controls;

//实体化对话框
Dialog dialog = new Dialog(this);
//设置各种属性
dialog.Title = Title.Text;
if (IsResizable.SelectedValue.Equals("1"))
	dialog.Resizable = true;
else
	dialog.Resizable = false;
if (IsModel.SelectedValue.Equals("1"))
	dialog.Modal = true;
else
	dialog.Modal = false;
if (DaType.SelectedValue.Equals("1"))
	dialog.ShowType = DialogType.Alert;
else
	dialog.ShowType = DialogType.Confirm;
//显示对话框
dialog.ShowMsgBox(Content.Text);
</code></pre>

 </div> 
 
</div>
<br /><br />
 <b> 2.为页面元素添加确认对话框: </b>
<div id="Dialog2">

<ul style="height: 30px;"> <li><a href="#Dialog2-1"><span>　演　示　</span></a></li> <li><a href="#Dialog2-2"><span>　源　码　</span></a></li>  

</ul> 

<div id="Dialog2-1">
以下是消息对话框显示,可输入以下参数以查看不同效果:
<br /><br />

点击以下按钮:<br />
<Input Type="Button" Name="TestButton01" value="  Test ">
 </div> 
 
<div id="Dialog2-2"> 
服务器端代码：
<pre><code class="csharp">
Dialog dialog = new Dialog(this);
dialog.Title = "添加确认对话框测试";
dialog.ShowType = DialogType.Confirm;
dialog.ConfirmOK = " 确定 ";
dialog.ConfirmCancel = " 取消 ";
dialog.AddConfirmBox("你确定要这样做吗?","input", "TestButton");
</code></pre>

<br />
生成的前台JS代码：
<pre><code class="csharp">
$(document).ready(function(){
	$('input[name*="TestButton01"]').click(function(){
		$('body').append('<div id="Div1"></div>');
		$('#MsgBox').html('<div class="icon"></div>你确定要这样做吗?').css('display','block').dialog({
			title:'添加确认对话框测试 ', 
			modal: true,
			overlay: { opacity: 0.5, background: 'black' },
			buttons: { ' 确定 ': function() { $(this).dialog('close'); } ,
					   ' 取消 ': function() { $(this).dialog('close'); } },
			width:300,
			height:200,
			resizable:true,
			close:function(event,ui){
				$(this).dialog('destroy');},
			minHeight:180,
			minWidth:280,
			dialogClass:'flora'});
		});
});
</code></pre>
 </div> 
 
</div>

<br /><br />
 <b> 3.为页面元素添加确认对话框,同时可指定跳转的页面及添加参数: </b>
<div id="Dialog3">

<ul style="height: 30px;"> <li><a href="#Dialog3-1"><span>　演　示　</span></a></li> <li><a href="#Dialog3-2"><span>　源　码　</span></a></li>  

</ul> 

<div id="Dialog3-1">

<Input Type="Button" Name="TestButton02" value=" Test01 " para="pa01">&nbsp;&nbsp;
<Input Type="Button" Name="TestButton02" value=" Test02 " para="pa02">&nbsp;&nbsp;
<Input Type="Button" Name="TestButton02" value=" Test03 " para="pa03">&nbsp;&nbsp;
<Input Type="Button" Name="TestButton02" value=" Test04 " para="pa04">&nbsp;&nbsp;
<Input Type="Button" Name="TestButton02" value=" Test05 " para="pa05">&nbsp;&nbsp;

 </div> 
 
<div id="Dialog3-2"> 
服务器端代码：
<pre><code class="csharp">
Dialog dialog = new Dialog(this);
dialog.Title = "添加确认对话框测试";
dialog.ShowType = DialogType.Confirm;
dialog.ConfirmOK = " 确定 ";
dialog.ConfirmCancel = " 取消 ";

//指定要显示的信息
//指定要附加的元素(如input,div,a....)
//指定元素的name属性,如 "TestButton02"
//指定要跳转的页面名称,如 "Dialog" 即本页面,不需加后缀名,因为会自动判断有无使用URLRewrite
//指定要传递的参数属性名称, 如"para"
dialog.AddConfirmBox("你确定要这样做吗?","input", "TestButton02", "Dialog", "para");
</code></pre>

<br />
生成的前台JS代码：
<pre><code class="csharp">
$(document).ready(function(){
	$('input[name*="TestButton02"]').click(function(){
		$temp=$(this);
		$('body').append('<div id="MsgBox"></div>');
		$('#MsgBox').html('<div class="icon"></div>你确定要这样做吗?').css('display','block').dialog({
			title:'添加确认对话框测试 ', 
			modal: true,
			overlay: { opacity: 0.5, background: 'black' },
			buttons: { ' 确定 ': function() { 
				location.href='Dialog.aspx?para='+ $temp.attr('para') } ,' 取消 ': function() {
				$(this).dialog('close'); } },
			width:300,
			height:200,
			resizable:true,
			close:function(event,ui){
				$(this).dialog('destroy');},
			minHeight:180,
			minWidth:280,
			dialogClass:'flora'});
	});
});
</code></pre>

 </div> 
 
</div>
</form>
</p>

</asp:Content>

