﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using Winson.Framework.Controls;

public partial class DialogDemo : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            AddConfirm01();
            AddConfirm02();
        }
    }

    protected void ShowBase_Click(object sender, EventArgs e)
    {
        Dialog dialog = new Dialog(this);
        dialog.Title = Title.Text;
        if (IsResizable.SelectedValue.Equals("1"))
            dialog.Resizable = true;
        else
            dialog.Resizable = false;
        if (IsModel.SelectedValue.Equals("1"))
            dialog.Modal = true;
        else
            dialog.Modal = false;
        if (DaType.SelectedValue.Equals("1"))
            dialog.ShowType = DialogType.Alert;
        else
            dialog.ShowType = DialogType.Confirm;
        dialog.ShowMsgBox(Content.Text);
    }

    private void AddConfirm01()
    {
        Dialog dialog = new Dialog(this);
        dialog.Title = "添加确认对话框测试";
        dialog.ShowType = DialogType.Confirm;
        dialog.ConfirmOK = " 确定 ";
        dialog.ConfirmCancel = " 取消 ";
        dialog.AddConfirmBox("你确定要这样做吗?","input", "TestButton01");
    }

    private void AddConfirm02()
    {
        Dialog dialog = new Dialog(this);
        dialog.Title = "添加确认对话框测试";
        dialog.ShowType = DialogType.Confirm;
        dialog.ConfirmOK = " 确定 ";
        dialog.ConfirmCancel = " 取消 ";
        //指定要显示的信息
        //指定要附加的元素(如input,div,a....)
        //指定元素的name属性,如 "TestButton02"
        //指定要跳转的页面名称,如 "Dialog" 即本页面,不需加后缀名,因为会自动判断有无使用URLRewrite
        //指定要传递的参数属性名称, 如"para"
        dialog.AddConfirmBox("你确定要这样做吗?", "input", "TestButton02", "Dialog", "para");
    }

}
