﻿using System;
using System.Text;
using System.Collections;
using System.Configuration;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using Winson.EntityOP;
using Winson.EntityOP.Entity;
using Winson.Framework.Utility;

public partial class GridTest : System.Web.UI.Page
{
    Test test;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!String.IsNullOrEmpty(Request["action"]))
        {
            int totalpage = 0;
            int page = Convert.ToInt32(Request["page"]);
            int limit = Convert.ToInt32(Request["rows"])-1;
            string orderby = Request["sidx"];
            string order = Request["sord"];

            test = new Test();

            int totalCount = test.Count();
            //int totalCount = 0;

            List<TestDS> LTest = test.GetList(limit, page, null, orderby, order);

           // List<TestDS> LTest = null;

            if (totalCount > 0)
            {
                totalpage = totalCount / limit;
                if ((totalCount % limit) > 0) totalpage++;
            }
            else
                totalpage = 0;

            if (page > totalpage) page = totalpage;
           
            StringBuilder sb = new StringBuilder();
            sb.Append("<?xml version='1.0' encoding='utf-8'?>");
            sb.Append("<rows>");
            sb.Append("<page>" + page + "</page>");
            sb.Append("<total>" + totalpage + "</total>");
            sb.Append("<records>" + totalCount + "</records>");

            foreach (TestDS row in LTest)
            {
                sb.Append("<row id='" + row.Id + "'>");
                sb.Append("<cell></cell>");
                sb.Append("<cell>" + row.Id + "</cell>");
                sb.Append("<cell>" + row.Name + "</cell>");
                sb.Append("<cell>" + row.Age + "</cell>");
                sb.Append("<cell>" + row.Datetime + "</cell>");
                sb.Append("<cell>" + row.Isuse + "</cell>");
                sb.Append("<cell><![CDATA[" + row.Context + "]]></cell>");
                sb.Append("</row>");
            }
            sb.Append("</rows>");

            if (Response.ContentType == "application/xhtml+xml")
                Response.ContentType = "application/xhtml+xml;charset=utf-8";
            else
                Response.ContentType = "text/xml;charset=utf-8";

            Response.Write(sb.ToString());
            Response.End();
        }
    }
}
